<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Payrolls | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-view {
            background-color: #F3F2F1;
            color: #323130;
        }
        .action-btn-view:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-download {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        .action-btn-download:hover {
            background-color: #146CAA;
            color: white;
        }
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'My Payrolls', 'subtitle' => 'View and download your payroll information'])

        <main class="p-6">
            <!-- Action Bar -->
            <div class="bg-white rounded-lg border border-gray200 p-4 mb-6">
                <div class="flex flex-col md:flex-row md:items-center justify-between space-y-4 md:space-y-0">
                    <div>
                        <h2 class="text-lg font-semibold text-gray900">Payroll History</h2>
                        <p class="text-gray600 text-sm mt-1">{{ $payrolls->total() }} payroll record(s) found</p>
                    </div>
                    <div class="flex space-x-3">
                        <!-- Year Filter -->
                        <div>
                            <select id="yearFilter" class="quickbooks-input w-32">
                                <option value="all">All Years</option>
                                @foreach($years as $year)
                                    <option value="{{ $year }}" {{ request('year') == $year ? 'selected' : '' }}>
                                        {{ $year }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <!-- Status Filter -->
                        <div>
                            <select id="statusFilter" class="quickbooks-input w-40">
                                <option value="all">All Status</option>
                                <option value="paid" {{ request('status') == 'paid' ? 'selected' : '' }}>Paid</option>
                                <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                                <option value="calculated" {{ request('status') == 'calculated' ? 'selected' : '' }}>Calculated</option>
                                <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payrolls Table -->
            <div class="bg-white rounded-lg border border-gray200 overflow-hidden animate-fade-in">
                <div class="overflow-x-auto">
                    <table class="quickbooks-table">
                        <thead>
                            <tr>
                                <th>Period</th>
                                <th>Date Range</th>
                                <th>Gross Earnings</th>
                                <th>Deductions</th>
                                <th>Net Pay</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($payrolls as $payroll)
                            <tr class="hover:bg-gray100 transition-colors">
                                <td>
                                    <div class="font-medium text-gray900">{{ $payroll->payrollPeriod->period_name ?? 'N/A' }}</div>
                                </td>
                                <td>
                                    <div class="text-sm text-gray600">
                                        {{ \Carbon\Carbon::parse($payroll->period_start_date)->format('M d') }} - 
                                        {{ \Carbon\Carbon::parse($payroll->period_end_date)->format('M d, Y') }}
                                    </div>
                                </td>
                                <td>
                                    <div class="font-medium text-gray900">
                                        {{ $company->currency_symbol ?? 'K' }}{{ number_format($payroll->gross_earnings, 2) }}
                                    </div>
                                </td>
                                <td>
                                    <div class="text-red-600 font-medium">
                                        {{ $company->currency_symbol ?? 'K' }}{{ number_format($payroll->total_deductions, 2) }}
                                    </div>
                                </td>
                                <td>
                                    <div class="font-bold text-green-600">
                                        {{ $company->currency_symbol ?? 'K' }}{{ number_format($payroll->net_pay, 2) }}
                                    </div>
                                </td>
                                <td>
                                    <span class="quickbooks-badge 
                                        @if($payroll->calculation_status == 'paid') bg-green-100 text-green-800
                                        @elseif($payroll->calculation_status == 'approved') bg-blue-100 text-blue-800
                                        @elseif($payroll->calculation_status == 'calculated') bg-yellow-100 text-yellow-800
                                        @else bg-gray-100 text-gray-800 @endif">
                                        {{ ucfirst($payroll->calculation_status) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="flex items-center">
                                        <a href="{{ route('admin.self-service.payrolls.show', $payroll->id) }}" 
                                           class="action-btn action-btn-view"
                                           title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.self-service.payrolls.payslip', $payroll->id) }}" 
                                           class="action-btn action-btn-download"
                                           title="Download Payslip">
                                            <i class="fas fa-download"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-12">
                                    <div class="py-8 text-center">
                                        <div class="w-16 h-16 bg-gray100 rounded-full flex items-center justify-center mx-auto mb-4">
                                            <i class="fas fa-money-check-alt text-gray500 text-2xl"></i>
                                        </div>
                                        <h3 class="text-lg font-medium text-gray900 mb-2">No payroll records found</h3>
                                        <p class="text-gray600 mb-6 max-w-md mx-auto">
                                            You don't have any payroll records yet. Payroll records will appear here once they are processed.
                                        </p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($payrolls->hasPages())
                <div class="px-6 py-4 border-t border-gray200">
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-gray600">
                            Showing {{ $payrolls->firstItem() }} to {{ $payrolls->lastItem() }} of {{ $payrolls->total() }} results
                        </div>
                        <div class="flex space-x-2">
                            @if($payrolls->onFirstPage())
                            <span class="px-3 py-1 bg-gray100 text-gray500 rounded text-sm">Previous</span>
                            @else
                            <a href="{{ $payrolls->previousPageUrl() }}" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">Previous</a>
                            @endif
                            
                            @foreach($payrolls->getUrlRange(1, $payrolls->lastPage()) as $page => $url)
                                @if($page == $payrolls->currentPage())
                                <span class="px-3 py-1 bg-primary text-white rounded text-sm">{{ $page }}</span>
                                @else
                                <a href="{{ $url }}" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">{{ $page }}</a>
                                @endif
                            @endforeach
                            
                            @if($payrolls->hasMorePages())
                            <a href="{{ $payrolls->nextPageUrl() }}" class="px-3 py-1 bg-gray100 text-gray700 hover:bg-gray200 rounded text-sm">Next</a>
                            @else
                            <span class="px-3 py-1 bg-gray100 text-gray500 rounded text-sm">Next</span>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Filter functionality
            const yearFilter = document.getElementById('yearFilter');
            const statusFilter = document.getElementById('statusFilter');
            
            function applyFilters() {
                const year = yearFilter.value;
                const status = statusFilter.value;
                let url = '{{ route("admin.accounting.self-service.payrolls.index") }}';
                let params = [];
                
                if (year !== 'all') {
                    params.push(`year=${year}`);
                }
                
                if (status !== 'all') {
                    params.push(`status=${status}`);
                }
                
                if (params.length > 0) {
                    url += '?' + params.join('&');
                }
                
                window.location.href = url;
            }
            
            yearFilter.addEventListener('change', applyFilters);
            statusFilter.addEventListener('change', applyFilters);

            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
        });
    </script>
</body>
</html>