<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Currency | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'View Currency', 'subtitle' => 'Currency details'])

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Currency Details</h2>
                        <p class="text-gray-600">View detailed information about this currency</p>
                    </div>

                    <div class="p-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Code -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Currency Code</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $currency->code }}
                                </div>
                            </div>

                            <!-- Name -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Currency Name</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $currency->name }}
                                </div>
                            </div>

                            <!-- Symbol -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Symbol</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $currency->symbol }}
                                </div>
                            </div>

                            <!-- Native Symbol -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Native Symbol</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $currency->symbol_native ?: 'N/A' }}
                                </div>
                            </div>

                            <!-- Decimal Digits -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Decimal Digits</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $currency->decimal_digits }}
                                </div>
                            </div>

                            <!-- Rounding -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Rounding</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ number_format($currency->rounding, 2) }}
                                </div>
                            </div>

                            <!-- Status -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $currency->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $currency->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </div>

                            <!-- Chart of Accounts Count -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Chart of Accounts</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $currency->chartOfAccounts->count() }} accounts
                                </div>
                            </div>

                            <!-- Currency Rates -->
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Currency Rates</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    <div>Base Currency Rates: {{ $currency->baseCurrencyRates->count() }}</div>
                                    <div>Target Currency Rates: {{ $currency->targetCurrencyRates->count() }}</div>
                                </div>
                            </div>

                            <!-- Created/Updated Info -->
                            <div class="md:col-span-2 border-t pt-6 mt-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-600">
                                    <div>
                                        <span class="font-medium">Created:</span> 
                                        {{ $currency->created_at->format('M j, Y g:i A') }}
                                    </div>
                                    <div>
                                        <span class="font-medium">Last Updated:</span> 
                                        {{ $currency->updated_at->format('M j, Y g:i A') }}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="mt-8 flex justify-end space-x-3">
                            <a href="{{ route('admin.accounting.settings.currencies.index') }}" 
                               class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                Back to List
                            </a>
                            <a href="{{ route('admin.accounting.settings.currencies.edit', $currency->id) }}" 
                               class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                                Edit Currency
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>