<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Currency Rate Details | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Currency Rate Details', 'subtitle' => 'View exchange rate information'])

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <!-- Back Button -->
                <div class="mb-6">
                    <a href="{{ route('admin.accounting.settings.currency-rates.index') }}" 
                       class="inline-flex items-center text-blue-600 hover:text-blue-700 font-medium">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to Currency Rates
                    </a>
                </div>

                <!-- Action Buttons -->
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Exchange Rate Details</h2>
                        <p class="text-gray-600">View and manage currency rate information</p>
                    </div>
                    <div class="flex items-center space-x-3">
                        <a href="{{ route('admin.accounting.settings.currency-rates.edit', $currencyRate->id) }}" 
                           class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg font-medium flex items-center space-x-2">
                            <i class="fas fa-edit"></i>
                            <span>Edit Rate</span>
                        </a>
                        <form action="{{ route('admin.accounting.settings.currency-rates.destroy', $currencyRate->id) }}" 
                              method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" 
                                    class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg font-medium flex items-center space-x-2"
                                    onclick="return confirm('Are you sure you want to delete this currency rate?')">
                                <i class="fas fa-trash"></i>
                                <span>Delete</span>
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Details Card -->
                <div class="bg-white rounded-xl shadow-sm border mb-6">
                    <div class="px-6 py-4 border-b">
                        <h3 class="text-lg font-semibold text-gray-900">Rate Information</h3>
                    </div>
                    <div class="p-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Exchange Rate Summary -->
                            <div class="col-span-2">
                                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 text-center">
                                    <h4 class="text-lg font-semibold text-blue-900 mb-2">Exchange Rate</h4>
                                    <p class="text-2xl font-bold text-blue-700">
                                        1 USD = {{ number_format($currencyRate->exchange_rate, 6) }} {{ $currencyRate->currency->code ?? 'N/A' }}
                                    </p>
                                </div>
                            </div>

                            <!-- Currency -->
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Currency</label>
                                <p class="text-lg font-semibold text-gray-900">
                                    {{ $currencyRate->currency->code ?? 'N/A' }} - {{ $currencyRate->currency->name ?? 'N/A' }}
                                </p>
                                @if($currencyRate->currency)
                                    <p class="text-sm text-gray-600 mt-1">
                                        Symbol: {{ $currencyRate->currency->symbol }}
                                    </p>
                                @endif
                            </div>

                            <!-- Exchange Rate -->
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Exchange Rate</label>
                                <p class="text-lg font-semibold text-gray-900">
                                    {{ number_format($currencyRate->exchange_rate, 6) }}
                                </p>
                            </div>

                            <!-- Rate Date -->
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Rate Date</label>
                                <p class="text-lg font-semibold text-gray-900">
                                    {{ $currencyRate->rate_date->format('F d, Y') }}
                                </p>
                            </div>

                            <!-- Status -->
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Status</label>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $currencyRate->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $currencyRate->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </div>

                            <!-- Created Information -->
                            <div class="col-span-2 border-t pt-4 mt-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-600">
                                    <div>
                                        <label class="font-medium text-gray-500">Created At:</label>
                                        <p>{{ $currencyRate->created_at->format('F d, Y \a\t h:i A') }}</p>
                                    </div>
                                    <div>
                                        <label class="font-medium text-gray-500">Last Updated:</label>
                                        <p>{{ $currencyRate->updated_at->format('F d, Y \a\t h:i A') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="px-6 py-4 border-b">
                        <h3 class="text-lg font-semibold text-gray-900">Quick Actions</h3>
                    </div>
                    <div class="p-6">
                        <div class="flex flex-wrap gap-4">
                            <a href="{{ route('admin.accounting.settings.currency-rates.create') }}" 
                               class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium flex items-center space-x-2">
                                <i class="fas fa-plus"></i>
                                <span>Add New Rate</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.currency-rates.edit', $currencyRate->id) }}" 
                               class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg font-medium flex items-center space-x-2">
                                <i class="fas fa-edit"></i>
                                <span>Edit This Rate</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.currencies.index') }}" 
                               class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg font-medium flex items-center space-x-2">
                                <i class="fas fa-money-bill-wave"></i>
                                <span>Manage Currencies</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>