<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Financial Year | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Create Financial Year', 'subtitle' => 'Add a new financial year'])

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <!-- Active Year Warning -->
                @if($activeYear)
                <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-6">
                    <div class="flex">
                        <i class="fas fa-exclamation-triangle text-yellow-400 mt-0.5 mr-3"></i>
                        <div>
                            <h4 class="text-sm font-medium text-yellow-800">Active Financial Year Exists</h4>
                            <p class="text-sm text-yellow-700 mt-1">
                                There is already an active financial year: <strong>{{ $activeYear->year_name }}</strong> 
                                ({{ $activeYear->start_date->format('M j, Y') }} - {{ $activeYear->end_date->format('M j, Y') }}).
                                You can only have one active financial year at a time.
                            </p>
                        </div>
                    </div>
                </div>
                @endif

                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Financial Year Information</h2>
                        <p class="text-gray-600">Fill in the details for the new financial year</p>
                    </div>

                    <form action="{{ route('admin.accounting.settings.financial-years.store') }}" method="POST" class="p-6">
                        @csrf

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Year -->
                            <div class="md:col-span-2">
                                <label for="year" class="block text-sm font-medium text-gray-700 mb-2">Year *</label>
                                <input type="text" 
                                       name="year" 
                                       id="year"
                                       value="{{ old('year') }}"
                                       placeholder="e.g., 2024"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                       required>
                                @error('year')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Start Date -->
                            <div>
                                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-2">Start Date *</label>
                                <input type="date" 
                                       name="start_date" 
                                       id="start_date"
                                       value="{{ old('start_date') }}"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                       required>
                                @error('start_date')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- End Date -->
                            <div>
                                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-2">End Date *</label>
                                <input type="date" 
                                       name="end_date" 
                                       id="end_date"
                                       value="{{ old('end_date') }}"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                       required>
                                @error('end_date')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Status Options -->
                            <div class="md:col-span-2 space-y-4">
                                <!-- Active Status -->
                                <div class="flex items-center">
                                    <input type="checkbox" 
                                           name="is_active" 
                                           id="is_active"
                                           value="1"
                                           {{ old('is_active', !$activeYear) ? 'checked' : '' }}
                                           {{ $activeYear ? 'disabled' : '' }}
                                           class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500 {{ $activeYear ? 'opacity-50 cursor-not-allowed' : '' }}">
                                    <label for="is_active" class="ml-2 block text-sm {{ $activeYear ? 'text-gray-500' : 'text-gray-700' }}">
                                        This financial year is active
                                        @if($activeYear)
                                            <span class="text-xs text-yellow-600 block">(Cannot activate - another year is active)</span>
                                        @endif
                                    </label>
                                </div>

                                <!-- Closed Status -->
                                <div class="flex items-center">
                                    <input type="checkbox" 
                                           name="is_closed" 
                                           id="is_closed"
                                           value="1"
                                           {{ old('is_closed') ? 'checked' : '' }}
                                           class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                    <label for="is_closed" class="ml-2 block text-sm text-gray-700">
                                        This financial year is closed
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="mt-8 flex justify-end space-x-3">
                            <a href="{{ route('admin.accounting.settings.financial-years.index') }}" 
                               class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                Cancel
                            </a>
                            <button type="submit" 
                                    class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                                Create Financial Year
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Date validation
        document.addEventListener('DOMContentLoaded', function() {
            const startDate = document.getElementById('start_date');
            const endDate = document.getElementById('end_date');
            
            startDate.addEventListener('change', function() {
                if (startDate.value && endDate.value && startDate.value > endDate.value) {
                    endDate.value = '';
                }
            });

            // Auto-fill year based on start date
            startDate.addEventListener('change', function() {
                if (startDate.value) {
                    const yearInput = document.getElementById('year');
                    const year = new Date(startDate.value).getFullYear();
                    if (!yearInput.value) {
                        yearInput.value = year;
                    }
                }
            });
        });
    </script>
</body>
</html>