<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Financial Year | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'View Financial Year', 'subtitle' => 'Financial year details'])

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Financial Year Details</h2>
                        <p class="text-gray-600">View detailed information about this financial year</p>
                    </div>

                    <div class="p-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Year Name -->
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Year Name</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $financialYear->year_name }}
                                </div>
                            </div>

                            <!-- Year -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Year</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $financialYear->year }}
                                </div>
                            </div>

                            <!-- Duration -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Duration</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $financialYear->start_date->diffInDays($financialYear->end_date) + 1 }} days
                                </div>
                            </div>

                            <!-- Start Date -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Start Date</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $financialYear->start_date->format('F j, Y') }}
                                </div>
                            </div>

                            <!-- End Date -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">End Date</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $financialYear->end_date->format('F j, Y') }}
                                </div>
                            </div>

                            <!-- Status -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Active Status</label>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $financialYear->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                    {{ $financialYear->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </div>

                            <!-- Closure Status -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Closure Status</label>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $financialYear->is_closed ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800' }}">
                                    {{ $financialYear->is_closed ? 'Closed' : 'Open' }}
                                </span>
                            </div>

                            <!-- Journal Entries Count -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Journal Entries</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    {{ $financialYear->journalEntries->count() }} entries
                                </div>
                            </div>

                            <!-- Closed Information -->
                            @if($financialYear->is_closed)
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Closure Information</label>
                                <div class="text-sm text-gray-900 bg-gray-50 px-3 py-2 rounded-lg border">
                                    <div>Closed by: {{ $financialYear->closedBy->name ?? 'System' }}</div>
                                    <div>Closed at: {{ $financialYear->closed_at->format('F j, Y g:i A') }}</div>
                                </div>
                            </div>
                            @endif

                            <!-- Created/Updated Info -->
                            <div class="md:col-span-2 border-t pt-6 mt-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-600">
                                    <div>
                                        <span class="font-medium">Created:</span> 
                                        {{ $financialYear->created_at->format('M j, Y g:i A') }}
                                    </div>
                                    <div>
                                        <span class="font-medium">Last Updated:</span> 
                                        {{ $financialYear->updated_at->format('M j, Y g:i A') }}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="mt-8 flex justify-end space-x-3">
                            <a href="{{ route('admin.accounting.settings.financial-years.index') }}" 
                               class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                Back to List
                            </a>
                            <a href="{{ route('admin.accounting.settings.financial-years.edit', $financialYear->id) }}" 
                               class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                                Edit Financial Year
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>