@php
    $pageTitle = 'Disbursed Applications';
    $pageSubtitle = 'Applications that have been disbursed';
    $themeBlue = '#0077C5';
    $themeBlueDark = '#005A94';
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --zedbank-blue: {{ $themeBlue }}; --zedbank-blue-dark: {{ $themeBlueDark }}; }
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    @include('accounting.partials.sidebar')
    <div class="lg:ml-64 min-h-screen">
        @include('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle])
        <main class="p-6">
            <div class="max-w-7xl mx-auto">
                <div class="mb-6 flex items-center justify-between">
                    <a href="{{ route('admin.applications.index') }}" class="inline-flex items-center text-zedbank-blue hover:text-zedbank-blue-dark font-medium">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Applications
                    </a>
                    <div class="text-sm text-gray-600">
                        <i class="fas fa-money-check-alt text-purple-500 mr-1"></i>
                        <span class="font-semibold">{{ $applications->total() }}</span> disbursed applications
                    </div>
                </div>

                @if($applications->isEmpty())
                    <div class="bg-white rounded-xl shadow-sm border p-8 text-center">
                        <div class="mx-auto w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mb-4">
                            <i class="fas fa-money-check-alt text-purple-500 text-2xl"></i>
                        </div>
                        <h3 class="text-lg font-medium text-gray-900 mb-2">No Disbursed Applications</h3>
                        <p class="text-gray-500">There are no disbursed applications at the moment.</p>
                    </div>
                @else
                    <div class="bg-white rounded-xl shadow-sm border overflow-hidden">
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Application Details</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Loan Details</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Disbursement Details</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Loan Number</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($applications as $application)
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="flex items-center">
                                                    <div class="flex-shrink-0 h-10 w-10 bg-purple-100 rounded-full flex items-center justify-center">
                                                        <i class="fas fa-money-check-alt text-purple-600"></i>
                                                    </div>
                                                    <div class="ml-4">
                                                        <div class="text-sm font-medium text-gray-900">{{ $application->application_number }}</div>
                                                        <div class="text-sm text-gray-500">{{ $application->product->product ?? 'N/A' }}</div>
                                                        <div class="text-xs text-gray-400">{{ $application->created_at->format('M d, Y') }}</div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900">{{ $application->customer->first_name }} {{ $application->customer->surname }}</div>
                                                <div class="text-sm text-gray-500">{{ $application->customer->customer_number }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900"><span class="font-medium">{{ number_format($application->loan_amount, 2) }}</span> {{ $application->currency->code ?? 'ZMW' }}</div>
                                                <div class="text-sm text-gray-500">{{ $application->loan_tenure }} {{ $application->payment_frequency === 'monthly' ? 'Months' : 'Periods' }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900">{{ $application->disbursed_at ? $application->disbursed_at->format('M d, Y') : 'N/A' }}</div>
                                                <div class="text-sm text-gray-500">By: {{ $application->disbursedBy->name ?? 'Admin' }}</div>
                                                <div class="text-xs text-gray-500">{{ $application->suggestedpaymentmethod }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900">{{ $application->loan_id ?? 'N/A' }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <div class="flex space-x-2">
                                                    <a href="{{ route('admin.applications.show', $application->id) }}" class="text-blue-600 hover:text-blue-900" title="View"><i class="fas fa-eye"></i></a>
                                                    <a href="{{ route('admin.loans.show', $application->loan_id) }}" class="text-green-600 hover:text-green-900" title="View Loan"><i class="fas fa-hand-holding-usd"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="bg-white px-4 py-3 border-t border-gray-200 sm:px-6">{{ $applications->links() }}</div>
                    </div>
                @endif
            </div>
        </main>
    </div>
</body>
</html>