@php
    $pageTitle = 'Edit Loan Application';
    $pageSubtitle = 'Update details for application: ' . $application->application_number;
    $themeBlue = '#0077C5';
    $themeBlueDark = '#005A94';
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        :root { 
            --zedbank-blue: {{ $themeBlue }}; 
            --zedbank-blue-dark: {{ $themeBlueDark }}; 
        }
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        .compact-input { padding: 10px 14px; font-size: 0.875rem; }
        .compact-label { font-size: 0.875rem; }
        .detail-label { font-size: 0.75rem; color: #6b7280; }
        .detail-value { font-size: 0.875rem; font-weight: 600; }
        
        .loading-spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #0077C5;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .backdate-warning {
            display: none;
            animation: fadeIn 0.3s ease-in;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Quick Actions Container */
        .quick-actions-container {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
            align-items: center;
        }
        
        @media (max-width: 768px) {
            .quick-actions-container {
                margin-top: 1rem;
                width: 100%;
            }
        }
        
        .quick-action-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            border-radius: 0.375rem;
            font-weight: 500;
            font-size: 0.875rem;
            white-space: nowrap;
        }
        
        /* Modal styles */
        .modal-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 50;
            align-items: center;
            justify-content: center;
        }
        
        .modal-content {
            background: white;
            border-radius: 0.5rem;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            max-height: 90vh;
            overflow-y: auto;
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64 min-h-screen">
        @include('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle])

        <main class="p-6">
            <div class="max-w-7xl mx-auto">
                <!-- Top Section with Back Button and Quick Actions -->
                <div class="mb-6 flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                    <!-- Back Button -->
                    <a href="{{ route('admin.applications.show', $application->id) }}" class="inline-flex items-center text-zedbank-blue hover:text-zedbank-blue-dark font-medium w-fit">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Application
                    </a>
                    
                    <!-- Quick Actions - Horizontal on right -->
                    <div class="quick-actions-container">
                        <button onclick="showUploadModal()" 
                                class="quick-action-btn bg-zedbank-blue text-white hover:bg-zedbank-blue-dark">
                            <i class="fas fa-upload mr-2"></i> Upload Documents
                        </button>
                        
                        <a href="{{ route('admin.applications.schedule.view', $application->id) }}" 
                           class="quick-action-btn border border-blue-300 text-blue-700 bg-blue-50 hover:bg-blue-100">
                            <i class="fas fa-calendar-alt mr-2"></i> View Schedule
                        </a>
                        
                        <a href="{{ route('admin.applications.schedule.pdf', $application->id) }}" 
                           class="quick-action-btn border border-green-300 text-green-700 bg-green-50 hover:bg-green-100">
                            <i class="fas fa-file-pdf mr-2"></i> Download PDF
                        </a>
                        
                        @if($application->status == 'approved' && !$application->disbursed_at)
                            <a href="{{ route('admin.applications.disburse', $application->id) }}" 
                               class="quick-action-btn bg-zedbank-blue text-white hover:bg-zedbank-blue-dark">
                                <i class="fas fa-money-bill-wave mr-2"></i> Process Disbursement
                            </a>
                        @endif
                    </div>
                </div>

                {{-- Display validation errors --}}
                @if ($errors->any())
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <i class="fas fa-exclamation-triangle text-red-500"></i>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-red-800">
                                There were {{ $errors->count() }} error(s) with your submission
                            </h3>
                            <div class="mt-2 text-sm text-red-700">
                                <ul class="list-disc pl-5 space-y-1">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <form action="{{ route('admin.applications.update', $application->id) }}" method="POST" id="application-form">
                    @csrf
                    @method('PUT')
                    
                    <div class="space-y-6">
                        
                        {{-- CARD 1: CUSTOMER SELECTION (Read-only) --}}
                        <div class="bg-white rounded-xl shadow-sm border p-4">
                            <h2 class="text-lg font-bold text-gray-900 flex items-center mb-4">
                                <i class="fas fa-user-check mr-3 text-zedbank-blue"></i> Selected Customer
                            </h2>
                            <input type="hidden" name="customer_id" value="{{ $application->customer_id }}">
                            <div class="compact-input bg-gray-50 border rounded-lg font-semibold">
                                {{ $application->customer->first_name }} {{ $application->customer->surname }} ({{ $application->customer->customer_number }})
                            </div>
                        </div>

                        {{-- CARD 2: CUSTOMER INFORMATION --}}
                        <div class="bg-white rounded-xl shadow-sm border">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-address-card mr-3 text-zedbank-blue"></i>
                                    Customer Information
                                </h2>
                            </div>
                            <div class="p-4">
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div><label class="block text-gray-700 compact-label font-medium mb-2">Title</label>
                                         <input type="text" name="title" value="{{ $application->title ?? $application->customer->title ?? '' }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                    <div><label class="block text-gray-700 compact-label font-medium mb-2">First Name</label>
                                         <input type="text" name="first_name" value="{{ $application->first_name ?? $application->customer->first_name ?? '' }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                    <div><label class="block text-gray-700 compact-label font-medium mb-2">Surname</label>
                                         <input type="text" name="surname" value="{{ $application->surname ?? $application->customer->surname ?? '' }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                    <div><label class="block text-gray-700 compact-label font-medium mb-2">NRC No.</label>
                                         <input type="text" name="nrc_no" value="{{ $application->nrc_no ?? $application->customer->number ?? '' }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                    <div><label class="block text-gray-700 compact-label font-medium mb-2">Mobile No.</label>
                                         <input type="text" name="phone" value="{{ $application->phone ?? $application->customer->phone ?? '' }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                    <div><label class="block text-gray-700 compact-label font-medium mb-2">Email</label>
                                         <input type="email" name="email" value="{{ $application->email ?? $application->customer->email ?? '' }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                </div>
                                <div class="mt-4 pt-4 border-t border-gray-200">
                                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                        <div class="md:col-span-2"><label class="block text-gray-700 compact-label font-medium mb-2">Physical Address</label>
                                             <input type="text" name="physical_address" value="{{ $application->physical_address ?? $application->customer->address ?? '' }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                        <div><label class="block text-gray-700 compact-label font-medium mb-2">Town</label>
                                             <input type="text" name="town" value="{{ $application->town ?? $application->customer->town ?? '' }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- CARD 3: EMPLOYMENT DETAILS --}}
                        <div class="bg-white rounded-xl shadow-sm border">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-briefcase mr-3 text-zedbank-blue"></i>
                                    Employment Details
                                </h2>
                            </div>
                            <div class="p-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    {{-- Column 1 --}}
                                    <div class="space-y-4">
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Job Title</label>
                                            <input type="text" name="job_title" value="{{ $application->job_title }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Employer Name</label>
                                            <input type="text" name="employer_name" value="{{ $application->employer_name }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Employment Type</label>
                                            <select name="employment_type" class="w-full compact-input border border-gray-300 rounded-lg">
                                                <option value="">Select Type</option>
                                                <option value="permanent" {{ $application->employment_type == 'permanent' ? 'selected' : '' }}>Permanent</option>
                                                <option value="contract" {{ $application->employment_type == 'contract' ? 'selected' : '' }}>Contract</option>
                                                <option value="temporary" {{ $application->employment_type == 'temporary' ? 'selected' : '' }}>Temporary</option>
                                                <option value="casual" {{ $application->employment_type == 'casual' ? 'selected' : '' }}>Casual</option>
                                                <option value="self_employed" {{ $application->employment_type == 'self_employed' ? 'selected' : '' }}>Self Employed</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Gross Salary</label>
                                            <input type="number" name="gross_salary" value="{{ $application->gross_salary }}" step="0.01" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Employee Number</label>
                                            <input type="text" name="employee_number" value="{{ $application->employee_number }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                    </div>

                                    {{-- Column 2 --}}
                                    <div class="space-y-4">
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Net Salary</label>
                                            <input type="number" name="net_salary" value="{{ $application->net_salary }}" step="0.01" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Years of Employment</label>
                                            <input type="number" name="employment_years" value="{{ $application->employment_years }}" step="0.1" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Contract Expiry Date</label>
                                            <input type="date" name="contract_expiry_date" value="{{ $application->contract_expiry_date ? \Carbon\Carbon::parse($application->contract_expiry_date)->format('Y-m-d') : '' }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Retirement Year</label>
                                            <input type="number" name="retirement_year" value="{{ $application->retirement_year }}" min="{{ date('Y') }}" max="2100" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                    </div>
                                </div>

                                {{-- Employer Address Section --}}
                                <div class="mt-6 pt-4 border-t border-gray-200">
                                    <h3 class="font-bold text-gray-800 mb-3">Employer Address</h3>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Physical Address</label>
                                            <input type="text" name="employer_physical_address" value="{{ $application->employer_physical_address }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Postal Address</label>
                                            <input type="text" name="employer_postal_address" value="{{ $application->employer_postal_address }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Town/Province</label>
                                            <input type="text" name="employer_town_province" value="{{ $application->employer_town_province }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- CARD 4: NEXT OF KIN DETAILS --}}
                        <div class="bg-white rounded-xl shadow-sm border mt-6">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-users mr-3 text-zedbank-blue"></i>
                                    Next of Kin Details
                                </h2>
                            </div>
                            <div class="p-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    {{-- Personal Details --}}
                                    <div class="space-y-4">
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Surname</label>
                                            <input type="text" name="kin_surname" value="{{ $application->kin_surname }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">First Name</label>
                                            <input type="text" name="kin_first_name" value="{{ $application->kin_first_name }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Relationship</label>
                                            <select name="kin_relationship" class="w-full compact-input border border-gray-300 rounded-lg">
                                                <option value="">Select Relationship</option>
                                                <option value="spouse" {{ $application->kin_relationship == 'spouse' ? 'selected' : '' }}>Spouse</option>
                                                <option value="parent" {{ $application->kin_relationship == 'parent' ? 'selected' : '' }}>Parent</option>
                                                <option value="child" {{ $application->kin_relationship == 'child' ? 'selected' : '' }}>Child</option>
                                                <option value="sibling" {{ $application->kin_relationship == 'sibling' ? 'selected' : '' }}>Sibling</option>
                                                <option value="relative" {{ $application->kin_relationship == 'relative' ? 'selected' : '' }}>Relative</option>
                                                <option value="friend" {{ $application->kin_relationship == 'friend' ? 'selected' : '' }}>Friend</option>
                                                <option value="other" {{ $application->kin_relationship == 'other' ? 'selected' : '' }}>Other</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Email</label>
                                            <input type="email" name="kin_email" value="{{ $application->kin_email }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                    </div>

                                    {{-- Contact Details --}}
                                    <div class="space-y-4">
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Telephone</label>
                                            <input type="text" name="kin_telephone" value="{{ $application->kin_telephone }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Country</label>
                                            <select name="kin_country" class="w-full compact-input border border-gray-300 rounded-lg">
                                                <option value="Zambia" {{ $application->kin_country == 'Zambia' ? 'selected' : '' }}>Zambia</option>
                                                <option value="Other" {{ $application->kin_country == 'Other' ? 'selected' : '' }}>Other</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Province</label>
                                            <input type="text" name="kin_province" value="{{ $application->kin_province }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                    </div>
                                </div>

                                {{-- Address Section --}}
                                <div class="mt-6 pt-4 border-t border-gray-200">
                                    <h3 class="font-bold text-gray-800 mb-3">Next of Kin Address</h3>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Physical Address</label>
                                            <input type="text" name="kin_physical_address" value="{{ $application->kin_physical_address }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Postal Address</label>
                                            <input type="text" name="kin_postal_address" value="{{ $application->kin_postal_address }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2">Town</label>
                                            <input type="text" name="kin_town" value="{{ $application->kin_town }}" class="w-full compact-input border border-gray-300 rounded-lg">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- CARD 5: LOAN DETAILS --}}
                        <div class="bg-white rounded-xl shadow-sm border mt-6">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-file-invoice-dollar mr-3 text-zedbank-blue"></i>
                                    Loan Details
                                </h2>
                            </div>
                            <div class="p-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div class="space-y-4">
                                        {{-- 1. Loan Product --}}
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2" for="product_id">
                                                <span class="text-red-500">*</span> Loan Product
                                            </label>
                                            <select name="product_id" id="product_id" 
                                                    class="w-full compact-input border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                                                    onchange="updateInterestRateFromProduct(this); calculateInstallment();"
                                                    required>
                                                <option value="">Select Loan Product</option>
                                                @foreach($loanProducts as $product)
                                                    <option value="{{ $product->id }}" 
                                                            data-daily-rate="{{ $product->dailyrate ?? 0 }}"
                                                            data-weekly-rate="{{ $product->weeklyrate ?? 0 }}"
                                                            data-monthly-rate="{{ $product->monthlyrate ?? 0 }}"
                                                            data-yearly-rate="{{ $product->yearlyrate ?? 0 }}"
                                                            data-admin-fee="{{ $product->adminfee ?? 0 }}"
                                                            data-insurance-fee="{{ $product->insurancefee ?? 0 }}"
                                                            data-processing-fee="{{ $product->processing_fee ?? 0 }}"
                                                            data-processing-fee-basis="{{ $product->processing_fee_basis ?? 'initial_amount' }}"
                                                            data-penalty-rate="{{ $product->penalty_rate ?? 0 }}"
                                                            data-penalty-basis="{{ $product->penalty_basis ?? 'percentage_of_due' }}"
                                                            data-interest-method="{{ $product->interest_method ?? 'reducing_balance' }}"
                                                            {{ $application->product_id == $product->id ? 'selected' : '' }}>
                                                        {{ $product->product }} ({{ $product->yearlyrate }}%)
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        {{-- 2. Payment Frequency --}}
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2" for="payment_frequency">
                                                <span class="text-red-500">*</span> Payment Frequency
                                            </label>
                                            <select name="payment_frequency" id="payment_frequency" 
                                                    class="w-full compact-input border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                                                    onchange="updateTenureLabel(); updateInterestRateFromProduct(document.getElementById('product_id')); calculateInstallment();"
                                                    required>
                                                <option value="">Select Frequency</option>
                                                <option value="one_off" {{ $application->payment_frequency == 'one_off' ? 'selected' : '' }}>One-off Payment</option>
                                                <option value="daily" {{ $application->payment_frequency == 'daily' ? 'selected' : '' }}>Daily</option>
                                                <option value="weekly" {{ $application->payment_frequency == 'weekly' ? 'selected' : '' }}>Weekly</option>
                                                <option value="monthly" {{ $application->payment_frequency == 'monthly' ? 'selected' : '' }}>Monthly</option>
                                                <option value="quarterly" {{ $application->payment_frequency == 'quarterly' ? 'selected' : '' }}>Quarterly</option>
                                            </select>
                                        </div>

                                        {{-- 3. Interest Method --}}
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2" for="interest_method">
                                                <span class="text-red-500">*</span> Interest Method
                                            </label>
                                            <select name="interest_method" id="interest_method" 
                                                    class="w-full compact-input border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                                                    onchange="calculateInstallment()"
                                                    required>
                                                <option value="">Select Method</option>
                                                <option value="simple_interest" {{ $application->interest_method == 'simple_interest' ? 'selected' : '' }}>Simple Interest</option>
                                                <option value="reducing_balance" {{ $application->interest_method == 'reducing_balance' ? 'selected' : '' }}>Reducing Balance</option>
                                            </select>
                                        </div>

                                        {{-- 4. Interest Rate --}}
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2" for="interest_rate">
                                                <span class="text-red-500">*</span> Interest Rate (%)
                                            </label>
                                            <div class="relative">
                                                <input type="number" name="interest_rate" id="interest_rate" value="{{ $application->interest_rate }}" step="0.01" class="w-full px-4 compact-input border border-gray-300 rounded-lg" oninput="calculateInstallment()" required>
                                                <span class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-500">%</span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="space-y-4">
                                        {{-- 5. Currency --}}
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2" for="currency_id">
                                                <span class="text-red-500">*</span> Currency
                                            </label>
                                            <select name="currency_id" id="currency_id" class="w-full compact-input border border-gray-300 rounded-lg" onchange="updateCurrencySymbols(this); calculateInstallment();" required>
                                                <option value="">Select Currency</option>
                                                @foreach($currencies as $currency)
                                                    <option value="{{ $currency->id }}" data-symbol="{{ $currency->symbol }}" {{ $application->currency_id == $currency->id ? 'selected' : '' }}>{{ $currency->code }} - {{ $currency->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        {{-- 6. Loan Tenure --}}
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2" for="loan_tenure">
                                                <span class="text-red-500">*</span> <span id="tenure-label-text">Loan Tenure (Months)</span>
                                            </label>
                                            <input type="number" name="loan_tenure" id="loan_tenure" value="{{ $application->loan_tenure }}" class="w-full compact-input border border-gray-300 rounded-lg" oninput="calculateInstallment()" required>
                                        </div>
                                        
                                        {{-- 7. Loan Amount --}}
                                        <div>
                                            <label class="block text-gray-700 compact-label font-medium mb-2" for="loan_amount">
                                                <span class="text-red-500">*</span> Loan Amount
                                            </label>
                                            <div class="relative">
                                                <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-500 currency-symbol-text">{{ $application->currency->symbol ?? 'ZMW' }}</span>
                                                <input type="number" name="loan_amount" id="loan_amount" value="{{ $application->loan_amount }}" step="0.01" class="w-full pl-12 compact-input border border-gray-300 rounded-lg" oninput="calculateInstallment()" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- CARD 6: FEES AND PENALTY TERMS --}}
                        <div class="bg-white rounded-xl shadow-sm border mt-6">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-clipboard-list mr-3 text-zedbank-blue"></i>
                                    Fees & Penalty Terms
                                </h2>
                            </div>
                            <div class="p-4 grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div>
                                    <label class="block text-gray-700 compact-label font-medium mb-2">Processing Fee</label>
                                    <div class="compact-input bg-gray-50 border border-gray-200 rounded-lg">
                                        <span id="fee_processing_rate">{{ number_format($application->processing_fee, 2) }}%</span> on <span id="fee_processing_basis">{{ $application->processing_fee_basis ? str_replace('_', ' ', $application->processing_fee_basis) : 'Initial Amount' }}</span>
                                    </div>
                                    <input type="hidden" name="processing_fee" id="hidden_processing_fee" value="{{ $application->processing_fee }}">
                                    <input type="hidden" name="processing_fee_basis" id="hidden_processing_fee_basis" value="{{ $application->processing_fee_basis }}">
                                </div>
                                <div>
                                    <label class="block text-gray-700 compact-label font-medium mb-2">Admin Fee</label>
                                    <div class="compact-input bg-gray-50 border border-gray-200 rounded-lg" id="fee_admin_rate">{{ number_format($application->adminfee, 2) }}</div>
                                    <input type="hidden" name="adminfee" id="hidden_admin_fee" value="{{ $application->adminfee }}">
                                </div>
                                <div>
                                    <label class="block text-gray-700 compact-label font-medium mb-2">Insurance Fee</label>
                                    <div class="compact-input bg-gray-50 border border-gray-200 rounded-lg" id="fee_insurance_rate">{{ number_format($application->insurancefee, 2) }}</div>
                                    <input type="hidden" name="insurancefee" id="hidden_insurance_fee" value="{{ $application->insurancefee }}">
                                </div>
                                <div class="md:col-span-3 border-t pt-4 mt-2">
                                    <div class="grid grid-cols-2 gap-4">
                                        <div><label class="compact-label font-medium mb-2">Penalty Rate</label>
                                             <div class="compact-input bg-gray-50 border border-gray-200 rounded-lg" id="penalty_rate_display">{{ number_format($application->penalty_rate, 2) }}%</div>
                                             <input type="hidden" name="penalty_rate" id="hidden_penalty_rate" value="{{ $application->penalty_rate }}"></div>
                                        <div><label class="compact-label font-medium mb-2">Penalty Basis</label>
                                             <div class="compact-input bg-gray-50 border border-gray-200 rounded-lg" id="penalty_basis_display">{{ $application->penalty_basis ? str_replace('_', ' ', $application->penalty_basis) : 'N/A' }}</div>
                                             <input type="hidden" name="penalty_basis" id="hidden_penalty_basis" value="{{ $application->penalty_basis }}"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- CARD 7: DOCUMENT REQUIREMENTS --}}
                        @if(isset($requirementsWithStatus) && count($requirementsWithStatus) > 0)
                        <div class="bg-white rounded-xl shadow-sm border">
                            <div class="p-4 border-b border-gray-200">
                                <div class="flex justify-between items-center">
                                    <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                        <i class="fas fa-file-alt mr-3 text-zedbank-blue"></i>
                                        Document Requirements
                                    </h2>
                                    <span class="text-sm font-semibold px-3 py-1 bg-blue-100 text-blue-800 rounded-full">
                                        {{ $documentStats['total_documents'] ?? 0 }}/{{ $documentStats['total_requirements'] ?? 0 }}
                                    </span>
                                </div>
                            </div>
                            <div class="p-4">
                                
                                <!-- Document Statistics -->
                                <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                                    <div class="bg-blue-50 border border-blue-100 rounded-lg p-4 text-center">
                                        <div class="text-2xl font-bold text-blue-700">{{ $documentStats['mandatory_completed'] ?? 0 }}/{{ $documentStats['mandatory_requirements'] ?? 0 }}</div>
                                        <div class="text-sm font-medium text-blue-600">Mandatory</div>
                                    </div>
                                    <div class="bg-green-50 border border-green-100 rounded-lg p-4 text-center">
                                        <div class="text-2xl font-bold text-green-700">{{ $documentStats['verified'] ?? 0 }}</div>
                                        <div class="text-sm font-medium text-green-600">Verified</div>
                                    </div>
                                    <div class="bg-yellow-50 border border-yellow-100 rounded-lg p-4 text-center">
                                        <div class="text-2xl font-bold text-yellow-700">{{ $documentStats['pending'] ?? 0 }}</div>
                                        <div class="text-sm font-medium text-yellow-600">Pending</div>
                                    </div>
                                    <div class="bg-red-50 border border-red-100 rounded-lg p-4 text-center">
                                        <div class="text-2xl font-bold text-red-700">{{ $documentStats['rejected'] ?? 0 }}</div>
                                        <div class="text-sm font-medium text-red-600">Rejected</div>
                                    </div>
                                </div>

                                <!-- Progress Bars -->
                                <div class="mb-6">
                                    <div class="flex justify-between text-sm mb-1">
                                        <span class="font-medium">Mandatory Completion</span>
                                        <span class="font-bold">{{ $documentStats['mandatory_completion'] ?? 0 }}%</span>
                                    </div>
                                    <div class="w-full bg-gray-200 rounded-full h-2.5">
                                        <div class="bg-green-600 h-2.5 rounded-full" style="width: {{ $documentStats['mandatory_completion'] ?? 0 }}%"></div>
                                    </div>
                                    <p class="text-xs text-gray-500 mt-1">
                                        {{ $documentStats['mandatory_completed'] ?? 0 }} of {{ $documentStats['mandatory_requirements'] ?? 0 }} mandatory documents verified
                                    </p>
                                </div>

                                <!-- Document Requirements Table -->
                                <div class="overflow-x-auto border border-gray-200 rounded-lg">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">#</th>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Document</th>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            @foreach($requirementsWithStatus as $index => $requirement)
                                                <tr class="{{ $requirement['is_mandatory'] ? 'bg-yellow-50' : 'hover:bg-gray-50' }}">
                                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900">
                                                        {{ $index + 1 }}
                                                    </td>
                                                    <td class="px-4 py-3">
                                                        <div class="font-medium text-gray-900">{{ $requirement['name'] }}</div>
                                                        <div class="text-xs text-gray-500">{{ $requirement['description'] }}</div>
                                                        @if($requirement['has_document'])
                                                            <div class="text-xs text-gray-700 mt-1">
                                                                <i class="fas fa-file text-blue-500 mr-1"></i>
                                                                {{ $requirement['document']->file_name }}
                                                                <span class="text-gray-400 mx-1">•</span>
                                                                {{ $requirement['document']->formatted_file_size }}
                                                            </div>
                                                        @endif
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap">
                                                        @if($requirement['is_mandatory'])
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                                <i class="fas fa-exclamation-circle mr-1"></i> Mandatory
                                                            </span>
                                                        @else
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                                <i class="fas fa-check-circle mr-1"></i> Optional
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap">
                                                        @if($requirement['status'] == 'verified')
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                                <i class="fas fa-check-circle mr-1"></i> Verified
                                                            </span>
                                                            @if($requirement['verified_by'] && $requirement['verified_at'])
                                                                <div class="text-xs text-gray-500 mt-1">
                                                                    <i class="fas fa-user-check mr-1"></i> {{ $requirement['verified_by'] }}
                                                                    <br>
                                                                    <i class="fas fa-calendar-alt mr-1"></i> {{ $requirement['verified_at'] }}
                                                                </div>
                                                            @endif
                                                        @elseif($requirement['status'] == 'pending')
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                                                <i class="fas fa-clock mr-1"></i> Pending
                                                            </span>
                                                        @elseif($requirement['status'] == 'rejected')
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                                <i class="fas fa-times-circle mr-1"></i> Rejected
                                                            </span>
                                                            @if($requirement['rejection_reason'])
                                                                <div class="text-xs text-red-600 mt-1">
                                                                    <i class="fas fa-exclamation-circle mr-1"></i> {{ $requirement['rejection_reason'] }}
                                                                </div>
                                                            @endif
                                                        @else
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                                <i class="fas fa-exclamation-circle mr-1"></i> Not Attached
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap text-sm font-medium">
                                                        @if($requirement['has_document'])
                                                            <div class="flex space-x-2">
                                                                <a href="{{ route('admin.applications.view-document', ['id' => $application->id, 'document' => $requirement['document']->id]) }}" 
                                                                   class="inline-flex items-center px-3 py-1 border border-blue-300 text-blue-700 bg-blue-50 rounded hover:bg-blue-100"
                                                                   target="_blank"
                                                                   title="View Document">
                                                                    <i class="fas fa-eye mr-1"></i> View
                                                                </a>
                                                                <a href="{{ route('admin.applications.download-document', ['id' => $application->id, 'document' => $requirement['document']->id]) }}" 
                                                                   class="inline-flex items-center px-3 py-1 border border-green-300 text-green-700 bg-green-50 rounded hover:bg-green-100"
                                                                   title="Download Document">
                                                                    <i class="fas fa-download mr-1"></i> Download
                                                                </a>
                                                                
                                                                @if($requirement['status'] == 'rejected' || $requirement['status'] == 'pending')
                                                                    <button onclick="showReplaceModal({{ $requirement['document']->id }}, '{{ $requirement['name'] }}')"
                                                                            class="inline-flex items-center px-3 py-1 border border-orange-300 text-orange-700 bg-orange-50 rounded hover:bg-orange-100"
                                                                            title="Replace Document">
                                                                        <i class="fas fa-sync-alt mr-1"></i> Replace
                                                                    </button>
                                                                @endif
                                                                
                                                                @if($requirement['status'] == 'pending')
                                                                    <button onclick="verifyDocument({{ $requirement['document']->id }}, '{{ $requirement['name'] }}')"
                                                                            class="inline-flex items-center px-3 py-1 border border-green-600 text-green-700 bg-green-100 rounded hover:bg-green-200"
                                                                            title="Verify Document">
                                                                        <i class="fas fa-check mr-1"></i> Verify
                                                                    </button>
                                                                    <button onclick="showRejectModal({{ $requirement['document']->id }}, '{{ $requirement['name'] }}')"
                                                                            class="inline-flex items-center px-3 py-1 border border-red-600 text-red-700 bg-red-100 rounded hover:bg-red-200"
                                                                            title="Reject Document">
                                                                        <i class="fas fa-times mr-1"></i> Reject
                                                                    </button>
                                                                @endif
                                                            </div>
                                                        @else
                                                            <button onclick="showAttachModal({{ $requirement['requirement_id'] }})"
                                                                    class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                                                <i class="fas fa-paperclip mr-2"></i> Attach
                                                            </button>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Summary Alert -->
                                <div class="mt-6 p-4 {{ ($documentStats['mandatory_completion'] ?? 0) == 100 ? 'bg-green-50 border border-green-200' : 'bg-yellow-50 border border-yellow-200' }} rounded-lg">
                                    <div class="flex">
                                        <div class="flex-shrink-0">
                                            <i class="fas {{ ($documentStats['mandatory_completion'] ?? 0) == 100 ? 'fa-check-circle text-green-400' : 'fa-exclamation-triangle text-yellow-400' }}"></i>
                                        </div>
                                        <div class="ml-3 flex-1 md:flex md:justify-between">
                                            <div>
                                                <p class="text-sm font-medium {{ ($documentStats['mandatory_completion'] ?? 0) == 100 ? 'text-green-800' : 'text-yellow-800' }}">
                                                    @if(($documentStats['mandatory_completion'] ?? 0) == 100)
                                                        ✅ All mandatory documents are verified! This application meets the document requirements.
                                                    @else
                                                        ⚠️ {{ ($documentStats['mandatory_requirements'] ?? 0) - ($documentStats['mandatory_completed'] ?? 0) }} mandatory document(s) still need to be verified.
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="mt-3 md:mt-0 md:ml-6">
                                                <button onclick="showUploadModal()" 
                                                       class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md {{ ($documentStats['mandatory_completion'] ?? 0) == 100 ? 'text-green-700 bg-green-100 hover:bg-green-200' : 'text-yellow-700 bg-yellow-100 hover:bg-yellow-200' }}">
                                                    <i class="fas fa-upload mr-2"></i> Upload Documents
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Check Eligibility Button -->
                                @if($application->status != 'disbursed')
                                    <div class="mt-6 text-center">
                                        <button onclick="checkApprovalEligibility()" 
                                                class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                            <i class="fas fa-clipboard-check mr-2"></i> Check Approval Eligibility
                                        </button>
                                    </div>
                                @endif
                            </div>
                        </div>
                        @else
                        <!-- No Requirements Message -->
                        <div class="bg-white rounded-xl shadow-sm border">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-file-alt mr-3 text-zedbank-blue"></i>
                                    Document Requirements
                                </h2>
                            </div>
                            <div class="p-4 text-center py-8">
                                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-blue-100">
                                    <i class="fas fa-info-circle text-blue-600 text-xl"></i>
                                </div>
                                <h3 class="mt-4 text-lg font-medium text-gray-900">No Document Requirements</h3>
                                <p class="mt-2 text-sm text-gray-500">
                                    This loan product does not have any document requirements configured.
                                </p>
                                <div class="mt-6">
                                    <button onclick="showUploadModal()" 
                                           class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700">
                                        <i class="fas fa-plus mr-2"></i> Upload Document
                                    </button>
                                </div>
                            </div>
                        </div>
                        @endif

                        {{-- CARD 8: APPLICATION DATE (NEW CARD FOR BACKDATING) --}}
                        <div class="bg-white rounded-xl shadow-sm border mt-6">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-calendar-alt mr-3 text-zedbank-blue"></i>
                                    Application Date
                                </h2>
                            </div>
                            <div class="p-4">
                                <div class="space-y-4">
                                    <div>
                                        <label class="block text-gray-700 compact-label font-medium mb-2" for="application_date">
                                            Application Date
                                        </label>
                                        <div class="flex flex-col space-y-2">
                                            <input type="date" name="application_date" id="application_date" 
                                                   value="{{ $application->submitted_at ? \Carbon\Carbon::parse($application->submitted_at)->format('Y-m-d') : date('Y-m-d') }}"
                                                   max="{{ date('Y-m-d') }}"
                                                   class="w-full compact-input border border-gray-300 rounded-lg"
                                                   onchange="checkBackdateWarning(this)">
                                            <p class="text-xs text-gray-500 mt-1">
                                                Change only if backdating or correcting application date.
                                            </p>
                                        </div>
                                        
                                        {{-- Backdate Warning --}}
                                        <div id="backdate-warning" class="backdate-warning mt-3 p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                                            <div class="flex items-start">
                                                <i class="fas fa-exclamation-triangle text-yellow-600 mt-0.5 mr-2"></i>
                                                <div>
                                                    <p class="text-sm font-medium text-yellow-800" id="backdate-warning-title"></p>
                                                    <p class="text-xs text-yellow-700 mt-1" id="backdate-warning-message"></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- CARD 9: ADDITIONAL INFORMATION --}}
                        <div class="bg-white rounded-xl shadow-sm border mt-6">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-info-circle mr-3 text-zedbank-blue"></i>
                                    Additional Information
                                </h2>
                            </div>
                            <div class="p-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-gray-700 compact-label font-medium mb-2" for="source">
                                            <span class="text-red-500">*</span> Application Source
                                        </label>
                                        <select name="source" id="source" 
                                                class="w-full compact-input border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                                                required>
                                            <option value="online" {{ $application->source == 'online' ? 'selected' : '' }}>Online</option>
                                            <option value="branch" {{ $application->source == 'branch' ? 'selected' : '' }}>Branch</option>
                                            <option value="agent" {{ $application->source == 'agent' ? 'selected' : '' }}>Agent</option>
                                            <option value="mobile" {{ $application->source == 'mobile' ? 'selected' : '' }}>Mobile</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-gray-700 compact-label font-medium mb-2" for="status">
                                            <span class="text-red-500">*</span> Application Status
                                        </label>
                                        <select name="status" id="status" 
                                                class="w-full compact-input border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                                                required>
                                            <option value="draft" {{ $application->status == 'draft' ? 'selected' : '' }}>Draft</option>
                                            <option value="submitted" {{ $application->status == 'submitted' ? 'selected' : '' }}>Submitted</option>
                                            <option value="under_review" {{ $application->status == 'under_review' ? 'selected' : '' }}>Under Review</option>
                                            <option value="approved" {{ $application->status == 'approved' ? 'selected' : '' }}>Approved</option>
                                            <option value="rejected" {{ $application->status == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- CARD 10: DISBURSEMENT INFORMATION --}}
                        <div class="bg-white rounded-xl shadow-sm border mt-6">
                            <div class="p-4 border-b border-gray-200">
                                <h2 class="text-lg font-bold text-gray-900 flex items-center">
                                    <i class="fas fa-exchange-alt mr-3 text-zedbank-blue"></i>
                                    Disbursement Information
                                </h2>
                            </div>
                            <div class="p-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-gray-700 compact-label font-medium mb-2">Calculated Installment</label>
                                        <div class="compact-input bg-gray-50 border border-gray-200 rounded-lg font-bold flex items-center justify-between">
                                            <div>
                                                <span class="currency-symbol-text">{{ $application->currency->symbol ?? 'ZMW' }}</span> <span id="disbursement-installment">{{ number_format($application->installment_amount, 2) }}</span>
                                            </div>
                                            <div id="installment-loading" class="hidden">
                                                <div class="loading-spinner"></div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="installment_amount" id="installment_amount_hidden" value="{{ $application->installment_amount }}">
                                    </div>
                                    <div>
                                        <label class="block text-gray-700 compact-label font-medium mb-2" for="payment_method">
                                            <span class="text-red-500">*</span> Payment Method
                                        </label>
                                        <select name="suggestedpaymentmethod" id="payment_method" class="w-full compact-input border border-gray-300 rounded-lg" onchange="handlePaymentMethodChange()" required>
                                           <option value="">Select Method</option>
                                           <option value="Cash" {{ $application->suggestedpaymentmethod == 'Cash' ? 'selected' : '' }}>Cash</option>
                                           <option value="Bank" {{ $application->suggestedpaymentmethod == 'Bank' ? 'selected' : '' }}>Bank</option>
                                           <option value="Mobile Money" {{ $application->suggestedpaymentmethod == 'Mobile Money' ? 'selected' : '' }}>Mobile Money</option>
                                        </select>
                                    </div>
                                </div>

                                {{-- DYNAMIC BANK FIELDS --}}
                                <div id="disbursement_bank_fields" class="mt-4 pt-4 border-t border-gray-200 {{ $application->suggestedpaymentmethod == 'Bank' ? '' : 'hidden' }} space-y-4">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div class="md:col-span-2"><label class="compact-label font-medium mb-1">Bank Name</label>
                                             <input type="text" name="bank_name" value="{{ $application->bank_name }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                        <div><label class="compact-label font-medium mb-1">Account Holder</label>
                                             <input type="text" name="account_holder" value="{{ $application->account_holder }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                        <div><label class="compact-label font-medium mb-1">Account Number</label>
                                             <input type="text" name="account_number" value="{{ $application->account_number }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                        <div><label class="compact-label font-medium mb-1">Branch</label>
                                             <input type="text" name="bank_branch" value="{{ $application->bank_branch }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                        <div><label class="compact-label font-medium mb-1">SWIFT Code</label>
                                             <input type="text" name="swift_code" value="{{ $application->swift_code }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                    </div>
                                </div>

                                {{-- DYNAMIC MOBILE FIELDS --}}
                                <div id="disbursement_mobile_fields" class="mt-4 pt-4 border-t border-gray-200 {{ $application->suggestedpaymentmethod == 'Mobile Money' ? '' : 'hidden' }}">
                                    <div class="grid grid-cols-2 gap-4">
                                        <div><label class="compact-label font-medium mb-1">Payment Channel</label>
                                             <select name="mobile_channel" class="w-full compact-input border border-gray-300 rounded-lg">
                                                 <option value="MTN Mobile" {{ $application->mobile_channel == 'MTN Mobile' ? 'selected' : '' }}>MTN Mobile</option>
                                                 <option value="Airtel Mobile" {{ $application->mobile_channel == 'Airtel Mobile' ? 'selected' : '' }}>Airtel Mobile</option>
                                                 <option value="Zamtel Mobile" {{ $application->mobile_channel == 'Zamtel Mobile' ? 'selected' : '' }}>Zamtel Mobile</option>
                                             </select></div>
                                        <div><label class="compact-label font-medium mb-1">Mobile Phone Number</label>
                                             <input type="text" name="mobile_number" value="{{ $application->mobile_number }}" class="w-full compact-input border border-gray-300 rounded-lg"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- SAVE BUTTONS --}}
                        <div class="bg-white rounded-xl shadow-sm border p-6">
                            <div class="flex flex-col sm:flex-row gap-4 justify-end">
                                <a href="{{ route('admin.applications.show', $application->id) }}" class="px-6 py-3 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 text-center font-medium">
                                    Cancel
                                </a>
                                <button type="submit" class="px-6 py-3 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark font-medium flex items-center justify-center">
                                    <i class="fas fa-save mr-2"></i> Save Changes
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </main>
    </div>

    <!-- Document Upload Modal (Same as in show.blade.php) -->
    <div id="uploadDocumentModal" class="modal-overlay">
        <div class="modal-content w-full max-w-2xl mx-4">
            <form id="uploadDocumentForm" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-gray-900">Upload Document</h3>
                        <button type="button" onclick="hideUploadModal()" class="text-gray-400 hover:text-gray-500">
                            <i class="fas fa-times text-xl"></i>
                        </button>
                    </div>
                    
                    <div class="space-y-4">
                        <!-- Hidden application ID -->
                        <input type="hidden" name="application_id" id="modalApplicationId" value="{{ $application->id }}">
                        
                        <!-- Requirement Selection -->
                        <div>
                            <label for="modal_requirement_id" class="block text-sm font-medium text-gray-700 mb-2">
                                Document Type *
                            </label>
                            <select name="requirement_id" 
                                    id="modal_requirement_id" 
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                    required>
                                <option value="">-- Select Document Type --</option>
                                @if(isset($requirementsWithStatus))
                                    @foreach($requirementsWithStatus as $requirement)
                                        @if(!$requirement['has_document'] || $requirement['status'] == 'rejected')
                                            <option value="{{ $requirement['requirement_id'] }}">
                                                {{ $requirement['name'] }}
                                                @if($requirement['is_mandatory'])
                                                    (Mandatory)
                                                @endif
                                                @if($requirement['has_document'] && $requirement['status'] == 'rejected')
                                                    - Replace Rejected
                                                @endif
                                            </option>
                                        @endif
                                    @endforeach
                                @endif
                            </select>
                            <p class="mt-1 text-sm text-gray-500">
                                Select the type of document to upload
                            </p>
                        </div>

                        <!-- File Upload with Drag & Drop -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Document File *
                            </label>
                            <div id="dropZone" 
                                 class="border-2 border-dashed border-gray-300 rounded-lg p-8 text-center hover:border-blue-400 transition-colors duration-200 cursor-pointer">
                                <div class="space-y-2">
                                    <i class="fas fa-cloud-upload-alt text-4xl text-gray-400"></i>
                                    <div>
                                        <p class="text-sm text-gray-600">
                                            <span class="font-medium text-blue-600 hover:text-blue-500 cursor-pointer">
                                                Click to browse
                                            </span>
                                            or drag and drop
                                        </p>
                                        <p class="text-xs text-gray-500 mt-1">
                                            PDF, JPG, PNG, DOC, DOCX, XLS, XLSX up to 10MB
                                        </p>
                                    </div>
                                    <input type="file" 
                                           name="document" 
                                           id="modalDocument" 
                                           class="hidden" 
                                           accept=".pdf,.jpg,.jpeg,.png,.doc,.docx,.xls,.xlsx"
                                           required>
                                </div>
                            </div>
                            
                            <!-- File Preview -->
                            <div id="modalFilePreview" class="mt-3 hidden">
                                <div class="flex items-center justify-between bg-green-50 border border-green-200 rounded-lg p-3">
                                    <div class="flex items-center">
                                        <i class="fas fa-file text-green-500 mr-3 text-xl"></i>
                                        <div>
                                            <p id="modalFileName" class="font-medium text-green-800"></p>
                                            <p id="modalFileSize" class="text-sm text-green-600"></p>
                                        </div>
                                    </div>
                                    <button type="button" onclick="clearModalFile()" class="text-red-500 hover:text-red-700">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Notes -->
                        <div>
                            <label for="modal_notes" class="block text-sm font-medium text-gray-700 mb-2">
                                Notes (Optional)
                            </label>
                            <textarea name="notes" 
                                      id="modal_notes" 
                                      rows="3" 
                                      class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                      placeholder="Add any notes about this document..."></textarea>
                        </div>

                        <!-- Upload Progress -->
                        <div id="uploadProgress" class="hidden">
                            <div class="flex items-center space-x-3">
                                <div class="flex-1">
                                    <div class="w-full bg-gray-200 rounded-full h-2.5">
                                        <div id="progressBar" class="bg-green-600 h-2.5 rounded-full" style="width: 0%"></div>
                                    </div>
                                    <p id="progressText" class="text-sm text-gray-600 mt-1">Uploading...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                    <button type="button" 
                            onclick="hideUploadModal()"
                            class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                        Cancel
                    </button>
                    <button type="submit" 
                            id="uploadSubmitBtn"
                            class="px-4 py-2 bg-zedbank-blue text-white rounded-md hover:bg-zedbank-blue-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 font-medium">
                        <i class="fas fa-upload mr-2"></i> Upload Document
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Replace Document Modal -->
    <div id="replaceDocumentModal" class="modal-overlay">
        <div class="modal-content w-full max-w-md mx-4">
            <form id="replaceDocumentForm" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="document_id" id="replaceDocumentId">
                <div class="p-6">
                    <div class="flex items-start">
                        <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-blue-100">
                            <i class="fas fa-exchange-alt text-blue-600"></i>
                        </div>
                        <div class="mt-0 ml-4">
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Replace Document</h3>
                            <div class="mt-2">
                                <p class="text-sm text-gray-500 mb-4">
                                    You are replacing document: <span id="replaceDocName" class="font-semibold"></span>
                                </p>
                                
                                <!-- New File Upload -->
                                <div class="mb-4">
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        New Document File *
                                    </label>
                                    <div id="replaceDropZone" 
                                         class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-blue-400 transition-colors duration-200 cursor-pointer">
                                        <div class="space-y-2">
                                            <i class="fas fa-cloud-upload-alt text-3xl text-gray-400"></i>
                                            <div>
                                                <p class="text-sm text-gray-600">
                                                    <span class="font-medium text-blue-600 hover:text-blue-500 cursor-pointer">
                                                        Click to browse
                                                    </span>
                                                    or drag and drop
                                                </p>
                                                <p class="text-xs text-gray-500 mt-1">
                                                    PDF, JPG, PNG, DOC, DOCX, XLS, XLSX up to 10MB
                                                </p>
                                            </div>
                                            <input type="file" 
                                                   name="document" 
                                                   id="replaceDocument" 
                                                   class="hidden" 
                                                   accept=".pdf,.jpg,.jpeg,.png,.doc,.docx,.xls,.xlsx"
                                                   required>
                                        </div>
                                    </div>
                                    
                                    <!-- File Preview -->
                                    <div id="replaceFilePreview" class="mt-3 hidden">
                                        <div class="flex items-center justify-between bg-green-50 border border-green-200 rounded-lg p-3">
                                            <div class="flex items-center">
                                                <i class="fas fa-file text-green-500 mr-3"></i>
                                                <div>
                                                    <p id="replaceFileName" class="font-medium text-green-800"></p>
                                                    <p id="replaceFileSize" class="text-sm text-green-600"></p>
                                                </div>
                                            </div>
                                            <button type="button" onclick="clearReplaceFile()" class="text-red-500 hover:text-red-700">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Notes -->
                                <div class="mb-4">
                                    <label for="replace_notes" class="block text-sm font-medium text-gray-700 mb-2">
                                        Notes (Optional)
                                    </label>
                                    <textarea name="notes" 
                                              id="replace_notes" 
                                              rows="2" 
                                              class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                              placeholder="Notes about the replacement..."></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                    <button type="button" 
                            onclick="hideReplaceModal()"
                            class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                        Cancel
                    </button>
                    <button type="submit" 
                            class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 font-medium">
                        <i class="fas fa-sync-alt mr-2"></i> Replace Document
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Reject Document Modal -->
    <div id="rejectModal" class="modal-overlay">
        <div class="modal-content w-full max-w-md mx-4">
            <form id="rejectForm" method="POST">
                @csrf
                <div class="p-6">
                    <div class="flex items-start">
                        <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                            <i class="fas fa-times text-red-600"></i>
                        </div>
                        <div class="mt-0 ml-4">
                            <h3 class="text-lg leading-6 font-medium text-gray-900" id="rejectModalTitle">Reject Document</h3>
                            <div class="mt-2">
                                <p class="text-sm text-gray-500 mb-4">
                                    You are about to reject document: <span id="rejectDocName" class="font-semibold"></span>
                                </p>
                                <input type="hidden" name="document_id" id="rejectDocId">
                                
                                <div class="mb-4">
                                    <label for="rejection_reason" class="block text-sm font-medium text-gray-700 mb-2">Rejection Reason *</label>
                                    <textarea name="rejection_reason" id="rejection_reason" rows="3" 
                                              class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-md"
                                              placeholder="Please provide a reason for rejecting this document..."
                                              required></textarea>
                                </div>
                                
                                <div class="mb-4">
                                    <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Additional Notes (Optional)</label>
                                    <textarea name="notes" id="notes" rows="2" 
                                              class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-md"
                                              placeholder="Any additional notes..."></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-end space-x-3">
                    <button type="button" 
                            onclick="hideRejectModal()"
                            class="inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:text-sm">
                        Cancel
                    </button>
                    <button type="submit" 
                            class="inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 sm:text-sm">
                        <i class="fas fa-times mr-2"></i> Reject Document
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Success Notification -->
    <div id="successNotification" class="fixed top-4 right-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded shadow-lg z-50 hidden transition-all duration-300 ease-in-out">
        <div class="flex">
            <div class="py-1">
                <i class="fas fa-check-circle mr-3 text-green-500"></i>
            </div>
            <div>
                <p class="font-bold" id="successTitle"></p>
                <p class="text-sm" id="successMessage"></p>
            </div>
            <button onclick="hideNotification('successNotification')" class="ml-4 text-green-700 hover:text-green-900">
                <i class="fas fa-times"></i>
            </button>
        </div>
    </div>

    <!-- Error Notification -->
    <div id="errorNotification" class="fixed top-4 right-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded shadow-lg z-50 hidden transition-all duration-300 ease-in-out">
        <div class="flex">
            <div class="py-1">
                <i class="fas fa-exclamation-triangle mr-3 text-red-500"></i>
            </div>
            <div>
                <p class="font-bold" id="errorTitle"></p>
                <p class="text-sm" id="errorMessage"></p>
            </div>
            <button onclick="hideNotification('errorNotification')" class="ml-4 text-red-700 hover:text-red-900">
                <i class="fas fa-times"></i>
            </button>
        </div>
    </div>

    <script>
        const productSelect = document.getElementById('product_id');
        const rateInput = document.getElementById('interest_rate');
        const frequencySelect = document.getElementById('payment_frequency');
        const tenureInput = document.getElementById('loan_tenure');
        const amountInput = document.getElementById('loan_amount');
        const tenureLabelText = document.getElementById('tenure-label-text');
        const interestMethodSelect = document.getElementById('interest_method');
        const applicationDateInput = document.getElementById('application_date');

        // --- GLOBAL HELPER FUNCTIONS ---

        function updateCurrencySymbols(selectElement) {
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            const symbol = selectedOption ? selectedOption.getAttribute('data-symbol') || 'ZMW' : 'ZMW'; 
            document.querySelectorAll('.currency-symbol-text').forEach(el => el.textContent = symbol);
        }

        function updateTenureLabel() {
            if (!frequencySelect || !tenureLabelText) return;
            const frequency = frequencySelect.value;
            if (frequency === 'one_off' || frequency === 'daily') {
                tenureLabelText.textContent = 'Loan Tenure (Days)';
                tenureInput.placeholder = "e.g., 30";
            } else {
                tenureLabelText.textContent = 'Loan Tenure (Months)';
                tenureInput.placeholder = "e.g., 12";
            }
        }

        function updateInterestRateFromProduct(selectElement) {
            if (!selectElement || !frequencySelect) return;
            const option = selectElement.options[selectElement.selectedIndex];
            if (!option) return;

            const frequency = frequencySelect.value;
            let rateKey = 'data-monthly-rate'; // Default

            if (frequency === 'daily') rateKey = 'data-daily-rate';
            else if (frequency === 'weekly') rateKey = 'data-weekly-rate';
            else if (frequency === 'quarterly') rateKey = 'data-yearly-rate';

            const rate = option.getAttribute(rateKey) || '0.00';
            if (rateInput) rateInput.value = parseFloat(rate).toFixed(2);

            // Set Interest Method from product
            const interestMethod = option.getAttribute('data-interest-method') || 'reducing_balance';
            if (interestMethodSelect) {
                interestMethodSelect.value = interestMethod;
            }

            // Populate Fees & Penalties
            const pFee = option.getAttribute('data-processing-fee') || '0.00';
            const pBasis = option.getAttribute('data-processing-fee-basis') || 'initial_amount';
            const adminFee = option.getAttribute('data-admin-fee') || '0.00';
            const insuranceFee = option.getAttribute('data-insurance-fee') || '0.00';
            const penaltyRate = option.getAttribute('data-penalty-rate') || '0.00';
            const penaltyBasis = option.getAttribute('data-penalty-basis') || 'percentage_of_due';

            document.getElementById('fee_processing_rate').textContent = pFee + '%';
            document.getElementById('fee_processing_basis').textContent = pBasis.replace('_', ' ');
            document.getElementById('fee_admin_rate').textContent = adminFee;
            document.getElementById('fee_insurance_rate').textContent = insuranceFee;
            document.getElementById('penalty_rate_display').textContent = penaltyRate + '%';
            document.getElementById('penalty_basis_display').textContent = penaltyBasis.replace(/_/g, ' ');

            document.getElementById('hidden_processing_fee').value = pFee;
            document.getElementById('hidden_processing_fee_basis').value = pBasis;
            document.getElementById('hidden_admin_fee').value = adminFee;
            document.getElementById('hidden_insurance_fee').value = insuranceFee;
            document.getElementById('hidden_penalty_rate').value = penaltyRate;
            document.getElementById('hidden_penalty_basis').value = penaltyBasis;
        }

        function calculateInstallment() {
            const amount = parseFloat(amountInput.value) || 0;
            const rate = parseFloat(rateInput.value) || 0;
            const tenure = parseInt(tenureInput.value) || 0;
            const frequency = frequencySelect.value;
            const interestMethod = interestMethodSelect.value;
            
            // Get fee values from hidden inputs
            const processingFee = parseFloat(document.getElementById('hidden_processing_fee').value) || 0;
            const processingFeeBasis = document.getElementById('hidden_processing_fee_basis').value || 'initial_amount';
            const adminFee = parseFloat(document.getElementById('hidden_admin_fee').value) || 0;
            const insuranceFee = parseFloat(document.getElementById('hidden_insurance_fee').value) || 0;

            // Show loading indicator
            document.getElementById('installment-loading').classList.remove('hidden');
            const installmentElements = [
                document.getElementById('disbursement-installment')
            ];
            
            installmentElements.forEach(el => {
                if (el) el.textContent = 'Calculating...';
            });

            // Only calculate if we have valid inputs
            if (amount > 0 && rate > 0 && tenure > 0 && frequency && interestMethod) {
                $.ajax({
                    url: '{{ route("admin.applications.calculate_installment") }}',
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        loan_amount: amount,
                        interest_rate: rate,
                        loan_tenure: tenure,
                        payment_frequency: frequency,
                        interest_method: interestMethod,
                        processing_fee: processingFee,
                        processing_fee_basis: processingFeeBasis,
                        adminfee: adminFee,
                        insurancefee: insuranceFee
                    },
                    success: function(response) {
                        document.getElementById('installment-loading').classList.add('hidden');
                        if (response.success) {
                            const installment = response.installment;
                            const rawInstallment = response.installment_raw;
                            
                            document.getElementById('disbursement-installment').textContent = installment;
                            document.getElementById('installment_amount_hidden').value = rawInstallment;
                        } else {
                            showCalculationError('Calculation failed: ' + response.message);
                        }
                    },
                    error: function(xhr) {
                        document.getElementById('installment-loading').classList.add('hidden');
                        showCalculationError('Server error during calculation');
                        console.error('Calculation error:', xhr.responseText);
                    }
                });
            } else {
                document.getElementById('installment-loading').classList.add('hidden');
                // Reset to default values
                const defaultValue = '0.00';
                installmentElements.forEach(el => {
                    if (el) el.textContent = defaultValue;
                });
                document.getElementById('installment_amount_hidden').value = 0;
            }
        }

        function showCalculationError(message) {
            const errorMsg = message || 'Error calculating installment';
            const elements = [
                document.getElementById('disbursement-installment')
            ];
            
            elements.forEach(el => {
                if (el) {
                    el.textContent = 'Error';
                    el.classList.add('text-red-500');
                }
            });
            
            // Show error alert
            const alertDiv = document.createElement('div');
            alertDiv.className = 'fixed top-4 right-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded z-50';
            alertDiv.innerHTML = `<strong>Calculation Error:</strong> ${errorMsg}`;
            document.body.appendChild(alertDiv);
            
            setTimeout(() => {
                document.body.removeChild(alertDiv);
                elements.forEach(el => {
                    if (el) el.classList.remove('text-red-500');
                });
            }, 5000);
        }

        function handlePaymentMethodChange() {
            const method = document.getElementById('payment_method').value;
            document.getElementById('disbursement_bank_fields').classList.add('hidden');
            document.getElementById('disbursement_mobile_fields').classList.add('hidden');
            if (method === 'Bank') document.getElementById('disbursement_bank_fields').classList.remove('hidden');
            else if (method === 'Mobile Money') document.getElementById('disbursement_mobile_fields').classList.remove('hidden');
        }

        function checkBackdateWarning(dateInput) {
            const warningDiv = document.getElementById('backdate-warning');
            const warningTitle = document.getElementById('backdate-warning-title');
            const warningMessage = document.getElementById('backdate-warning-message');
            
            if (!dateInput.value) {
                warningDiv.style.display = 'none';
                return;
            }
            
            const selectedDate = new Date(dateInput.value);
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            
            if (selectedDate < today) {
                const daysAgo = Math.floor((today - selectedDate) / (1000 * 60 * 60 * 24));
                
                if (daysAgo > 90) {
                    warningTitle.textContent = '⚠️ Extensive Backdating Warning';
                    warningMessage.textContent = `This application is being backdated ${daysAgo} days (over 3 months). Please ensure this is intentional and properly documented.`;
                } else if (daysAgo > 30) {
                    warningTitle.textContent = 'Backdating Notice';
                    warningMessage.textContent = `Application is being backdated ${daysAgo} days. This may affect reporting timelines.`;
                } else if (daysAgo > 7) {
                    warningTitle.textContent = 'Backdating Information';
                    warningMessage.textContent = `Application is being backdated ${daysAgo} days.`;
                } else {
                    warningTitle.textContent = 'Minor Backdating';
                    warningMessage.textContent = `Application is being backdated ${daysAgo} days.`;
                }
                
                warningDiv.style.display = 'block';
            } else {
                warningDiv.style.display = 'none';
            }
        }

        // Document Management Functions (from show.blade.php)
        function verifyDocument(documentId, documentName) {
            if (confirm(`Are you sure you want to verify "${documentName}"?`)) {
                showNotification('Processing...', 'Verifying document...', 'info');
                
                const verifyBtn = event.target;
                const originalHTML = verifyBtn.innerHTML;
                verifyBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Verifying...';
                verifyBtn.disabled = true;
                
                $.ajax({
                    url: '{{ url("admin/applications/") }}/' + {{ $application->id }} + '/documents/' + documentId + '/verify',
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        notes: 'Document verified by admin'
                    },
                    success: function(response) {
                        if (response.success) {
                            showNotification('Document Verified', response.message, 'success');
                            setTimeout(() => {
                                location.reload();
                            }, 1500);
                        } else {
                            showNotification('Verification Failed', response.message, 'error');
                            verifyBtn.innerHTML = originalHTML;
                            verifyBtn.disabled = false;
                        }
                    },
                    error: function(xhr) {
                        console.error('Error verifying document:', xhr);
                        let errorMessage = 'Failed to verify document. Please try again.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }
                        showNotification('Error', errorMessage, 'error');
                        verifyBtn.innerHTML = originalHTML;
                        verifyBtn.disabled = false;
                    }
                });
            }
        }

        function showRejectModal(documentId, documentName) {
            document.getElementById('rejectDocId').value = documentId;
            document.getElementById('rejectDocName').textContent = documentName;
            document.getElementById('rejectModal').style.display = 'flex';
            document.getElementById('rejection_reason').focus();
        }

        function hideRejectModal() {
            document.getElementById('rejectModal').style.display = 'none';
            document.getElementById('rejectForm').reset();
        }

        // Handle reject form submission
        document.getElementById('rejectForm')?.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const documentId = document.getElementById('rejectDocId').value;
            const documentName = document.getElementById('rejectDocName').textContent;
            const formData = new FormData(this);
            
            showNotification('Processing...', 'Rejecting document...', 'info');
            
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalBtnText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Processing...';
            submitBtn.disabled = true;
            
            $.ajax({
                url: '{{ url("admin/applications/") }}/' + {{ $application->id }} + '/documents/' + documentId + '/reject',
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    hideRejectModal();
                    showNotification('Document Rejected', 'Document has been rejected successfully.', 'success');
                    setTimeout(() => {
                        location.reload();
                    }, 1500);
                },
                error: function(xhr) {
                    hideRejectModal();
                    let errorMessage = 'Failed to reject document. Please try again.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    showNotification('Error', errorMessage, 'error');
                    submitBtn.innerHTML = originalBtnText;
                    submitBtn.disabled = false;
                }
            });
        });

        // Document Upload Modal Functions
        function showUploadModal(requirementId = '') {
            const modal = document.getElementById('uploadDocumentModal');
            const requirementSelect = document.getElementById('modal_requirement_id');
            
            document.getElementById('uploadDocumentForm').reset();
            document.getElementById('modalFilePreview').classList.add('hidden');
            document.getElementById('uploadProgress').classList.add('hidden');
            document.getElementById('progressBar').style.width = '0%';
            document.getElementById('progressText').textContent = 'Uploading...';
            
            if (requirementId) {
                requirementSelect.value = requirementId;
            }
            
            modal.style.display = 'flex';
            
            setTimeout(() => {
                if (!requirementId) {
                    requirementSelect.focus();
                }
            }, 100);
        }

        function hideUploadModal() {
            document.getElementById('uploadDocumentModal').style.display = 'none';
        }

        function showReplaceModal(documentId, documentName) {
            document.getElementById('replaceDocumentId').value = documentId;
            document.getElementById('replaceDocName').textContent = documentName;
            document.getElementById('replaceDocumentModal').style.display = 'flex';
            
            document.getElementById('replaceDocumentForm').reset();
            document.getElementById('replaceFilePreview').classList.add('hidden');
        }

        function hideReplaceModal() {
            document.getElementById('replaceDocumentModal').style.display = 'none';
        }

        function showAttachModal(requirementId) {
            showUploadModal(requirementId);
        }

        // Drag & Drop functionality
        function setupDropZone(dropZoneId, fileInputId, previewId, fileNameId, fileSizeId) {
            const dropZone = document.getElementById(dropZoneId);
            const fileInput = document.getElementById(fileInputId);
            const preview = document.getElementById(previewId);
            const fileName = document.getElementById(fileNameId);
            const fileSize = document.getElementById(fileSizeId);
            
            dropZone.addEventListener('click', () => fileInput.click());
            
            fileInput.addEventListener('change', (e) => {
                const file = e.target.files[0];
                if (file) {
                    updateFilePreview(file, preview, fileName, fileSize);
                }
            });
            
            dropZone.addEventListener('dragover', (e) => {
                e.preventDefault();
                dropZone.classList.add('border-blue-500', 'bg-blue-50');
            });
            
            dropZone.addEventListener('dragleave', () => {
                dropZone.classList.remove('border-blue-500', 'bg-blue-50');
            });
            
            dropZone.addEventListener('drop', (e) => {
                e.preventDefault();
                dropZone.classList.remove('border-blue-500', 'bg-blue-50');
                
                const file = e.dataTransfer.files[0];
                if (file) {
                    fileInput.files = e.dataTransfer.files;
                    updateFilePreview(file, preview, fileName, fileSize);
                }
            });
        }

        function updateFilePreview(file, preview, fileName, fileSize) {
            if (file) {
                const maxSize = 10 * 1024 * 1024;
                if (file.size > maxSize) {
                    showNotification('File Too Large', 'File size exceeds 10MB limit. Please choose a smaller file.', 'error');
                    return;
                }
                
                const validTypes = ['application/pdf', 'image/jpeg', 'image/jpg', 'image/png', 
                                   'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                                   'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'];
                
                if (!validTypes.includes(file.type)) {
                    showNotification('Invalid File Type', 'Please upload a valid document file (PDF, JPG, PNG, DOC, DOCX, XLS, XLSX).', 'error');
                    return;
                }
                
                fileName.textContent = file.name;
                
                const size = file.size;
                const i = Math.floor(Math.log(size) / Math.log(1024));
                const formattedSize = (size / Math.pow(1024, i)).toFixed(2) * 1 + ' ' + ['B', 'KB', 'MB', 'GB', 'TB'][i];
                fileSize.textContent = formattedSize;
                
                preview.classList.remove('hidden');
            }
        }

        function clearModalFile() {
            document.getElementById('modalDocument').value = '';
            document.getElementById('modalFilePreview').classList.add('hidden');
        }

        function clearReplaceFile() {
            document.getElementById('replaceDocument').value = '';
            document.getElementById('replaceFilePreview').classList.add('hidden');
        }

        // Handle upload form submission with AJAX
        document.getElementById('uploadDocumentForm')?.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const requirementId = document.getElementById('modal_requirement_id').value;
            
            if (!requirementId) {
                showNotification('Selection Required', 'Please select a document type.', 'error');
                return;
            }
            
            const fileInput = document.getElementById('modalDocument');
            if (!fileInput.files[0]) {
                showNotification('File Required', 'Please select a file to upload.', 'error');
                return;
            }
            
            document.getElementById('uploadProgress').classList.remove('hidden');
            const submitBtn = document.getElementById('uploadSubmitBtn');
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Uploading...';
            
            const xhr = new XMLHttpRequest();
            
            xhr.upload.addEventListener('progress', function(e) {
                if (e.lengthComputable) {
                    const percentComplete = (e.loaded / e.total) * 100;
                    document.getElementById('progressBar').style.width = percentComplete + '%';
                    document.getElementById('progressText').textContent = 
                        `Uploading: ${Math.round(percentComplete)}%`;
                }
            });
            
            xhr.addEventListener('load', function() {
                if (xhr.status === 200) {
                    try {
                        const response = JSON.parse(xhr.responseText);
                        if (response.success) {
                            showNotification('Upload Successful', response.message, 'success');
                            hideUploadModal();
                            
                            setTimeout(() => {
                                location.reload();
                            }, 1500);
                        } else {
                            let errorMessage = response.message;
                            if (response.errors) {
                                const errors = Object.values(response.errors).flat();
                                errorMessage = errors.join('<br>');
                            }
                            showNotification('Upload Failed', errorMessage, 'error');
                            resetUploadForm();
                        }
                    } catch (error) {
                        console.error('Parse error:', error, xhr.responseText);
                        showNotification('Upload Error', 'An error occurred during upload. Please try again.', 'error');
                        resetUploadForm();
                    }
                } else if (xhr.status === 422) {
                    try {
                        const response = JSON.parse(xhr.responseText);
                        let errorMessage = 'Validation error';
                        if (response.errors) {
                            const errors = Object.values(response.errors).flat();
                            errorMessage = errors.join('<br>');
                        }
                        showNotification('Validation Error', errorMessage, 'error');
                        resetUploadForm();
                    } catch (error) {
                        showNotification('Validation Error', 'Invalid data submitted.', 'error');
                        resetUploadForm();
                    }
                } else if (xhr.status === 403) {
                    showNotification('Permission Denied', 'You do not have permission to upload documents.', 'error');
                    resetUploadForm();
                } else {
                    showNotification('Upload Error', `Server error (${xhr.status}). Please try again.`, 'error');
                    resetUploadForm();
                }
            });
            
            xhr.addEventListener('error', function() {
                showNotification('Network Error', 'Network error occurred. Please check your connection.', 'error');
                resetUploadForm();
            });
            
            xhr.open('POST', '{{ route("admin.applications.store-document", $application->id) }}');
            xhr.setRequestHeader('X-CSRF-TOKEN', '{{ csrf_token() }}');
            xhr.send(formData);
        });

        // Handle replace form submission
        document.getElementById('replaceDocumentForm')?.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const documentId = document.getElementById('replaceDocumentId').value;
            
            const fileInput = document.getElementById('replaceDocument');
            if (!fileInput.files[0]) {
                showNotification('File Required', 'Please select a new file to replace the existing one.', 'error');
                return;
            }
            
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalBtnText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Replacing...';
            submitBtn.disabled = true;
            
            showNotification('Processing...', 'Replacing document...', 'info');
            
            fetch('{{ route("admin.applications.store-document", $application->id) }}', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            .then(response => {
                if (!response.ok) {
                    if (response.status === 422) {
                        return response.json().then(data => {
                            throw new Error(data.message || 'Validation error');
                        });
                    }
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    showNotification('Replacement Successful', data.message, 'success');
                    hideReplaceModal();
                    
                    setTimeout(() => {
                        location.reload();
                    }, 1500);
                } else {
                    showNotification('Replacement Failed', data.message || 'Failed to replace document.', 'error');
                    submitBtn.innerHTML = originalBtnText;
                    submitBtn.disabled = false;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showNotification('Error', error.message || 'An error occurred. Please try again.', 'error');
                submitBtn.innerHTML = originalBtnText;
                submitBtn.disabled = false;
            });
        });

        function resetUploadForm() {
            document.getElementById('uploadProgress').classList.add('hidden');
            const submitBtn = document.getElementById('uploadSubmitBtn');
            submitBtn.disabled = false;
            submitBtn.innerHTML = '<i class="fas fa-upload mr-2"></i> Upload Document';
        }

        function checkApprovalEligibility() {
            const button = event.target;
            const originalText = button.innerHTML;
            button.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Checking...';
            button.disabled = true;
            
            showNotification('Checking...', 'Checking document completion...', 'info');
            
            $.ajax({
                url: '{{ route("admin.applications.check-completion", $application->id) }}',
                method: 'GET',
                success: function(response) {
                    if (response.eligible_for_approval) {
                        showNotification('Eligible for Approval', response.message, 'success');
                    } else {
                        let missingDocs = response.missing_mandatory.join(', ');
                        showNotification('Not Eligible', 
                            `${response.message}\n\nMissing documents: ${missingDocs}\n\nCompletion: ${response.completion_percentage}%`, 
                            'error'
                        );
                    }
                    button.innerHTML = originalText;
                    button.disabled = false;
                },
                error: function(xhr) {
                    showNotification('Error', 'Failed to check eligibility. Please try again.', 'error');
                    button.innerHTML = originalText;
                    button.disabled = false;
                }
            });
        }

        function showNotification(title, message, type) {
            document.getElementById('successNotification').classList.add('hidden');
            document.getElementById('errorNotification').classList.add('hidden');
            
            if (type === 'success' || type === 'info') {
                document.getElementById('successTitle').textContent = title;
                document.getElementById('successMessage').textContent = message;
                document.getElementById('successNotification').classList.remove('hidden');
                
                setTimeout(() => {
                    document.getElementById('successNotification').classList.add('hidden');
                }, 5000);
            } else {
                document.getElementById('errorTitle').textContent = title;
                document.getElementById('errorMessage').textContent = message;
                document.getElementById('errorNotification').classList.remove('hidden');
                
                setTimeout(() => {
                    document.getElementById('errorNotification').classList.add('hidden');
                }, 5000);
            }
        }

        function hideNotification(notificationId) {
            document.getElementById(notificationId).classList.add('hidden');
        }

        // Initialize on document ready
        $(document).ready(function() {
            updateTenureLabel();
            calculateInstallment();
            
            const currentMethod = document.getElementById('payment_method').value;
            if (currentMethod === 'Bank') {
                document.getElementById('disbursement_bank_fields').classList.remove('hidden');
            } else if (currentMethod === 'Mobile') {
                document.getElementById('disbursement_mobile_fields').classList.remove('hidden');
            }
            
            const feeFields = ['hidden_processing_fee', 'hidden_processing_fee_basis', 'hidden_admin_fee', 'hidden_insurance_fee'];
            
            feeFields.forEach(fieldId => {
                const field = document.getElementById(fieldId);
                if (field) {
                    field.addEventListener('change', calculateInstallment);
                }
            });
            
            if (applicationDateInput && applicationDateInput.value) {
                checkBackdateWarning(applicationDateInput);
            }
            
            setTimeout(() => {
                calculateInstallment();
            }, 500);
            
            // Initialize drop zones
            if (document.getElementById('dropZone')) {
                setupDropZone('dropZone', 'modalDocument', 'modalFilePreview', 'modalFileName', 'modalFileSize');
            }
            if (document.getElementById('replaceDropZone')) {
                setupDropZone('replaceDropZone', 'replaceDocument', 'replaceFilePreview', 'replaceFileName', 'replaceFileSize');
            }
            
            // Close modals with Escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    hideUploadModal();
                    hideReplaceModal();
                    hideRejectModal();
                }
            });
            
            // Close modals when clicking outside
            document.getElementById('uploadDocumentModal')?.addEventListener('click', function(e) {
                if (e.target === this) {
                    hideUploadModal();
                }
            });
            
            document.getElementById('replaceDocumentModal')?.addEventListener('click', function(e) {
                if (e.target === this) {
                    hideReplaceModal();
                }
            });
            
            document.getElementById('rejectModal')?.addEventListener('click', function(e) {
                if (e.target === this) {
                    hideRejectModal();
                }
            });
            
            setTimeout(() => {
                document.getElementById('successNotification')?.classList.add('hidden');
                document.getElementById('errorNotification')?.classList.add('hidden');
            }, 5000);
        });
    </script>
</body>
</html>