<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Loan Application Received</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .container {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #1e40af, #1e3a8a);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px;
        }
        .application-box {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .application-number {
            background: #1e40af;
            color: white;
            padding: 10px 15px;
            border-radius: 5px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
        }
        .info-box {
            background: #dbeafe;
            border: 1px solid #93c5fd;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .cta-box {
            text-align: center;
            margin: 30px 0;
        }
        .btn {
            display: inline-block;
            background: #1e40af;
            color: white;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: bold;
        }
        .footer {
            background: #f1f5f9;
            padding: 20px;
            text-align: center;
            color: #64748b;
            font-size: 14px;
        }
        .timeline {
            margin: 20px 0;
        }
        .timeline-item {
            display: flex;
            align-items: center;
            margin: 10px 0;
        }
        .timeline-icon {
            background: #1e40af;
            color: white;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>IMMIA FINANCE LIMITED</h1>
            <p>Loan Application Confirmation</p>
        </div>
        
        <div class="content">
            <h2>Dear {{ $customer->customer }},</h2>
            
            <p>Thank you for choosing IMMIA FINANCE LIMITED. We have successfully received your loan application and it is now under review.</p>
            
            <div class="application-box">
                <div class="application-number">
                    Application #: {{ $application->application_number }}
                </div>
                <div style="margin-bottom: 15px;">
                    <strong>Loan Details:</strong><br>
                    Product: {{ $application->product->product ?? 'Loan' }}<br>
                    Amount: ZMW {{ number_format($application->loan_amount, 2) }}<br>
                    Tenure: {{ $application->loan_tenure }} months<br>
                    Application Date: {{ $application->created_at->format('F d, Y') }}
                </div>
                <div>
                    <strong>Current Status:</strong> 
                    <span style="color: #1e40af; font-weight: bold;">SUBMITTED</span>
                </div>
            </div>

            <div class="info-box">
                <h3 style="margin-top: 0; color: #1e40af;">📋 What Happens Next?</h3>
                
                <div class="timeline">
                    <div class="timeline-item">
                        <div class="timeline-icon">1</div>
                        <div>
                            <strong>Initial Review</strong><br>
                            Our team will verify your application details (1-2 business days)
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">2</div>
                        <div>
                            <strong>Credit Assessment</strong><br>
                            Comprehensive evaluation of your application (2-3 business days)
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">3</div>
                        <div>
                            <strong>Final Decision</strong><br>
                            Approval committee review and final decision (1-2 business days)
                        </div>
                    </div>
                </div>
                
                <p><strong>Total Processing Time:</strong> 3-5 business days</p>
            </div>

            <div class="info-box">
                <h3 style="margin-top: 0; color: #1e40af;">🔍 Track Your Application</h3>
                <p>We encourage you to regularly log in to your customer portal for real-time updates on your application status. The portal provides the most current information about your loan application progress.</p>
                
                <div class="cta-box">
                    <a href="{{ url('/customer/login') }}" class="btn">Login to Customer Portal</a>
                </div>
                
                <p><strong>Email Notification:</strong> You will receive an email notification once your application has been approved or if we require additional information.</p>
            </div>

            <p>If you have any questions or need to provide additional documentation, please contact our customer service team.</p>

            <p>Best regards,<br>
            <strong>Customer Service Team</strong><br>
            IMMIA FINANCE LIMITED</p>
        </div>
        
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>If you need assistance, please contact us at support@managesmartinvoice.com</p>
            <p>IMMIA FINANCE LIMITED © {{ date('Y') }}</p>
        </div>
    </div>
</body>
</html>