@php
    // Define page variables
    $pageTitle = 'Rejected Applications';
    $pageSubtitle = 'Applications that have been rejected';
    
    // Define theme colors
    $themeBlue = '#0077C5';
    $themeBlueDark = '#005A94';
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | IMMIA FINANCE</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --zedbank-blue: {{ $themeBlue }}; 
            --zedbank-blue-dark: {{ $themeBlueDark }}; 
        }

        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }

        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }

        .compact-input { padding: 10px 14px; font-size: 0.875rem; } 
        .compact-label { font-size: 0.875rem; } 
        .detail-label { font-size: 0.75rem; color: #6b7280; } 
        .detail-value { font-size: 0.875rem; font-weight: 600; } 
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64 min-h-screen">
        
        @include('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ])

        <main class="p-6">
            <div class="max-w-7xl mx-auto">
                <div class="mb-6 flex items-center justify-between">
                    <a href="{{ route('admin.applications.index') }}" 
                       class="inline-flex items-center text-zedbank-blue hover:text-zedbank-blue-dark font-medium">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to Applications
                    </a>
                    
                    <div class="flex items-center space-x-4">
                        <div class="text-sm text-gray-600">
                            <i class="fas fa-times-circle text-red-500 mr-1"></i>
                            <span class="font-semibold">{{ $applications->total() }}</span> rejected applications
                        </div>
                    </div>
                </div>

                {{-- Search and Filters --}}
                <div class="bg-white rounded-xl shadow-sm border p-4 mb-6">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                        <div class="w-full md:w-auto">
                            <div class="relative">
                                <input type="text" 
                                       placeholder="Search by customer name or application number..." 
                                       class="w-full md:w-80 px-4 py-2 pl-10 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
                            </div>
                        </div>
                        
                        <div class="flex items-center space-x-4">
                            <select class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">All Products</option>
                                <option value="personal">Personal Loan</option>
                                <option value="business">Business Loan</option>
                                <option value="salary">Salary Advance</option>
                            </select>
                            
                            <select class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">All Time</option>
                                <option value="today">Today</option>
                                <option value="week">This Week</option>
                                <option value="month">This Month</option>
                                <option value="quarter">This Quarter</option>
                            </select>
                        </div>
                    </div>
                </div>

                {{-- Applications Table --}}
                <div class="bg-white rounded-xl shadow-sm border overflow-hidden">
                    @if($applications->isEmpty())
                        <div class="p-8 text-center">
                            <div class="mx-auto w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mb-4">
                                <i class="fas fa-times-circle text-red-500 text-2xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-900 mb-2">No Rejected Applications</h3>
                            <p class="text-gray-500">There are no rejected applications at the moment.</p>
                        </div>
                    @else
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Application Details
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Customer
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Loan Details
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Rejection Details
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($applications as $application)
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="flex items-center">
                                                    <div class="flex-shrink-0 h-10 w-10 bg-red-100 rounded-full flex items-center justify-center">
                                                        <i class="fas fa-times-circle text-red-600"></i>
                                                    </div>
                                                    <div class="ml-4">
                                                        <div class="text-sm font-medium text-gray-900">
                                                            {{ $application->application_number }}
                                                        </div>
                                                        <div class="text-sm text-gray-500">
                                                            {{ $application->product->product ?? 'N/A' }}
                                                        </div>
                                                        <div class="text-xs text-gray-400">
                                                            {{ $application->created_at->format('M d, Y') }}
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900">
                                                    {{ $application->customer->first_name }} {{ $application->customer->surname }}
                                                </div>
                                                <div class="text-sm text-gray-500">
                                                    {{ $application->customer->customer_number }}
                                                </div>
                                                <div class="text-xs text-gray-500">
                                                    {{ $application->customer->phone }}
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900">
                                                    <span class="font-medium">{{ number_format($application->loan_amount, 2) }}</span> {{ $application->currency->code ?? 'ZMW' }}
                                                </div>
                                                <div class="text-sm text-gray-500">
                                                    {{ $application->loan_tenure }} {{ $application->payment_frequency === 'monthly' ? 'Months' : 'Periods' }}
                                                </div>
                                                <div class="text-xs text-gray-400">
                                                    {{ number_format($application->interest_rate, 2) }}%
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                @if($application->reviewed_at)
                                                    <div class="text-sm text-gray-900">
                                                        {{ $application->reviewed_at->format('M d, Y H:i') }}
                                                    </div>
                                                    <div class="text-sm text-gray-500">
                                                        By: {{ $application->reviewedBy->name ?? 'Admin' }}
                                                    </div>
                                                @else
                                                    <div class="text-sm text-red-600">
                                                        <i class="fas fa-exclamation-circle mr-1"></i>
                                                        No review date
                                                    </div>
                                                @endif
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <div class="flex space-x-2">
                                                    <a href="{{ route('admin.applications.show', $application->id) }}" 
                                                       class="text-blue-600 hover:text-blue-900"
                                                       title="View Application">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <button onclick="confirmReopen({{ $application->id }})"
                                                            class="text-green-600 hover:text-green-900"
                                                            title="Reopen Application">
                                                        <i class="fas fa-redo"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        {{-- Pagination --}}
                        <div class="bg-white px-4 py-3 border-t border-gray-200 sm:px-6">
                            {{ $applications->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </main>
    </div>

    <script>
        function confirmReopen(applicationId) {
            if (confirm('Are you sure you want to reopen this rejected application? It will be moved back to pending applications.')) {
                // You can implement AJAX call here to reopen the application
                // For now, redirect to a reopen route
                window.location.href = `/admin/applications/${applicationId}/reopen`;
            }
        }
        
        $(document).ready(function() {
            // Search functionality
            $('input[type="text"]').on('keyup', function() {
                const searchTerm = $(this).val().toLowerCase();
                $('tbody tr').each(function() {
                    const rowText = $(this).text().toLowerCase();
                    if (rowText.indexOf(searchTerm) === -1) {
                        $(this).hide();
                    } else {
                        $(this).show();
                    }
                });
            });
        });
    </script>
</body>
</html>