@php
    // NOTE: $customer variable must be passed from the controller
    $pageTitle = $customer->first_name . ' ' . $customer->surname;
    $pageSubtitle = 'Customer Details';

    // Transactions - Unified Collection
    $disbursements = $customer->disbursements()->latest()->get();
    $repayments = $customer->repayments()->latest()->get();

    $allTransactions = collect()
        ->concat($disbursements->map(function($d) {
            $d->tx_type = 'Disbursement';
            $d->tx_date = $d->disburseddate;
            $d->tx_amount = $d->amount;
            return $d;
        }))
        ->concat($repayments->map(function($r) {
            $r->tx_type = 'Repayment';
            $r->tx_date = \Carbon\Carbon::parse($r->payment_date);
            $r->tx_amount = $r->amount_paid;
            return $r;
        }))
        ->sortByDesc('tx_date');

    // Messages - Unified Collection
    $allMessages = $customer->messages()->latest()->get();
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --midnight-indigo: #1A237E;
            --zedbank-blue: #0077C5; 
        }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        .bg-midnight { background-color: var(--midnight-indigo); }
        .text-midnight { color: var(--midnight-indigo); }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64 min-h-screen">
        @include('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle])

        <main class="p-6">
            <div class="max-w-5xl mx-auto">
                
                <div class="mb-8 flex justify-between items-start">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-800 mb-1">{{ $customer->customer }}</h1>
                        <p class="text-gray-500 font-medium">No: <span class="font-mono text-midnight">{{ $customer->customer_number }}</span></p>
                    </div>
                    <div class="flex space-x-3">
                        <button onclick="openChatModal({{ $customer->id }}, '{{ $customer->customer }}')" 
                                class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition flex items-center gap-2 shadow-sm">
                            <i class="fas fa-comment-dots"></i><span>Message</span>
                        </button>
                        <a href="{{ route('admin.customers.edit', $customer->id) }}" class="px-4 py-2 bg-midnight text-white rounded-lg hover:opacity-90 transition flex items-center gap-2">
                            <i class="fas fa-edit"></i><span>Edit Profile</span>
                        </a>
                        <a href="{{ route('admin.customers.index') }}" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition flex items-center gap-2">
                            <i class="fas fa-arrow-left"></i><span>Back</span>
                        </a>
                    </div>
                </div>

                <div class="space-y-6">
                    
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50 flex items-center gap-2">
                            <i class="fas fa-user-circle text-midnight"></i>
                            <h3 class="text-lg font-bold text-midnight">Personal & Contact Info</h3>
                        </div>
                        <div class="p-6 space-y-8">
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Title</label><p class="text-sm font-semibold text-gray-900">{{ $customer->title ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">First Name</label><p class="text-sm font-semibold text-gray-900">{{ $customer->first_name }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Middle Name</label><p class="text-sm font-semibold text-gray-900">{{ $customer->middle_name ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Surname</label><p class="text-sm font-semibold text-gray-900">{{ $customer->surname }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Date of Birth</label><p class="text-sm font-semibold text-gray-900">{{ $customer->dob ? \Carbon\Carbon::parse($customer->dob)->format('d M, Y') : '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Email</label><p class="text-sm font-semibold text-gray-900">{{ $customer->email }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Mobile Phone</label><p class="text-sm font-semibold text-gray-900">{{ $customer->phone }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Office Phone</label><p class="text-sm font-semibold text-gray-900">{{ $customer->office_phone ?? '—' }}</p></div>
                            </div>
                            <div class="pt-4 border-t border-gray-100 grid grid-cols-1 md:grid-cols-3 gap-6">
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Town</label><p class="text-sm font-semibold text-gray-900">{{ $customer->town }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Province</label><p class="text-sm font-semibold text-gray-900">{{ $customer->province }}</p></div>
                                <div class="md:col-span-3"><label class="text-[10px] text-gray-400 font-black uppercase">Residential Address</label><p class="text-sm font-semibold text-gray-900">{{ $customer->address }}</p></div>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                        <div class="px-6 py-4 border-b border-gray-100 flex items-center gap-2">
                            <i class="fas fa-heart text-red-600"></i>
                            <h3 class="text-lg font-bold text-gray-800">Next of Kin Details</h3>
                        </div>
                        <div class="p-6 space-y-8">
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">First Name</label><p class="text-sm font-semibold text-gray-900">{{ $customer->nok_first_name ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Surname</label><p class="text-sm font-semibold text-gray-900">{{ $customer->nok_surname ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Mobile</label><p class="text-sm font-semibold text-gray-900">{{ $customer->nok_mobile_phone ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Telephone</label><p class="text-sm font-semibold text-gray-900">{{ $customer->nok_phone ?? '—' }}</p></div>
                                <div class="md:col-span-2"><label class="text-[10px] text-gray-400 font-black uppercase">Email Address</label><p class="text-sm font-semibold text-gray-900">{{ $customer->nok_email ?? '—' }}</p></div>
                                <div class="md:col-span-2"><label class="text-[10px] text-gray-400 font-black uppercase">Physical Address</label><p class="text-sm font-semibold text-gray-900">{{ $customer->nok_physical_address ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Town</label><p class="text-sm font-semibold text-gray-900">{{ $customer->nok_town ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Province</label><p class="text-sm font-semibold text-gray-900">{{ $customer->nok_province ?? '—' }}</p></div>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50 flex items-center gap-2">
                            <i class="fas fa-briefcase text-midnight"></i>
                            <h3 class="text-lg font-bold text-midnight">Work Information</h3>
                        </div>
                        <div class="p-6 space-y-8">
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                                <div class="md:col-span-2"><label class="text-[10px] text-gray-400 font-black uppercase">Employer's Name</label><p class="text-sm font-semibold text-gray-900">{{ $customer->employer_name ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Job Title</label><p class="text-sm font-semibold text-gray-900">{{ $customer->job_title ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Employee No</label><p class="text-sm font-semibold text-gray-900">{{ $customer->employee_no ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Years Employed</label><p class="text-sm font-semibold text-gray-900">{{ $customer->years_in_employment ?? '0' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Retirement Year</label><p class="text-sm font-semibold text-gray-900">{{ $customer->retirement_year ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Employment Type</label><p class="text-sm font-semibold text-gray-900">{{ $customer->employment_type ?? 'Permanent' }}</p></div>
                                @if($customer->employment_type == 'Contract')
                                    <div><label class="text-[10px] text-red-500 font-black uppercase">Expiry Date</label><p class="text-sm font-bold text-red-600">{{ $customer->contract_expiry_date ?? '—' }}</p></div>
                                @endif
                            </div>
                            <div class="pt-4 border-t border-gray-100 grid grid-cols-1 md:grid-cols-4 gap-6">
                                <div class="md:col-span-2"><label class="text-[10px] text-gray-400 font-black uppercase">Work Address</label><p class="text-sm font-semibold text-gray-900">{{ $customer->employer_address ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Work Town</label><p class="text-sm font-semibold text-gray-900">{{ $customer->employer_town ?? '—' }}</p></div>
                                <div><label class="text-[10px] text-gray-400 font-black uppercase">Work Province</label><p class="text-sm font-semibold text-gray-900">{{ $customer->employer_province ?? '—' }}</p></div>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50 flex justify-between items-center">
                            <div class="flex items-center gap-2">
                                <i class="fas fa-exchange-alt text-midnight"></i>
                                <h3 class="text-lg font-bold text-gray-800">Transaction History</h3>
                            </div>
                            <span class="text-[10px] bg-gray-200 text-gray-600 px-2 py-1 rounded font-black uppercase tracking-widest">Unified Ledger</span>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="min-w-full text-xs">
                                <thead class="bg-gray-50/50 border-b">
                                    <tr class="text-gray-400 font-black uppercase tracking-tighter">
                                        <th class="px-6 py-3 text-left">Date</th>
                                        <th class="px-6 py-3 text-left">Type</th>
                                        <th class="px-6 py-3 text-left">Ref / Loan No</th>
                                        <th class="px-6 py-3 text-left">Amount</th>
                                        <th class="px-6 py-3 text-left">Status</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-100">
                                    @forelse($allTransactions as $tx)
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-6 py-4 font-medium text-gray-600">{{ $tx->tx_date ? $tx->tx_date->format('d M, Y') : '—' }}</td>
                                        <td class="px-6 py-4">
                                            <span class="px-2 py-1 rounded-md font-bold text-[9px] uppercase tracking-wider {{ $tx->tx_type === 'Disbursement' ? 'bg-blue-100 text-blue-700' : 'bg-green-100 text-green-700' }}">
                                                {{ $tx->tx_type }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-gray-500 font-mono">{{ $tx->loannumber ?? $tx->receipt_number ?? 'REF-'.$tx->id }}</td>
                                        <td class="px-6 py-4 font-bold {{ $tx->tx_type === 'Disbursement' ? 'text-midnight' : 'text-green-600' }}">
                                            {{ $tx->tx_type === 'Disbursement' ? '-' : '+' }} ZMW {{ number_format($tx->tx_amount, 2) }}
                                        </td>
                                        <td class="px-6 py-4"><span class="px-2 py-0.5 bg-gray-100 text-gray-600 rounded text-[10px] font-bold uppercase">{{ $tx->status ?? 'COMPLETED' }}</span></td>
                                    </tr>
                                    @empty
                                    <tr><td colspan="5" class="px-6 py-10 text-center text-gray-400">No transactions recorded.</td></tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50 flex justify-between items-center">
                            <div class="flex items-center gap-2">
                                <i class="fas fa-history text-midnight"></i>
                                <h3 class="text-lg font-bold text-gray-800">Communication History</h3>
                            </div>
                            <span class="text-[10px] bg-blue-50 text-midnight px-2 py-1 rounded font-black tracking-widest uppercase border border-blue-100">Chronological SMS Audit</span>
                        </div>
                        <div class="p-6 bg-slate-50/30">
                            <div class="space-y-4">
                                @forelse($allMessages as $message)
                                <div class="flex items-start gap-4 p-4 rounded-2xl bg-white border border-gray-100 shadow-sm">
                                    <div class="w-12 h-12 flex-shrink-0 flex items-center justify-center rounded-xl border border-gray-100 bg-gray-50">
                                        <i class="fas {{ match($message->category) {
                                            'Payment Reminder' => 'fa-file-invoice-dollar text-orange-500',
                                            'Follow Up' => 'fa-sync text-blue-500',
                                            'Document Requests' => 'fa-file-upload text-purple-500',
                                            'Promotions' => 'fa-bullhorn text-pink-500',
                                            default => 'fa-comment-alt text-gray-400'
                                        } }} text-lg"></i>
                                    </div>
                                    <div class="flex-1">
                                        <div class="flex justify-between items-start mb-2">
                                            <div class="flex items-center gap-2">
                                                <span class="px-2 py-0.5 rounded text-[9px] font-black uppercase bg-midnight text-white tracking-wider">{{ $message->category }}</span>
                                                <span class="text-[9px] font-bold uppercase {{ $message->status === 'sent' ? 'text-green-600' : 'text-red-600' }}">
                                                    • {{ $message->status === 'sent' ? 'Delivered' : 'Failed' }}
                                                </span>
                                            </div>
                                            <span class="text-[10px] text-gray-400 font-bold uppercase tracking-tighter">{{ $message->created_at->format('d M Y • h:i A') }}</span>
                                        </div>
                                        <p class="text-sm text-gray-700 leading-relaxed font-medium">{{ $message->message }}</p>
                                        <div class="mt-3 pt-3 border-t border-gray-50 flex items-center justify-between text-[10px] text-gray-500 font-bold uppercase tracking-widest">
                                            <span><i class="fas fa-mobile-alt mr-1"></i> {{ $message->phone_number }}</span>
                                            <span><i class="fas fa-user-shield mr-1"></i> {{ $message->sender->name ?? 'System' }}</span>
                                        </div>
                                    </div>
                                </div>
                                @empty
                                <div class="text-center py-20 opacity-40">
                                    <i class="fas fa-comment-slash text-4xl mb-4 text-gray-300"></i>
                                    <p class="text-xs font-bold uppercase tracking-widest">No communication history</p>
                                </div>
                                @endforelse
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </main>
    </div>

    @include('admin.customers.partials.chat_modal')

</body>
</html>