@php
    // Define page variables
    $pageTitle = 'Disbursements Channel';
    $pageSubtitle = 'Configure and manage loan disbursement methods';

    // Dummy stats (consistent with your layout)
    $stats = [
        'pending_applications' => 5,
    ];
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <style>
        :root {
            --zedbank-blue: #0077C5;
            --zedbank-blue-dark: #005A94;
            --zedbank-blue-medium: #005A94;
        }

        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .border-zedbank-blue-dark { border-color: var(--zedbank-blue-dark); }

        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }

        /* Modal Animation Custom */
        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen" x-data="{ 
    createModal: false, 
    editModal: false, 
    deleteModal: false,
    activeId: null,
    activeName: ''
}">
    
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64 min-h-screen">
        
        @include('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ])

        <main class="p-6">
                @if(session('success'))
                    <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-lg flex items-center justify-between">
                        <span>{{ session('success') }}</span>
                        <button class="text-green-700" onclick="this.parentElement.remove()">×</button>
                    </div>
                @endif

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 mb-6">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                        <div class="w-full md:w-auto">
                            <form action="{{ route('admin.disbursements-channel.index') }}" method="GET" class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-search text-gray-400"></i>
                                </div>
                                <input 
                                    type="text" 
                                    name="search" 
                                    value="{{ request('search') }}"
                                    class="block w-full md:w-80 pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-zedbank-blue focus:border-zedbank-blue focus:ring-1 focus:outline-none" 
                                    placeholder="Search channels..."
                                >
                            </form>
                        </div>
                        <div class="flex flex-wrap gap-2 w-full md:w-auto">
                            <button @click="createModal = true" class="px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition flex items-center gap-2">
                                <i class="fas fa-plus-circle"></i>
                                <span>New Channel</span>
                            </button>
                         
                            <a href="{{ route('admin.disbursements-channel.export', ['search' => request('search')]) }}" 
   class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
    <i class="fas fa-download"></i>
    <span>Export</span>
</a>
                            
                            
                            
                            
                        </div>
                    </div>
                </div>

                <div class="overflow-x-auto bg-white shadow-sm rounded-lg border border-gray-200">
                    <table class="min-w-full text-sm">
                        <thead class="bg-gray-50 border-b border-gray-200">
                            <tr>
                                <th class="px-6 py-3 text-left text-gray-600 font-medium">#ID</th>
                                <th class="px-6 py-3 text-left text-gray-600 font-medium">Channel Name</th>
                                <th class="px-6 py-3 text-left text-gray-600 font-medium">Created At</th>
                                <th class="px-6 py-3 text-left text-gray-600 font-medium">Actions</th>
                            </tr>
                        </thead>

                        <tbody class="divide-y divide-gray-100">
                            @forelse($channels as $channel)
                                <tr class="hover:bg-gray-50 transition">
                                    <td class="px-6 py-4 text-gray-500 font-mono">
                                        {{ $channel->id }}
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="font-medium text-gray-900">{{ $channel->disbursmentchannel }}</div>
                                    </td>
                                    <td class="px-6 py-4 text-gray-700">
                                        {{ $channel->created_at->format('M d, Y H:i') }}
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="flex space-x-3">
                                            <button 
                                                @click="activeId = '{{ $channel->id }}'; activeName = '{{ $channel->disbursmentchannel }}'; editModal = true"
                                                class="text-zedbank-blue hover:text-zedbank-blue-dark transition" 
                                                title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            
                                            <button 
                                                @click="activeId = '{{ $channel->id }}'; activeName = '{{ $channel->disbursmentchannel }}'; deleteModal = true"
                                                class="text-red-600 hover:text-red-800 transition" 
                                                title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                                        <div class="flex flex-col items-center justify-center">
                                            <i class="fas fa-money-check text-4xl text-gray-300 mb-4"></i>
                                            <p class="text-lg">No disbursement channels found</p>
                                            <button @click="createModal = true" class="mt-4 text-zedbank-blue hover:underline">Add one now</button>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-6">
                    {{ $channels->links() }}
                </div>
            </div>
        </main>
  
    <div x-show="createModal" x-cloak class="fixed inset-0 z-[60] overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div x-show="createModal" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"></div>
            <span class="hidden sm:inline-block sm:align-middle sm:min-h-screen" aria-hidden="true">&#8203;</span>
            <div x-show="createModal" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                <form action="{{ route('admin.disbursements-channel.store') }}" method="POST">
                    @csrf
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <h3 class="text-lg leading-6 font-bold text-gray-900 mb-4">Add New Disbursement Channel</h3>
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Channel Name</label>
                            <input type="text" name="disbursmentchannel" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-zedbank-blue focus:border-zedbank-blue outline-none" placeholder="e.g. Mobile Money, Bank Transfer">
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="submit" class="w-full inline-flex justify-center rounded-lg border border-transparent shadow-sm px-4 py-2 bg-zedbank-blue text-base font-medium text-white hover:bg-zedbank-blue-dark sm:ml-3 sm:w-auto sm:text-sm">Save Channel</button>
                        <button type="button" @click="createModal = false" class="mt-3 w-full inline-flex justify-center rounded-lg border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div x-show="editModal" x-cloak class="fixed inset-0 z-[60] overflow-y-auto">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75"></div>
            <div class="bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full z-[70]">
                <form :action="'{{ url('admin/disbursements-channel') }}/' + activeId" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">Edit Channel</h3>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Channel Name</label>
                            <input type="text" name="disbursmentchannel" x-model="activeName" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-zedbank-blue focus:border-zedbank-blue outline-none">
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:flex sm:flex-row-reverse">
                        <button type="submit" class="w-full inline-flex justify-center rounded-lg px-4 py-2 bg-zedbank-blue text-white font-medium hover:bg-zedbank-blue-dark sm:ml-3 sm:w-auto sm:text-sm">Update Channel</button>
                        <button type="button" @click="editModal = false" class="mt-3 w-full inline-flex justify-center rounded-lg border border-gray-300 px-4 py-2 bg-white text-gray-700 hover:bg-gray-50 sm:mt-0 sm:w-auto sm:text-sm">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div x-show="deleteModal" x-cloak class="fixed inset-0 z-[60] overflow-y-auto">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75"></div>
            <div class="bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full z-[70]">
                <form :action="'{{ url('admin/disbursements-channel') }}/' + activeId" method="POST">
                    @csrf
                    @method('DELETE')
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 text-center">
                        <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                            <i class="fas fa-exclamation-triangle text-red-600"></i>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-2">Delete Channel?</h3>
                        <p class="text-sm text-gray-500">Are you sure you want to delete <span class="font-bold" x-text="activeName"></span>? This action cannot be undone.</p>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:flex sm:flex-row-reverse">
                        <button type="submit" class="w-full inline-flex justify-center rounded-lg px-4 py-2 bg-red-600 text-white font-medium hover:bg-red-700 sm:ml-3 sm:w-auto sm:text-sm">Confirm Delete</button>
                        <button type="button" @click="deleteModal = false" class="mt-3 w-full inline-flex justify-center rounded-lg border border-gray-300 px-4 py-2 bg-white text-gray-700 hover:bg-gray-50 sm:mt-0 sm:w-auto sm:text-sm">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</body>
</html>