<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | ZedBankOS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* Define the custom theme color */
        :root {
            --zedbank-blue: #0077C5;
            --zedbank-blue-dark: #005A94; /* A slightly darker shade for hover/focus */
        }

        /* Custom Tailwind-like classes for the theme color */
        .bg-zedbank-blue {
            background-color: var(--zedbank-blue);
        }
        .hover\:bg-zedbank-blue-dark:hover {
            background-color: var(--zedbank-blue-dark);
        }
        .focus\:ring-zedbank-blue:focus {
            --tw-ring-color: var(--zedbank-blue);
        }
        .focus\:border-zedbank-blue:focus {
            border-color: var(--zedbank-blue);
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center">
    <div class="max-w-md w-full space-y-8 p-6">
        <div class="text-center">
            <div class="mx-auto w-16 h-16 bg-zedbank-blue rounded-lg flex items-center justify-center mb-4">
                <i class="fas fa-hand-holding-usd text-white text-2xl"></i>
            </div>
            <h2 class="text-3xl font-bold text-gray-900">ZedBankOS</h2>
            <p class="mt-2 text-gray-600">Admin Portal Login</p>
        </div>
        
        <form class="mt-8 space-y-6 bg-white p-8 rounded-xl shadow-sm border" method="POST" action="{{ route('login') }}">
            @csrf
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                <input id="email" name="email" type="email" required 
                       class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-1 focus:ring-zedbank-blue focus:border-zedbank-blue">
                @error('email')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                <input id="password" name="password" type="password" required 
                       class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-1 focus:ring-zedbank-blue focus:border-zedbank-blue">
                @error('password')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <button type="submit" 
                        class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-zedbank-blue hover:bg-zedbank-blue-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-zedbank-blue">
                    Sign in
                </button>
            </div>
        </form>
    </div>
</body>
</html>