<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Loan Application Update</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
        .application-details { background: white; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #EF4444; }
        .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }
        .button { display: inline-block; padding: 12px 30px; background: #667eea; color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .contact-info { background: #f8fafc; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #e2e8f0; }
        .next-steps { background: #fff7ed; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #fed7aa; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📋 Application Update</h1>
            <h2>Your Loan Application Status</h2>
        </div>
        
        <div class="content">
            <p>Dear <strong>{{ $customer->first_name }} {{ $customer->surname }}</strong>,</p>
            
            <p>Thank you for your loan application with IMMIA FINANCE LIMITED. We have carefully reviewed your application, and we regret to inform you that we are unable to approve your loan request at this time.</p>
            
            <div class="application-details">
                <h3 style="margin-top: 0; color: #EF4444;">Application Details</h3>
                <table style="width: 100%;">
                    <tr>
                        <td style="padding: 8px 0; width: 40%;"><strong>Application Number:</strong></td>
                        <td style="padding: 8px 0;">{{ $application->application_number }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Loan Amount:</strong></td>
                        <td style="padding: 8px 0;">${{ number_format($application->loan_amount, 2) }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Application Date:</strong></td>
                        <td style="padding: 8px 0;">{{ $application->created_at->format('F d, Y') }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Status:</strong></td>
                        <td style="padding: 8px 0; color: #EF4444; font-weight: bold;">Not Approved</td>
                    </tr>
                </table>
            </div>

            <div class="next-steps">
                <h4 style="margin-top: 0; color: #ea580c;">What You Can Do Next</h4>
                <ul style="margin-bottom: 0;">
                    <li>You may reapply after 90 days</li>
                    <li>Consider improving your credit score</li>
                    <li>Ensure all supporting documents are complete for future applications</li>
                    <li>Explore other financial products that may better suit your current situation</li>
                </ul>
            </div>

            <div class="contact-info">
                <h4 style="margin-top: 0; color: #667eea;">Need More Information?</h4>
                <p>If you would like more specific information about this decision or wish to discuss your application further, please don't hesitate to contact our customer service team.</p>
                
                <p><strong>Customer Service Hours:</strong><br>
                Monday - Friday: 8:00 AM - 5:00 PM<br>
                Saturday: 9:00 AM - 1:00 PM</p>
                
                <p><strong>Contact:</strong><br>
                Phone: +260 211 123 456<br>
                Email: info@immediafinance.co.zm</p>
            </div>

            <p>We appreciate your interest in IMMIA FINANCE LIMITED and encourage you to consider us for your future financial needs.</p>
            
            <p>Best regards,<br>
            <strong>IMMIA FINANCE LIMITED</strong><br>
            Credit Review Department</p>
        </div>
        
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>&copy; {{ date('Y') }} IMMIA FINANCE LIMITED. All rights reserved.</p>
        </div>
    </div>
</body>
</html>