<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Admin Portal | IMMIA FINANCE LIMITED')</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #1e40af;
            --primary-dark: #1e3a8a;
            --secondary: #0f172a;
            --accent: #06b6d4;
            --light: #f8fafc;
        }
        
        .sidebar {
            transition: all 0.3s ease;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 40;
        }
        
        @media (max-width: 1024px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
        }
        
        .main-content {
            margin-left: 0;
            min-height: 100vh;
            width: 100%;
        }
        
        @media (min-width: 1024px) {
            .main-content {
                margin-left: 16rem;
                width: calc(100% - 16rem);
            }
        }
        
        .notification-dot {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }

        /* Ensure proper stacking context */
        .z-50 {
            z-index: 50;
        }
        
        .z-40 {
            z-index: 40;
        }
        
        .z-30 {
            z-index: 30;
        }

        /* Fix for main content positioning */
        .main-content-wrapper {
            position: relative;
            width: 100%;
        }

        /* Dropdown improvements */
        .dropdown-content {
            transition: all 0.3s ease;
            max-height: 0;
            overflow: hidden;
        }
        
        .dropdown-content.open {
            max-height: 500px;
        }
    </style>
    
    @yield('styles')
</head>
<body class="bg-gray-50">
    <!-- Mobile Menu Button -->
    <button id="mobile-menu-button" class="lg:hidden fixed top-4 left-4 z-50 bg-blue-600 text-white p-3 rounded-lg shadow-lg">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Sidebar -->
    <div id="sidebar" class="sidebar w-64 bg-white shadow-lg">
        <!-- Logo -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center">
                    <i class="fas fa-hand-holding-usd text-white text-lg"></i>
                </div>
                <div>
                    <h1 class="text-xl font-bold text-blue-600">IMMIA FINANCE</h1>
                    <p class="text-gray-500 text-xs">Admin Portal</p>
                </div>
            </div>
        </div>
        
        <!-- Navigation -->
        <nav class="p-4 space-y-2 overflow-y-auto" style="height: calc(100vh - 120px);">
            <a href="{{ route('admin.dashboard') }}" class="flex items-center space-x-3 p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium {{ request()->routeIs('admin.dashboard') ? 'bg-blue-50 text-blue-600' : '' }}">
                <i class="fas fa-tachometer-alt w-5"></i>
                <span>Dashboard</span>
            </a>
            
       
            <!-- Customers Menu -->
            @if(auth()->user()->hasAnyPermission(['customers.view', 'customers.create', 'customers.edit', 'poweruser']))
            <a href="{{ route('admin.customers.index') }}" class="flex items-center space-x-3 p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium {{ request()->routeIs('admin.customers.*') ? 'bg-blue-50 text-blue-600' : '' }}">
              <i class="fas fa-users w-5"></i>
              <span>Customers</span>
            </a>
            @endif
            
            <!-- Applications Menu -->
            @if(auth()->user()->hasAnyPermission(['applications.view', 'applications.approve', 'applications.create', 'poweruser']))
            <div class="group">
                <button class="flex items-center justify-between w-full p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium {{ request()->routeIs('admin.applications.*') ? 'bg-blue-50 text-blue-600' : '' }}">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-file-invoice-dollar w-5"></i>
                        <span>Applications</span>
                    </div>
                    <i class="fas fa-chevron-down text-gray-400 text-xs transition-transform duration-300 group-hover:rotate-180"></i>
                </button>
                <div class="ml-8 mt-2 space-y-2 dropdown-content">
                    <a href="{{ route('admin.applications.index') }}" class="flex items-center space-x-3 p-2 text-gray-600 hover:text-blue-600 rounded-lg {{ request()->routeIs('admin.applications.index') ? 'bg-blue-50 text-blue-600' : '' }}">
                        <i class="fas fa-list w-4"></i>
                        <span class="text-sm">All Applications</span>
                        @if(isset($stats['pending_applications']) && $stats['pending_applications'] > 0)
                        <span class="ml-auto bg-red-100 text-red-600 text-xs px-2 py-1 rounded-full">{{ $stats['pending_applications'] }}</span>
                        @endif
                    </a>
                    <!-- Approved Applications Menu Item -->
                    <a href="{{ route('admin.applications.approved') }}" class="flex items-center space-x-3 p-2 text-gray-600 hover:text-blue-600 rounded-lg {{ request()->routeIs('admin.applications.approved') ? 'bg-blue-50 text-blue-600' : '' }}">
                        <i class="fas fa-check-circle w-4"></i>
                        <span class="text-sm">Approved Applications</span>
                        @if(isset($stats['approved_applications']) && $stats['approved_applications'] > 0)
                        <span class="ml-auto bg-green-100 text-green-600 text-xs px-2 py-1 rounded-full">{{ $stats['approved_applications'] }}</span>
                        @endif
                    </a>
                </div>
            </div>
            @endif
            
            <!-- Loans Menu -->
            @if(auth()->user()->hasAnyPermission(['loans.view', 'poweruser']))
            <div class="group">
                <button class="flex items-center justify-between w-full p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium {{ request()->routeIs('admin.loans.*') ? 'bg-blue-50 text-blue-600' : '' }}">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-hand-holding-usd w-5"></i>
                        <span>Loans</span>
                    </div>
                    <i class="fas fa-chevron-down text-gray-400 text-xs transition-transform duration-300 group-hover:rotate-180"></i>
                </button>
                <div class="ml-8 mt-2 space-y-2 dropdown-content">
                    <a href="{{ route('admin.loans.active') }}" class="flex items-center space-x-3 p-2 text-gray-600 hover:text-blue-600 rounded-lg {{ request()->routeIs('admin.loans.active') ? 'bg-blue-50 text-blue-600' : '' }}">
                        <i class="fas fa-play-circle w-4"></i>
                        <span class="text-sm">Active Loans</span>
                        @if(isset($stats['active_loans']))
                        <span class="ml-auto bg-green-100 text-green-600 text-xs px-2 py-1 rounded-full">{{ $stats['active_loans'] }}</span>
                        @endif
                    </a>
                    <a href="{{ route('admin.loans.closed') }}" class="flex items-center space-x-3 p-2 text-gray-600 hover:text-blue-600 rounded-lg {{ request()->routeIs('admin.loans.closed') ? 'bg-blue-50 text-blue-600' : '' }}">
                        <i class="fas fa-check-circle w-4"></i>
                        <span class="text-sm">Closed Loans</span>
                        @if(isset($stats['closed_loans']))
                        <span class="ml-auto bg-gray-100 text-gray-600 text-xs px-2 py-1 rounded-full">{{ $stats['closed_loans'] }}</span>
                        @endif
                    </a>
                    <a href="{{ route('admin.loans.non-performing') }}" class="flex items-center space-x-3 p-2 text-gray-600 hover:text-blue-600 rounded-lg {{ request()->routeIs('admin.loans.non-performing') ? 'bg-blue-50 text-blue-600' : '' }}">
                        <i class="fas fa-exclamation-triangle w-4"></i>
                        <span class="text-sm">Non-Performing</span>
                        @if(isset($stats['non_performing_loans']) && $stats['non_performing_loans'] > 0)
                        <span class="ml-auto bg-red-100 text-red-600 text-xs px-2 py-1 rounded-full">{{ $stats['non_performing_loans'] }}</span>
                        @endif
                    </a>
                </div>
            </div>
            @endif
            
            <!-- Collections Menu -->
            @if(auth()->user()->hasAnyPermission(['collections.view', 'poweruser']))
            <a href="{{ route('admin.collections.index') }}" class="flex items-center space-x-3 p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium {{ request()->routeIs('admin.collections.index') ? 'bg-blue-50 text-blue-600' : '' }}">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Collections</span>
            </a>
            @endif
            
            <!-- Other Menu Items -->
            @if(auth()->user()->hasPermission('poweruser'))
            <a href="{{ route('admin.investments.index') }}" class="flex items-center space-x-3 p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium {{ request()->routeIs('admin.investments.index') ? 'bg-blue-50 text-blue-600' : '' }}">
                <i class="fas fa-chart-line w-5"></i>
                <span>Investments</span>
            </a>
            
            <a href="{{ route('admin.accounting.index') }}" class="flex items-center space-x-3 p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium {{ request()->routeIs('admin.accounting.index') ? 'bg-blue-50 text-blue-600' : '' }}">
                <i class="fas fa-calculator w-5"></i>
                <span>Accounting</span>
            </a>
           
            <!-- Settings -->
            <div class="group">
                <button class="flex items-center justify-between w-full p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium {{ request()->routeIs('admin.settings.*') ? 'bg-blue-50 text-blue-600' : '' }}">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-cog w-5"></i>
                        <span>Settings</span>
                    </div>
                    <i class="fas fa-chevron-down text-gray-400 text-xs transition-transform duration-300 group-hover:rotate-180"></i>
                </button>
                <div class="ml-8 mt-2 space-y-2 dropdown-content">
                    <a href="{{ route('admin.settings.branches') }}" class="flex items-center space-x-3 p-2 text-gray-600 hover:text-blue-600 rounded-lg {{ request()->routeIs('admin.settings.branches') ? 'bg-blue-50 text-blue-600' : '' }}">
                        <i class="fas fa-code-branch w-4"></i>
                        <span class="text-sm">Branches</span>
                    </a>
                    <a href="{{ route('admin.settings.users') }}" class="flex items-center space-x-3 p-2 text-gray-600 hover:text-blue-600 rounded-lg {{ request()->routeIs('admin.settings.users') ? 'bg-blue-50 text-blue-600' : '' }}">
                        <i class="fas fa-users w-4"></i>
                        <span class="text-sm">Users</span>
                    </a>
                    <a href="{{ route('admin.settings.permissions') }}" class="flex items-center space-x-3 p-2 text-gray-600 hover:text-blue-600 rounded-lg {{ request()->routeIs('admin.settings.permissions') ? 'bg-blue-50 text-blue-600' : '' }}">
                        <i class="fas fa-shield-alt w-4"></i>
                        <span class="text-sm">Permissions</span>
                    </a>
                </div>
            </div>
            @endif

            <!-- Logout -->
            <form method="POST" action="{{ route('admin.logout') }}" class="mt-8">
                @csrf
                <button type="submit" class="flex items-center space-x-3 p-3 text-gray-700 hover:bg-gray-100 rounded-lg font-medium w-full">
                    <i class="fas fa-sign-out-alt w-5"></i>
                    <span>Logout</span>
                </button>
            </form>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Bar -->
        <header class="bg-white shadow-sm border-b border-gray-200 sticky top-0 z-30">
            <div class="flex justify-between items-center px-6 py-4">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">@yield('page-title', 'Admin Portal')</h1>
                    <p class="text-gray-600">@yield('page-description', 'Welcome back, ' . auth()->user()->name)</p>
                </div>
                
                <div class="flex items-center space-x-4">
                    <!-- Notifications -->
                    <div class="relative">
                        <button class="p-2 text-gray-600 hover:text-blue-600 relative">
                            <i class="fas fa-bell text-xl"></i>
                            @if(isset($stats['pending_applications']) && $stats['pending_applications'] > 0)
                            <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full notification-dot"></span>
                            @endif
                        </button>
                    </div>
                    
                    <!-- User Menu -->
                    <div class="relative">
                        <button class="flex items-center space-x-3 p-2 rounded-lg hover:bg-gray-100">
                            <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-user text-blue-600"></i>
                            </div>
                            <span class="text-gray-700 font-medium">{{ auth()->user()->name }}</span>
                        </button>
                    </div>
                </div>
            </div>
        </header>

        <!-- Main Content Area -->
        <main class="p-6 bg-gray-50 min-h-screen">
            @yield('content')
        </main>
    </div>

    <script>
        // Mobile menu toggle
        document.getElementById('mobile-menu-button').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('active');
        });

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const mobileButton = document.getElementById('mobile-menu-button');
            
            if (window.innerWidth < 1024 && 
                !sidebar.contains(event.target) && 
                !mobileButton.contains(event.target)) {
                sidebar.classList.remove('active');
            }
        });

        // Handle window resize
        window.addEventListener('resize', function() {
            if (window.innerWidth >= 1024) {
                document.getElementById('sidebar').classList.remove('active');
            }
        });

        // Enhanced dropdown menu functionality
        document.addEventListener('DOMContentLoaded', function() {
            const dropdownButtons = document.querySelectorAll('.group > button');
            
            dropdownButtons.forEach(button => {
                button.addEventListener('click', function(e) {
                    e.stopPropagation();
                    const dropdown = this.nextElementSibling;
                    const isOpen = dropdown.classList.contains('open');
                    
                    // Close all other dropdowns
                    document.querySelectorAll('.dropdown-content.open').forEach(openDropdown => {
                        if (openDropdown !== dropdown) {
                            openDropdown.classList.remove('open');
                            openDropdown.style.maxHeight = '0';
                        }
                    });
                    
                    // Toggle current dropdown
                    if (isOpen) {
                        dropdown.classList.remove('open');
                        dropdown.style.maxHeight = '0';
                    } else {
                        dropdown.classList.add('open');
                        dropdown.style.maxHeight = dropdown.scrollHeight + 'px';
                    }
                });
            });

            // Close dropdowns when clicking outside
            document.addEventListener('click', function() {
                document.querySelectorAll('.dropdown-content.open').forEach(dropdown => {
                    dropdown.classList.remove('open');
                    dropdown.style.maxHeight = '0';
                });
            });

            // Prevent dropdown close when clicking inside dropdown
            document.querySelectorAll('.dropdown-content').forEach(dropdown => {
                dropdown.addEventListener('click', function(e) {
                    e.stopPropagation();
                });
            });

            // Auto-open dropdown if current page is in the dropdown
            document.querySelectorAll('.dropdown-content a').forEach(link => {
                if (link.classList.contains('bg-blue-50')) {
                    const dropdown = link.closest('.dropdown-content');
                    const button = dropdown.previousElementSibling;
                    
                    dropdown.classList.add('open');
                    dropdown.style.maxHeight = dropdown.scrollHeight + 'px';
                    button.classList.add('bg-blue-50', 'text-blue-600');
                }
            });
        });

        // Simulate real-time updates for notification dot
        setInterval(() => {
            const dot = document.querySelector('.notification-dot');
            if (dot) {
                dot.style.animation = 'none';
                setTimeout(() => {
                    dot.style.animation = 'pulse 2s infinite';
                }, 10);
            }
        }, 5000);
    </script>

    @yield('scripts')
</body>
</html>