<?php
    // Define page variables
    $pageTitle = 'Loan Payment Schedule';
    $pageSubtitle = 'Amortization schedule for loan ' . $loan->loannumber;
    
    // Calculate summary statistics
    $totalPrincipal = $paymentSchedules->sum('principalamount');
    $totalInterest = $paymentSchedules->sum('interestamount');
    $totalProcessingFee = $paymentSchedules->sum('processingfeesamount');
    $totalAmount = $paymentSchedules->sum('totalamount');
    $totalPaid = $paymentSchedules->sum('total_paid');
    $totalPenaltyPaid = $paymentSchedules->sum('paid_penalty');
    
    $paidCount = $paymentSchedules->where('status', 'paid')->count();
    $scheduledCount = $paymentSchedules->where('status', 'scheduled')->count();
    $overdueCount = $paymentSchedules->where('status', 'overdue')->count();
    $totalCount = $paymentSchedules->count();
    
    $paymentRatio = $totalCount > 0 ? round(($paidCount / $totalCount) * 100, 1) : 0;
    
    // Format processing fee and penalty details
    $processingFeeRate = $loan->processing_fee ?? 0;
    $processingFeeBasis = $loan->processing_fee_basis ?? 'initial_amount';
    $penaltyRate = $loan->penalty_rate ?? 0;
    $penaltyBasis = $loan->penalty_basis ?? 'percentage_of_due';
    
    // Helper function to format basis
    function formatBasis($basis) {
        $mapping = [
            'initial_amount' => 'Initial Loan Amount',
            'outstanding_balance' => 'Outstanding Balance',
            'percentage_of_due' => 'Percentage of Due Amount',
            'fixed_amount' => 'Fixed Amount',
            'daily_rate' => 'Daily Rate'
        ];
        return $mapping[$basis] ?? ucfirst(str_replace('_', ' ', $basis));
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | IMMIA FINANCE</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5;
            --zedbank-blue-dark: #005A94;
        }
        
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }
        
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }
        
        /* Custom colors for schedule */
        .text-interest { color: #8B4513; }
        .bg-interest-light { background-color: #FFF8DC; }
        .text-penalty { color: #FF6B35; }
        .bg-penalty-light { background-color: #FFE5D9; }
        .text-processing { color: #9932CC; }
        .bg-processing-light { background-color: #E6E6FA; }
        .text-total { color: #000080; }
        .bg-total-light { background-color: #F0F8FF; }
        .text-principal-outstanding { color: #6A0DAD; }
        .bg-principal-outstanding-light { background-color: #F3E5F5; }
        
        /* Print styles */
        @media print {
            .no-print { display: none !important; }
            body { background-color: white; }
            .print-container { margin: 0; padding: 0; }
            table { page-break-inside: avoid; }
            tr { page-break-inside: avoid; page-break-after: auto; }
            .schedule-table th { background-color: #f0f0f0 !important; color: black !important; }
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            
            <div class="mb-8">
                <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                    <div>
                        <div class="flex items-center mb-2">
                            <a href="<?php echo e(route('admin.loans.show', $loan->loanid)); ?>" 
                               class="inline-flex items-center text-zedbank-blue hover:text-zedbank-blue-dark mr-3 transition no-print">
                                <i class="fas fa-arrow-left mr-1"></i>
                                Back to Loan Details
                            </a>
                            <h1 class="text-3xl font-bold text-gray-800">Payment Schedule: <?php echo e($loan->loannumber); ?></h1>
                        </div>
                        <p class="text-gray-600">
                            <?php echo e($totalCount); ?> scheduled payment(s) | 
                            Generated: <?php echo e(now()->format('M d, Y H:i')); ?>

                        </p>
                    </div>
                    
                    <div class="flex flex-wrap gap-2 no-print">
                        
                        <a href="<?php echo e(route('admin.loans.export-schedule', $loan->loanid)); ?>" 
                           target="_blank"
                           class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition font-medium flex items-center">
                            <i class="fas fa-file-pdf mr-2"></i>
                            Export PDF
                        </a>
                    </div>
                </div>
            </div>

            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Customer</p>
                            <p class="font-bold text-gray-800">
                                <?php if($loan->customer): ?>
                                    <?php echo e($loan->customer->first_name); ?> <?php echo e($loan->customer->surname); ?>

                                <?php else: ?>
                                    <span class="text-gray-500">—</span>
                                <?php endif; ?>
                            </p>
                            <?php if($loan->customer && $loan->customer->customer_number): ?>
                                <p class="text-xs text-gray-500 mt-1"><?php echo e($loan->customer->customer_number); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-user text-blue-600"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Loan Amount</p>
                            <p class="text-lg font-bold text-green-600"><?php echo e(number_format($loan->amount, 2)); ?></p>
                            <p class="text-xs text-gray-500 mt-1">Interest: <?php echo e(number_format($loan->interestrate, 2)); ?>%</p>
                        </div>
                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-money-bill-wave text-green-600"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Processing Fee</p>
                            <p class="text-lg font-bold text-processing"><?php echo e(number_format($processingFeeRate, 2)); ?>%</p>
                            <p class="text-xs text-gray-500 mt-1"><?php echo e(formatBasis($processingFeeBasis)); ?></p>
                        </div>
                        <div class="w-10 h-10 bg-processing-light rounded-lg flex items-center justify-center">
                            <i class="fas fa-calculator text-processing"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Penalty Rate</p>
                            <p class="text-lg font-bold text-penalty"><?php echo e(number_format($penaltyRate, 2)); ?>%</p>
                            <p class="text-xs text-gray-500 mt-1"><?php echo e(formatBasis($penaltyBasis)); ?></p>
                        </div>
                        <div class="w-10 h-10 bg-penalty-light rounded-lg flex items-center justify-center">
                            <i class="fas fa-exclamation-circle text-penalty"></i>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 mb-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Fee & Penalty Details</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <h4 class="text-md font-medium text-processing mb-3 flex items-center">
                            <i class="fas fa-calculator mr-2"></i>
                            Processing Fee Details
                        </h4>
                        <div class="space-y-2">
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Processing Fee Rate:</span>
                                <span class="font-bold text-processing"><?php echo e(number_format($processingFeeRate, 2)); ?>%</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Calculation Basis:</span>
                                <span class="font-medium text-gray-700"><?php echo e(formatBasis($processingFeeBasis)); ?></span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Total Processing Fees:</span>
                                <span class="font-bold text-processing"><?php echo e(number_format($totalProcessingFee, 2)); ?></span>
                            </div>
                            <?php if($processingFeeBasis === 'initial_amount'): ?>
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-600">Amount per Installment:</span>
                                    <span class="text-sm text-gray-500">
                                        <?php echo e(number_format(($loan->amount * ($processingFeeRate/100)) / max($totalCount, 1), 2)); ?>

                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div>
                        <h4 class="text-md font-medium text-penalty mb-3 flex items-center">
                            <i class="fas fa-exclamation-circle mr-2"></i>
                            Penalty Details
                        </h4>
                        <div class="space-y-2">
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Penalty Rate:</span>
                                <span class="font-bold text-penalty"><?php echo e(number_format($penaltyRate, 2)); ?>%</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Calculation Basis:</span>
                                <span class="font-medium text-gray-700"><?php echo e(formatBasis($penaltyBasis)); ?></span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Penalties Paid to Date:</span>
                                <span class="font-bold text-penalty"><?php echo e(number_format($totalPenaltyPaid, 2)); ?></span>
                            </div>
                            <?php if($loan->penalty_balance > 0): ?>
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-600">Outstanding Penalties:</span>
                                    <span class="font-bold text-red-600"><?php echo e(number_format($loan->penalty_balance, 2)); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Scheduled Payments</p>
                            <p class="text-lg font-bold text-blue-600"><?php echo e($scheduledCount); ?></p>
                        </div>
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-clock text-blue-600"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Paid Installments</p>
                            <p class="text-lg font-bold text-green-600"><?php echo e($paidCount); ?></p>
                            <p class="text-xs text-gray-500 mt-1"><?php echo e($paymentRatio); ?>% completion</p>
                        </div>
                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-check-circle text-green-600"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Overdue</p>
                            <p class="text-lg font-bold text-red-600"><?php echo e($overdueCount); ?></p>
                            <p class="text-xs text-gray-500 mt-1">
                                <?php if($overdueCount > 0): ?>
                                    Action required
                                <?php else: ?>
                                    All payments current
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-exclamation-triangle text-red-600"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg p-4 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600">Total Paid</p>
                            <p class="text-lg font-bold text-indigo-600"><?php echo e(number_format($totalPaid, 2)); ?></p>
                            <p class="text-xs text-gray-500 mt-1">
                                Remaining: <?php echo e(number_format($totalAmount - $totalPaid, 2)); ?>

                            </p>
                        </div>
                        <div class="w-10 h-10 bg-indigo-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-hand-holding-usd text-indigo-600"></i>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden print-container">
                <div class="border-b border-gray-200 px-6 py-4 flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-gray-800">Amortization Schedule</h2>
                    <div class="text-sm text-gray-600">
                        <span class="font-medium">Showing <?php echo e($paymentSchedules->count()); ?> of <?php echo e($totalCount); ?> installments</span>
                        <span class="ml-4 text-gray-500">All amounts in Zambian Kwacha (K)</span>
                    </div>
                </div>
                <div class="p-6">
                    <?php if($paymentSchedules->count() > 0): ?>
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200 schedule-table">
                                <thead>
                                    <tr class="bg-gray-50">
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">#</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due Date</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Principal (K)</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Interest (K)</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Fee (K)</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Penalty (K)</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Outstanding Principal (K)</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Due (K)</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paid Date</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount Paid (K)</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Balance (K)</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    <?php
                                        $runningPrincipal = $loan->amount;
                                        $installmentNumber = 0;
                                    ?>
                                    
                                    <?php $__currentLoopData = $paymentSchedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $installmentNumber++;
                                            $isOverdue = false;
                                            if ($schedule->paymentdate) {
                                                $dueDate = \Carbon\Carbon::parse($schedule->paymentdate);
                                                $isOverdue = $dueDate->isPast() && $schedule->status !== 'paid' && $schedule->status !== 'closed';
                                            }
                                            
                                            $balance = $schedule->totalamount - $schedule->total_paid;
                                            
                                            // Calculate outstanding principal BEFORE this payment
                                            $outstandingPrincipal = $runningPrincipal;
                                            
                                            // Reduce the running principal for next iteration
                                            // Only reduce if the principal portion would be paid
                                            if ($schedule->status === 'paid') {
                                                $runningPrincipal -= $schedule->principalamount;
                                            } else {
                                                // For unpaid installments, we still show what would be outstanding
                                                $runningPrincipal -= $schedule->principalamount;
                                            }
                                            
                                            // Ensure running principal doesn't go below zero
                                            $runningPrincipal = max(0, $runningPrincipal);
                                            
                                            $rowClass = '';
                                            if ($schedule->status === 'paid') {
                                                $rowClass = 'bg-green-50';
                                            } elseif ($schedule->status === 'overdue' || $isOverdue) {
                                                $rowClass = 'bg-red-50';
                                            } elseif ($schedule->status === 'closed') {
                                                $rowClass = 'bg-gray-50';
                                            }
                                            
                                            $statusColor = '';
                                            $statusIcon = '';
                                            if ($schedule->status === 'paid') {
                                                $statusColor = 'text-green-800 bg-green-100';
                                                $statusIcon = 'fa-check-circle';
                                            } elseif ($schedule->status === 'overdue' || $isOverdue) {
                                                $statusColor = 'text-red-800 bg-red-100';
                                                $statusIcon = 'fa-exclamation-triangle';
                                            } elseif ($schedule->status === 'scheduled') {
                                                $statusColor = 'text-blue-800 bg-blue-100';
                                                $statusIcon = 'fa-clock';
                                            } elseif ($schedule->status === 'closed') {
                                                $statusColor = 'text-gray-800 bg-gray-100';
                                                $statusIcon = 'fa-lock';
                                            } else {
                                                $statusColor = 'text-gray-800 bg-gray-100';
                                                $statusIcon = 'fa-question-circle';
                                            }
                                        ?>
                                        
                                        <tr class="<?php echo e($rowClass); ?> hover:bg-gray-50">
                                            <td class="px-4 py-3 text-sm text-gray-900">
                                                <?php echo e($installmentNumber); ?>

                                            </td>
                                            <td class="px-4 py-3 text-sm text-gray-900">
                                                <?php if($schedule->paymentdate): ?>
                                                    <?php echo e(\Carbon\Carbon::parse($schedule->paymentdate)->format('M d, Y')); ?>

                                                    <?php if($isOverdue && $schedule->status !== 'overdue'): ?>
                                                        <br>
                                                        <span class="text-xs text-red-600">
                                                            <i class="fas fa-exclamation-circle mr-1"></i>
                                                            Overdue
                                                        </span>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                            <td class="px-4 py-3 text-sm font-medium text-red-600 text-right">
                                                <?php echo e(number_format($schedule->principalamount, 2)); ?>

                                            </td>
                                            <td class="px-4 py-3 text-sm font-medium text-interest text-right">
                                                <?php echo e(number_format($schedule->interestamount, 2)); ?>

                                            </td>
                                            <td class="px-4 py-3 text-sm font-medium text-processing text-right">
                                                <?php echo e(number_format($schedule->processingfeesamount, 2)); ?>

                                            </td>
                                            <td class="px-4 py-3 text-sm font-medium text-penalty text-right">
                                                <?php echo e(number_format($schedule->paid_penalty, 2)); ?>

                                            </td>
                                            <td class="px-4 py-3 text-sm font-medium text-principal-outstanding text-right">
                                                <?php echo e(number_format($outstandingPrincipal, 2)); ?>

                                                <?php if($schedule->status === 'paid' && $schedule->principalamount > 0): ?>
                                                    <span class="text-xs text-gray-500 block">
                                                        → <?php echo e(number_format($runningPrincipal, 2)); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="px-4 py-3 text-sm font-bold text-gray-900 text-right">
                                                <?php echo e(number_format($schedule->totalamount, 2)); ?>

                                            </td>
                                            <td class="px-4 py-3">
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($statusColor); ?>">
                                                    <i class="fas <?php echo e($statusIcon); ?> mr-1"></i>
                                                    <?php if($isOverdue && $schedule->status !== 'overdue'): ?>
                                                        Overdue
                                                    <?php else: ?>
                                                        <?php echo e(ucfirst($schedule->status)); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </td>
                                            <td class="px-4 py-3 text-sm text-gray-900">
                                                <?php if($schedule->paid_date): ?>
                                                    <?php echo e(\Carbon\Carbon::parse($schedule->paid_date)->format('M d, Y')); ?>

                                                <?php else: ?>
                                                    —
                                                <?php endif; ?>
                                            </td>
                                            <td class="px-4 py-3 text-sm font-bold <?php echo e($schedule->total_paid > 0 ? 'text-green-600' : 'text-gray-500'); ?> text-right">
                                                <?php echo e(number_format($schedule->total_paid, 2)); ?>

                                            </td>
                                            <td class="px-4 py-3 text-sm font-bold <?php echo e($balance > 0 ? 'text-red-600' : 'text-green-600'); ?> text-right">
                                                <?php echo e(number_format($balance, 2)); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                
                                <tfoot class="bg-gray-50">
                                    <tr>
                                        <td colspan="2" class="px-4 py-3 text-sm font-medium text-gray-900 text-right">
                                            <strong>TOTALS:</strong>
                                        </td>
                                        <td class="px-4 py-3 text-sm font-bold text-red-600 text-right">
                                            <strong><?php echo e(number_format($totalPrincipal, 2)); ?></strong>
                                        </td>
                                        <td class="px-4 py-3 text-sm font-bold text-interest text-right">
                                            <strong><?php echo e(number_format($totalInterest, 2)); ?></strong>
                                        </td>
                                        <td class="px-4 py-3 text-sm font-bold text-processing text-right">
                                            <strong><?php echo e(number_format($totalProcessingFee, 2)); ?></strong>
                                        </td>
                                        <td class="px-4 py-3 text-sm font-bold text-penalty text-right">
                                            <strong><?php echo e(number_format($totalPenaltyPaid, 2)); ?></strong>
                                        </td>
                                        <td class="px-4 py-3 text-sm font-bold text-principal-outstanding text-right">
                                            <strong><?php echo e(number_format($runningPrincipal, 2)); ?></strong>
                                            <span class="text-xs text-gray-500 block">Remaining Principal</span>
                                        </td>
                                        <td class="px-4 py-3 text-sm font-bold text-gray-900 text-right">
                                            <strong><?php echo e(number_format($totalAmount, 2)); ?></strong>
                                        </td>
                                        <td class="px-4 py-3 text-sm text-gray-500">
                                            <?php echo e($paidCount); ?> paid / <?php echo e($totalCount); ?> total
                                        </td>
                                        <td class="px-4 py-3 text-sm text-gray-500">
                                            —
                                        </td>
                                        <td class="px-4 py-3 text-sm font-bold text-green-600 text-right">
                                            <strong><?php echo e(number_format($totalPaid, 2)); ?></strong>
                                        </td>
                                        <td class="px-4 py-3 text-sm font-bold <?php echo e(($totalAmount - $totalPaid) > 0 ? 'text-red-600' : 'text-green-600'); ?> text-right">
                                            <strong><?php echo e(number_format($totalAmount - $totalPaid, 2)); ?></strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                        
                        <?php if($paymentSchedules->hasPages()): ?>
                            <div class="mt-6 no-print">
                                <?php echo e($paymentSchedules->links()); ?>

                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <i class="fas fa-calendar-times text-4xl text-gray-300 mb-4"></i>
                            <p class="text-gray-500">No payment schedule available</p>
                            <p class="text-sm text-gray-400 mt-2">Payment schedule will be generated upon loan disbursement</p>
                            <a href="<?php echo e(route('admin.loans.show', $loan->loanid)); ?>" 
                               class="mt-4 inline-flex items-center px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition no-print">
                                <i class="fas fa-arrow-left mr-2"></i>
                                Back to Loan Details
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            
            <?php if($paymentSchedules->count() > 0): ?>
                <?php
                    $totalCost = $totalInterest + $totalProcessingFee + $totalPenaltyPaid;
                    $effectiveInterestRate = $loan->amount > 0 ? ($totalCost / $loan->amount) * 100 : 0;
                    $remainingBalance = $totalAmount - $totalPaid;
                    $principalPaid = $loan->amount - $runningPrincipal;
                ?>
                
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mt-6">
                    
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">Payment Breakdown (Kwacha)</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Original Loan Amount:</span>
                                <span class="font-bold text-green-600"><?php echo e(number_format($loan->amount, 2)); ?></span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Principal Paid:</span>
                                <span class="font-bold text-green-600"><?php echo e(number_format($principalPaid, 2)); ?></span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Principal Outstanding:</span>
                                <span class="font-bold text-red-600"><?php echo e(number_format($runningPrincipal, 2)); ?></span>
                            </div>
                            <div class="pt-3 border-t border-gray-200">
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-600">Total Interest:</span>
                                    <span class="font-bold text-interest"><?php echo e(number_format($totalInterest, 2)); ?></span>
                                </div>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Total Processing Fees:</span>
                                <span class="font-bold text-processing"><?php echo e(number_format($totalProcessingFee, 2)); ?></span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Total Penalties:</span>
                                <span class="font-bold text-penalty"><?php echo e(number_format($totalPenaltyPaid, 2)); ?></span>
                            </div>
                            <div class="pt-3 border-t border-gray-200">
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-800 font-medium">Total Scheduled Repayment:</span>
                                    <span class="font-bold text-gray-900"><?php echo e(number_format($totalAmount, 2)); ?></span>
                                </div>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Total Amount Paid:</span>
                                <span class="font-bold text-green-600"><?php echo e(number_format($totalPaid, 2)); ?></span>
                            </div>
                            <div class="pt-3 border-t border-gray-200">
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-800 font-medium">Remaining Balance:</span>
                                    <span class="font-bold <?php echo e($remainingBalance > 0 ? 'text-red-600' : 'text-green-600'); ?>">
                                        <?php echo e(number_format($remainingBalance, 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">Cost Analysis</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Loan Amount:</span>
                                <span class="font-bold text-green-600"><?php echo e(number_format($loan->amount, 2)); ?></span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Total Cost (Interest + Fees + Penalties):</span>
                                <span class="font-bold text-red-600"><?php echo e(number_format($totalCost, 2)); ?></span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Processing Fee Impact:</span>
                                <span class="font-medium text-processing"><?php echo e(number_format(($totalProcessingFee / $loan->amount) * 100, 2)); ?>% of loan</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Penalty Impact:</span>
                                <span class="font-medium text-penalty"><?php echo e(number_format(($totalPenaltyPaid / $loan->amount) * 100, 2)); ?>% of loan</span>
                            </div>
                            <div class="pt-3 border-t border-gray-200">
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-800 font-medium">Principal Repayment Rate:</span>
                                    <span class="font-bold <?php echo e($principalPaid/$loan->amount*100 >= 50 ? 'text-green-600' : 'text-yellow-600'); ?>">
                                        <?php echo e(number_format(($principalPaid / $loan->amount) * 100, 2)); ?>%
                                    </span>
                                </div>
                            </div>
                            <div class="pt-3 border-t border-gray-200">
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-800 font-medium">Effective Interest Rate:</span>
                                    <span class="font-bold text-purple-600"><?php echo e(number_format($effectiveInterestRate, 2)); ?>%</span>
                                </div>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Stated Interest Rate:</span>
                                <span class="font-medium text-gray-700"><?php echo e(number_format($loan->interestrate, 2)); ?>%</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Cost-to-Loan Ratio:</span>
                                <span class="font-medium text-gray-700"><?php echo e(number_format(($totalCost / $loan->amount) * 100, 2)); ?>%</span>
                            </div>
                            <div class="pt-3 border-t border-gray-200">
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-800 font-medium">Completion Rate:</span>
                                    <span class="font-bold <?php echo e($paymentRatio >= 80 ? 'text-green-600' : ($paymentRatio >= 50 ? 'text-yellow-600' : 'text-red-600')); ?>">
                                        <?php echo e($paymentRatio); ?>%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            
            
            <?php if($paymentSchedules->count() > 0): ?>
                <div class="mt-6 bg-gray-50 rounded-lg p-4 border border-gray-200">
                    <h4 class="text-sm font-medium text-gray-700 mb-2">Status Legend:</h4>
                    <div class="flex flex-wrap gap-3">
                        <div class="flex items-center">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800 mr-2">
                                <i class="fas fa-check-circle mr-1"></i>
                                Paid
                            </span>
                            <span class="text-xs text-gray-600">Payment completed</span>
                        </div>
                        <div class="flex items-center">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 mr-2">
                                <i class="fas fa-clock mr-1"></i>
                                Scheduled
                            </span>
                            <span class="text-xs text-gray-600">Upcoming payment</span>
                        </div>
                        <div class="flex items-center">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800 mr-2">
                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                Overdue
                            </span>
                            <span class="text-xs text-gray-600">Payment past due date</span>
                        </div>
                        <div class="flex items-center">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800 mr-2">
                                <i class="fas fa-lock mr-1"></i>
                                Closed
                            </span>
                            <span class="text-xs text-gray-600">Loan closed</span>
                        </div>
                        <div class="flex items-center ml-4">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-800 mr-2">
                                <i class="fas fa-chart-line mr-1"></i>
                                Principal Flow
                            </span>
                            <span class="text-xs text-gray-600">Arrow (→) shows principal reduction after payment</span>
                        </div>
                    </div>
                    <div class="mt-2 text-xs text-gray-500">
                        <p><strong>Note:</strong> All monetary values are in Zambian Kwacha (K).</p>
                    </div>
                </div>
            <?php endif; ?>
        </main>
    </div>

    <script>
        // Optional: Add JavaScript functionality
        document.addEventListener('DOMContentLoaded', function() {
            // Add hover effects to table rows
            const tableRows = document.querySelectorAll('tbody tr');
            tableRows.forEach(row => {
                row.addEventListener('mouseenter', () => {
                    const originalClass = row.className;
                    if (!originalClass.includes('bg-green-50') && !originalClass.includes('bg-red-50') && !originalClass.includes('bg-gray-50')) {
                        row.style.backgroundColor = '#f9fafb';
                    }
                });
                row.addEventListener('mouseleave', () => {
                    const originalClass = row.className;
                    if (!originalClass.includes('bg-green-50') && !originalClass.includes('bg-red-50') && !originalClass.includes('bg-gray-50')) {
                        row.style.backgroundColor = '';
                    }
                });
            });
            
            // Print functionality (if needed)
            const printButton = document.getElementById('printButton');
            if (printButton) {
                printButton.addEventListener('click', function() {
                    window.print();
                });
            }
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/loans/repayment-schedule.blade.php ENDPATH**/ ?>