

<?php $__env->startSection('title', 'Admin Dashboard | IMMIA FINANCE LIMITED'); ?>
<?php $__env->startSection('page-title', 'Admin Dashboard'); ?>
<?php $__env->startSection('page-description', 'Welcome back, ' . auth()->user()->name); ?>

<?php $__env->startSection('styles'); ?>
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
    .card-hover {
        transition: all 0.3s ease;
    }
    
    .card-hover:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    }
    
    .notification-dot {
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0% { opacity: 1; }
        50% { opacity: 0.5; }
        100% { opacity: 1; }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Quick Stats -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <!-- Applications Card -->
    <?php if(auth()->user()->hasAnyPermission(['applications.view', 'applications.approve', 'poweruser'])): ?>
    <div class="bg-white rounded-xl p-6 shadow-sm border card-hover">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Total Applications</p>
                <p class="text-2xl font-bold text-blue-600"><?php echo e($stats['total_applications'] ?? 0); ?></p>
            </div>
            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                <i class="fas fa-file-alt text-blue-600 text-xl"></i>
            </div>
        </div>
        <div class="mt-4 grid grid-cols-2 gap-2 text-xs">
            <div class="text-center p-2 bg-blue-50 rounded">
                <p class="font-semibold text-blue-700"><?php echo e($stats['pending_applications'] ?? 0); ?></p>
                <p class="text-blue-600">Pending</p>
            </div>
            <div class="text-center p-2 bg-green-50 rounded">
                <p class="font-semibold text-green-700"><?php echo e($stats['approved_applications'] ?? 0); ?></p>
                <p class="text-green-600">Approved</p>
            </div>
        </div>
    </div>
    <?php endif; ?>
       
    <!-- Loans Card -->
    <?php if(auth()->user()->hasAnyPermission(['loans.view', 'poweruser'])): ?>
    <div class="bg-white rounded-xl p-6 shadow-sm border card-hover">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Active Loans</p>
                <p class="text-2xl font-bold text-green-600"><?php echo e($stats['active_loans'] ?? 0); ?></p>
            </div>
            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                <i class="fas fa-hand-holding-usd text-green-600 text-xl"></i>
            </div>
        </div>
        <div class="mt-4">
            <p class="text-green-600 text-sm font-medium">
                Portfolio: ZMW <?php echo e(number_format($stats['total_loan_amount'] ?? 0, 2)); ?>

            </p>
            <?php if(isset($stats['overdue_loans_count']) && $stats['overdue_loans_count'] > 0): ?>
            <p class="text-red-600 text-xs mt-1">
                <i class="fas fa-exclamation-triangle mr-1"></i>
                <?php echo e($stats['overdue_loans_count']); ?> overdue
            </p>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
    
    <!-- Collections Card -->
    <?php if(auth()->user()->hasAnyPermission(['collections.view', 'poweruser'])): ?>
    <div class="bg-white rounded-xl p-6 shadow-sm border card-hover">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Collections</p>
                <p class="text-2xl font-bold text-purple-600">ZMW <?php echo e(number_format($stats['total_collection_amount'] ?? 0, 2)); ?></p>
            </div>
            <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                <i class="fas fa-money-bill-wave text-purple-600 text-xl"></i>
            </div>
        </div>
        <div class="mt-4 grid grid-cols-2 gap-2 text-xs">
            <div class="text-center p-2 bg-purple-50 rounded">
                <p class="font-semibold text-purple-700"><?php echo e($stats['today_collections'] ?? 0); ?></p>
                <p class="text-purple-600">Today</p>
            </div>
            <div class="text-center p-2 bg-indigo-50 rounded">
                <p class="font-semibold text-indigo-700"><?php echo e($stats['month_collections'] ?? 0); ?></p>
                <p class="text-indigo-600">This Month</p>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <!-- Customers Card -->
    <?php if(auth()->user()->permissions->count() > 0): ?>
    <div class="bg-white rounded-xl p-6 shadow-sm border card-hover">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Total Customers</p>
                <p class="text-2xl font-bold text-orange-600"><?php echo e($stats['total_customers'] ?? 0); ?></p>
            </div>
            <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                <i class="fas fa-users text-orange-600 text-xl"></i>
            </div>
        </div>
        <div class="mt-4">
            <p class="text-orange-600 text-sm font-medium">
                <?php echo e($stats['active_customers'] ?? 0); ?> active customers
            </p>
            <p class="text-orange-500 text-xs mt-1">
                +<?php echo e($stats['new_customers_this_month'] ?? 0); ?> new this month
            </p>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Main Grid -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    <!-- Recent Applications -->
    <?php if(auth()->user()->hasAnyPermission(['applications.view', 'applications.approve', 'poweruser'])): ?>
    <div class="bg-white rounded-xl shadow-sm border">
        <div class="p-6 border-b border-gray-200">
            <h2 class="text-xl font-bold text-gray-900">Recent Applications</h2>
            <p class="text-gray-600">Applications requiring review</p>
        </div>
        <div class="p-6">
            <?php if($recentApplications->count() > 0): ?>
            <div class="space-y-4">
                <?php $__currentLoopData = $recentApplications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg">
                    <div class="flex items-center space-x-4">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-file-alt text-blue-600"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900"><?php echo e($application->customer->first_name ?? 'N/A'); ?> <?php echo e($application->customer->surname ?? ''); ?></h3>
                            <p class="text-gray-600 text-sm">App #<?php echo e($application->application_number); ?></p>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                <?php echo e(ucfirst($application->status)); ?>

                            </span>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="font-semibold text-gray-900">ZMW <?php echo e(number_format($application->loan_amount, 2)); ?></p>
                        <p class="text-gray-600 text-sm"><?php echo e($application->created_at->format('M d, Y')); ?></p>
                        <a href="<?php echo e(route('admin.applications.show', $application->id)); ?>" class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                            Review
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php else: ?>
            <div class="text-center py-8">
                <i class="fas fa-check-circle text-4xl text-gray-300 mb-4"></i>
                <p class="text-gray-500">No applications pending review</p>
            </div>
            <?php endif; ?>
            
            <div class="mt-6">
                <a href="<?php echo e(route('admin.applications.index')); ?>" class="block w-full bg-blue-600 hover:bg-blue-700 text-white text-center py-3 rounded-lg font-semibold transition-colors">
                    View All Applications
                </a>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Recent Loan Disbursements -->
    <?php if(auth()->user()->hasAnyPermission(['loans.view', 'poweruser'])): ?>
    <div class="bg-white rounded-xl shadow-sm border">
        <div class="p-6 border-b border-gray-200">
            <h2 class="text-xl font-bold text-gray-900">Recent Loan Disbursements</h2>
            <p class="text-gray-600">Recently disbursed loans</p>
        </div>
        <div class="p-6">
            <?php if($recentLoans->count() > 0): ?>
            <div class="space-y-4">
                <?php $__currentLoopData = $recentLoans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg">
                    <div class="flex items-center space-x-4">
                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-hand-holding-usd text-green-600"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-900"><?php echo e($loan->customer->first_name ?? 'N/A'); ?> <?php echo e($loan->customer->surname ?? ''); ?></h3>
                            <p class="text-gray-600 text-sm">Loan #<?php echo e($loan->loannumber ?? $loan->loanid); ?></p>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                <?php echo e(ucfirst($loan->status)); ?>

                            </span>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="font-semibold text-gray-900">ZMW <?php echo e(number_format($loan->amount, 2)); ?></p>
                        <p class="text-gray-600 text-sm">
                            <?php if($loan->disburseddate): ?>
                            <?php echo e(\Carbon\Carbon::parse($loan->disburseddate)->format('M d, Y')); ?>

                            <?php else: ?>
                            N/A
                            <?php endif; ?>
                        </p>
                        <a href="<?php echo e(route('admin.loans.show', $loan->loanid)); ?>" class="text-green-600 hover:text-green-700 text-sm font-medium">
                            View Details
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php else: ?>
            <div class="text-center py-8">
                <i class="fas fa-hand-holding-usd text-4xl text-gray-300 mb-4"></i>
                <p class="text-gray-500">No recent loan disbursements</p>
            </div>
            <?php endif; ?>
            
            <div class="mt-6">
                <a href="<?php echo e(route('admin.loans.active')); ?>" class="block w-full bg-green-600 hover:bg-green-700 text-white text-center py-3 rounded-lg font-semibold transition-colors">
                    View All Loans
                </a>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- System Health Section (Power Users Only) -->
<?php if(auth()->user()->hasPermission('poweruser')): ?>
<div class="mt-6 bg-white rounded-xl shadow-sm border">
    <div class="p-6 border-b border-gray-200">
        <h2 class="text-xl font-bold text-gray-900">System Health & Performance</h2>
        <p class="text-gray-600">Overall system performance metrics</p>
    </div>
    <div class="p-6">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center p-6 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl">
                <div class="w-20 h-20 mx-auto mb-4 relative">
                    <canvas id="systemHealthChart" width="100" height="100"></canvas>
                </div>
                <h3 class="font-semibold text-gray-900 text-lg">System Health</h3>
                <p class="text-2xl font-bold text-blue-600"><?php echo e(number_format($stats['system_health'] ?? 100, 1)); ?>%</p>
            </div>
            
            <div class="text-center p-6 bg-gradient-to-r from-green-50 to-emerald-50 rounded-xl">
                <div class="w-20 h-20 mx-auto mb-4 relative">
                    <canvas id="collectionRateChart" width="100" height="100"></canvas>
                </div>
                <h3 class="font-semibold text-gray-900 text-lg">Collection Rate</h3>
                <p class="text-2xl font-bold text-green-600"><?php echo e(number_format($stats['collection_rate'] ?? 0, 1)); ?>%</p>
            </div>
            
            <div class="text-center p-6 bg-gradient-to-r from-red-50 to-pink-50 rounded-xl">
                <div class="w-20 h-20 mx-auto mb-4 relative">
                    <canvas id="portfolioRiskChart" width="100" height="100"></canvas>
                </div>
                <h3 class="font-semibold text-gray-900 text-lg">Portfolio at Risk</h3>
                <p class="text-2xl font-bold text-red-600"><?php echo e(number_format($stats['portfolio_at_risk'] ?? 0, 1)); ?>%</p>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Application Progress Section -->
<?php if(auth()->user()->hasAnyPermission(['applications.view', 'applications.approve', 'poweruser']) && $applicationProgress->count() > 0): ?>
<div class="mt-6 bg-white rounded-xl shadow-sm border">
    <div class="p-6 border-b border-gray-200">
        <h2 class="text-xl font-bold text-gray-900">Application Progress</h2>
        <p class="text-gray-600">Track application journey</p>
    </div>
    <div class="p-6">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <?php $__currentLoopData = $applicationProgress; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appId => $progressData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $progressColor = match($progressData['status_color']) {
                    'blue' => '#3b82f6',
                    'yellow' => '#f59e0b',
                    'green' => '#10b981',
                    'red' => '#ef4444',
                    'purple' => '#8b5cf6',
                    default => '#6b7280'
                };
            ?>
            <div class="text-center">
                <div class="relative inline-block">
                    <canvas id="progressChart<?php echo e($appId); ?>" width="100" height="100" class="w-24 h-24"></canvas>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <span class="text-xl font-bold text-gray-900"><?php echo e($progressData['progress']); ?>%</span>
                    </div>
                </div>
                <h3 class="mt-4 font-semibold text-gray-900">
                    <?php echo e($progressData['application']->product->product ?? 'Loan Application'); ?>

                </h3>
                <p class="text-gray-600 text-sm">
                    ZMW <?php echo e(number_format($progressData['application']->loan_amount, 2)); ?>

                </p>
                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-<?php echo e($progressData['status_color']); ?>-100 text-<?php echo e($progressData['status_color']); ?>-800 mt-2">
                    <?php echo e($progressData['status_text']); ?>

                </span>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    // Create progress charts for applications
    function createProgressChart(canvasId, percentage, color) {
        const ctx = document.getElementById(canvasId).getContext('2d');
        return new Chart(ctx, {
            type: 'doughnut',
            data: {
                datasets: [{
                    data: [percentage, 100 - percentage],
                    backgroundColor: [color, '#e5e7eb'],
                    borderWidth: 0,
                    borderRadius: 10
                }]
            },
            options: {
                cutout: '70%',
                responsive: false,
                plugins: {
                    legend: { display: false },
                    tooltip: { enabled: false }
                }
            }
        });
    }

    // Create system health charts for power users
    <?php if(auth()->user()->hasPermission('poweruser')): ?>
    // System Health Chart
    const systemHealthCtx = document.getElementById('systemHealthChart').getContext('2d');
    new Chart(systemHealthCtx, {
        type: 'doughnut',
        data: {
            datasets: [{
                data: [<?php echo e($stats['system_health'] ?? 100); ?>, 100 - (<?php echo e($stats['system_health'] ?? 100); ?>)],
                backgroundColor: ['#3b82f6', '#e5e7eb'],
                borderWidth: 0
            }]
        },
        options: {
            cutout: '70%',
            responsive: false,
            plugins: { legend: { display: false }, tooltip: { enabled: false } }
        }
    });

    // Collection Rate Chart
    const collectionRateCtx = document.getElementById('collectionRateChart').getContext('2d');
    new Chart(collectionRateCtx, {
        type: 'doughnut',
        data: {
            datasets: [{
                data: [<?php echo e($stats['collection_rate'] ?? 0); ?>, 100 - (<?php echo e($stats['collection_rate'] ?? 0); ?>)],
                backgroundColor: ['#10b981', '#e5e7eb'],
                borderWidth: 0
            }]
        },
        options: {
            cutout: '70%',
            responsive: false,
            plugins: { legend: { display: false }, tooltip: { enabled: false } }
        }
    });

    // Portfolio Risk Chart
    const portfolioRiskCtx = document.getElementById('portfolioRiskChart').getContext('2d');
    new Chart(portfolioRiskCtx, {
        type: 'doughnut',
        data: {
            datasets: [{
                data: [<?php echo e($stats['portfolio_at_risk'] ?? 0); ?>, 100 - (<?php echo e($stats['portfolio_at_risk'] ?? 0); ?>)],
                backgroundColor: ['#ef4444', '#e5e7eb'],
                borderWidth: 0
            }]
        },
        options: {
            cutout: '70%',
            responsive: false,
            plugins: { legend: { display: false }, tooltip: { enabled: false } }
        }
    });
    <?php endif; ?>

    // Create progress charts for each application
    <?php if(auth()->user()->hasAnyPermission(['applications.view', 'applications.approve', 'poweruser'])): ?>
    <?php $__currentLoopData = $applicationProgress; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appId => $progressData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $progressColor = match($progressData['status_color']) {
            'blue' => '#3b82f6',
            'yellow' => '#f59e0b',
            'green' => '#10b981',
            'red' => '#ef4444',
            'purple' => '#8b5cf6',
            default => '#6b7280'
        };
    ?>
    createProgressChart('progressChart<?php echo e($appId); ?>', <?php echo e($progressData['progress']); ?>, '<?php echo e($progressColor); ?>');
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    // Simulate real-time updates
    setInterval(() => {
        // Update notification dot
        const dot = document.querySelector('.notification-dot');
        if (dot) {
            dot.style.animation = 'none';
            setTimeout(() => {
                dot.style.animation = 'pulse 2s infinite';
            }, 10);
        }
    }, 5000);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>