<style>
    /* * TCPDF works best with traditional CSS 2.1 properties.
     * We use cell padding and line-height to fix the "compacted" look.
     */
    .pdf-container {
        font-family: helvetica, sans-serif;
    }
    .title {
        font-size: 16pt;
        font-weight: bold;
        color: #1A237E;
        text-align: center;
        margin-bottom: 5px;
    }
    .subtitle {
        font-size: 10pt;
        text-align: center;
        color: #555;
        margin-bottom: 20px;
    }
    
    table {
        width: 100%;
        border-collapse: collapse;
        /* ADDED MARGIN TOP HERE */
        margin-top: 30px; 
    }
    
    /* Header Styling */
    th {
        background-color: #1A237E;
        color: #ffffff;
        font-weight: bold;
        text-align: center;
        border: 1px solid #1A237E;
        line-height: 2; 
    }
    
    /* Body Cell Styling */
    td {
        border: 1px solid #e5e7eb;
        text-align: center;
        color: #374151;
        line-height: 2.5; 
        font-size: 8pt;
    }
    
    /* Tenure column anchor */
    .tenure-col {
        background-color: #f9fafb;
        font-weight: bold;
        text-align: left;
        color: #1A237E;
        padding-left: 8px;
    }
    
    .currency-label {
        color: #9ca3af;
        font-size: 7pt;
    }

    .footer-note {
        margin-top: 15px;
        font-size: 7pt;
        color: #6b7280;
        font-style: italic;
    }
</style>

<div class="pdf-container">
    <div class="title">LOAN INSTALLMENT MATRIX</div>
    <div class="subtitle">
        Method: Reducing Balance &bull; Monthly Interest Rate: <strong><?php echo e($monthlyRatePercent); ?>%</strong>
    </div>

    <table border="0" cellpadding="0" cellspacing="0">
        <tr>
            <td height="30" style="border:none; line-height:30px;">&nbsp;</td>
        </tr>
    </table>

    <table cellpadding="5">
        <thead>
            <tr>
                <th width="8%">Tenure</th>
                <?php $__currentLoopData = $amounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th width="<?php echo e(92/count($amounts)); ?>%">
                        <?php echo e(number_format($amount)); ?>

                    </th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $tenures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $months): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="tenure-col" width="8%">
                        <?php echo e($months); ?> Mo
                    </td>
                    <?php $__currentLoopData = $amounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $i = $monthlyRate;
                            $n = $months;
                            $installment = ($amount * $i * pow(1 + $i, $n)) / (pow(1 + $i, $n) - 1);
                        ?>
                        <td width="<?php echo e(92/count($amounts)); ?>%">
                           <?php echo e(number_format($installment, 0)); ?>

                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer-note">
        * This matrix is an estimate. Actual values may vary based on disbursement dates and specific bank product fees.
        &copy; <?php echo e(date('Y')); ?> ZedBankOS - Africa's Levereum
    </div>
</div><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/quotations/schedule_pdf_table.blade.php ENDPATH**/ ?>