<?php
    // Define page variables
    $pageTitle = 'Loan Schedule';
    $pageSubtitle = 'Amortization schedule for Application ' . $application->application_number;

    // Define theme colors
    $themeBlue = '#0077C5';
    $themeBlueDark = '#005A94';

    // LOGIC: Check if processing fee is applicable
    $feeApplicable = ($application->processing_fee > 0);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: <?php echo e($themeBlue); ?>;
            --zedbank-blue-dark: <?php echo e($themeBlueDark); ?>;
        }
        .bg-primary { background-color: var(--zedbank-blue); }
        .text-primary { color: var(--zedbank-blue); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }

        /* Table Styles */
        .schedule-table { border-collapse: collapse; width: 100%; }
        .schedule-table th, .schedule-table td { padding: 12px 16px; text-align: left; font-size: 13px; }
        .schedule-table th { background-color: #F3F2F1; color: #323130; font-weight: 600; text-transform: uppercase; border-bottom: 1px solid #EDEBE9; }
        .schedule-table td { border-bottom: 1px solid #EDEBE9; }
        .schedule-table tbody tr:hover { background-color: #F9FAFB; }

        .summary-card { background-color: #FFFFFF; border: 1px solid #E1DFDD; border-radius: 8px; padding: 20px; }
        .term-badge { display: inline-block; padding: 4px 8px; border-radius: 4px; font-weight: 600; font-size: 11px; }

        /* Print Button Hide on Print */
        @media print {
            .print-hide {
                display: none !important;
            }
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        <?php echo $__env->make('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="max-w-7xl mx-auto">
                
                <div class="flex justify-between items-center mb-6 print-hide">
                    <a href="<?php echo e(route('admin.applications.index')); ?>" class="inline-flex items-center text-sm text-gray-600 hover:text-primary">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Applications
                    </a>
                    
                    
                    <button onclick="window.open('<?php echo e(route('admin.applications.schedule.pdf', $application->id)); ?>', '_blank')" 
                            class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-zedbank-blue-dark transition text-sm font-semibold flex items-center gap-2">
                        <i class="fas fa-file-pdf"></i> Download/View PDF
                    </button>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                    <div class="summary-card md:col-span-1">
                        <div class="text-xs font-medium text-gray-500 mb-2">Customer & Product</div>
                        <h4 class="text-xl font-bold text-gray-800"><?php echo e($application->customer->first_name); ?> <?php echo e($application->customer->surname); ?></h4>
                        <p class="text-sm text-gray-600"><?php echo e($application->product->product ?? 'N/A'); ?></p>
                    </div>
                    <div class="summary-card md:col-span-1">
                        <div class="text-xs font-medium text-gray-500 mb-2">Loan Amount & Term</div>
                        <h4 class="text-xl font-bold text-primary">ZMW <?php echo e(number_format($application->loan_amount, 2)); ?></h4>
                        <p class="text-sm text-gray-600"><?php echo e($application->loan_tenure); ?> <?php echo e($application->payment_frequency == 'one_off' ? 'Days' : 'Months'); ?></p>
                    </div>
                    <div class="summary-card md:col-span-1">
                        <div class="text-xs font-medium text-gray-500 mb-2">Calculation Method</div>
                        <div class="flex items-center space-x-2">
                            <span class="term-badge bg-blue-100 text-blue-800 capitalize">
                                <?php echo e(str_replace('_', ' ', $application->interest_method ?? 'reducing balance')); ?>

                            </span>
                            <span class="term-badge bg-gray-100 text-gray-800 capitalize">
                                <?php echo e(str_replace('_', ' ', $application->payment_frequency ?? 'monthly')); ?>

                            </span>
                        </div>
                        <p class="text-sm text-gray-600 mt-2">
                            Rate: <?php echo e(number_format($application->interest_rate, 2)); ?>% 
                            <?php if($feeApplicable): ?>
                            / Fee: <?php echo e(number_format($application->processing_fee, 2)); ?>% 
                            <span class="capitalize">(<?php echo e(str_replace('_', ' ', $application->processing_fee_basis ?? 'initial amount')); ?>)</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden" id="schedule-content">
                    <div class="p-4 bg-gray-50 border-b border-gray-200">
                        <h4 class="text-md font-semibold text-gray-800">Projected Payment Schedule</h4>
                        <p class="text-xs text-gray-500">Based on application terms and a projection date of <?php echo e(now()->format('M d, Y')); ?>.</p>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="schedule-table">
                            <thead>
                                <tr>
                                    <th class="w-[5%]">#</th>
                                    <th class="w-[15%]">Payment Date</th>
                                    <th class="w-[15%]">Details</th>
                                    <th class="w-[15%]">Principal Due</th>
                                    <th class="w-[15%]">Interest Due</th>
                                    <?php if($feeApplicable): ?>
                                    <th class="w-[10%]">Proc. Fee Due</th>
                                    <?php endif; ?>
                                    <th class="w-[15%]">Total Due</th>
                                    <th class="w-[15%]">Remaining Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $scheduleData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $isDisbursement = ($item['type'] == 'Disbursement');
                                        $description = $isDisbursement ? 'Loan Disbursed' : 'Repayment';
                                        $disbursedAmount = $application->loan_amount; 
                                    ?>
                                    
                                    <?php if($isDisbursement): ?>
                                        <tr class="bg-yellow-50 font-semibold">
                                            <td>—</td>
                                            <td><?php echo e($item['date']); ?></td>
                                            <td><?php echo e($description); ?></td>
                                            
                                            
                                            <td>ZMW 0.00</td> 
                                            
                                            
                                            <td>ZMW 0.00</td> 
                                            
                                            
                                            <?php if($feeApplicable): ?>
                                            <td>ZMW 0.00</td> 
                                            <?php endif; ?>

                                            
                                            <td class="font-bold text-primary">ZMW <?php echo e(number_format($disbursedAmount, 2)); ?></td>
                                            
                                            
                                            <td class="font-bold text-green-700">ZMW <?php echo e(number_format($disbursedAmount, 2)); ?></td>
                                        </tr>
                                    <?php else: ?>
                                        <tr>
                                            <td><?php echo e($index); ?></td>
                                            <td class="font-medium text-gray-700"><?php echo e($item['date']); ?></td>
                                            <td><?php echo e($description); ?></td>
                                            <td>ZMW <?php echo e(number_format($item['principal'], 2)); ?></td>
                                            <td>ZMW <?php echo e(number_format($item['interest'], 2)); ?></td>
                                            <?php if($feeApplicable): ?>
                                            <td>ZMW <?php echo e(number_format($item['fee'], 2)); ?></td>
                                            <?php endif; ?>
                                            <td class="font-bold text-primary">ZMW <?php echo e(number_format($item['total_due'], 2)); ?></td>
                                            <td class="font-semibold text-gray-700">ZMW <?php echo e(number_format($item['balance'], 2)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/applications/schedule.blade.php ENDPATH**/ ?>