<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employees | <?php echo e(config('app.name', 'IMMIA FINANCE')); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .quickbooks-input {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 6px 12px;
            font-size: 14px;
        }
        .quickbooks-input:focus {
            outline: 2px solid #146CAA;
            outline-offset: -1px;
            border-color: #146CAA;
        }
        .quickbooks-checkbox {
            width: 18px;
            height: 18px;
            border: 2px solid #605E5C;
            border-radius: 3px;
        }
        .quickbooks-checkbox:checked {
            background-color: #146CAA;
            border-color: #146CAA;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-edit {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        .action-btn-edit:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-delete {
            background-color: #FEE;
            color: #D83B01;
        }
        .action-btn-delete:hover {
            background-color: #D83B01;
            color: white;
        }
        .action-btn-view {
            background-color: #F3F2F1;
            color: #323130;
        }
        .action-btn-view:hover {
            background-color: #146CAA;
            color: white;
        }
        .modal-backdrop {
            background-color: rgba(0, 0, 0, 0.5);
        }
        .modal-content {
            max-height: 90vh;
            overflow-y: auto;
        }
        .modal-section {
            border-top: 1px solid #EDEBE9;
            padding-top: 24px;
            margin-top: 24px;
        }
        .modal-divider {
            border-top: 1px solid #EDEBE9;
            margin: 20px 0;
        }
    </style>
</head>
<body class="bg-gray50">
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64">
        <?php echo $__env->make('accounting.partials.header', ['title' => 'Employees', 'subtitle' => 'Manage employee records'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <!-- Success/Error Messages -->
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold"><?php echo e(session('success')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold"><?php echo e(session('error')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-lg border border-gray200 p-4">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-primaryLight rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-users text-primary text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray600">Total Employees</p>
                            <p class="text-xl font-semibold text-gray900"><?php echo e($employees->total() ?? 0); ?></p>
                        </div>
                    </div>
                </div>
                <div class="bg-white rounded-lg border border-gray200 p-4">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-check-circle text-success text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray600">Active</p>
                            <p class="text-xl font-semibold text-gray900"><?php echo e($employees->where('is_active', true)->count() ?? 0); ?></p>
                        </div>
                    </div>
                </div>
                <div class="bg-white rounded-lg border border-gray200 p-4">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-user-tie text-blue-600 text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray600">Permanent</p>
                            <p class="text-xl font-semibold text-gray900"><?php echo e($employees->where('employment_type', 'permanent')->count() ?? 0); ?></p>
                        </div>
                    </div>
                </div>
                <div class="bg-white rounded-lg border border-gray200 p-4">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-file-contract text-warning text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray600">Contract</p>
                            <p class="text-xl font-semibold text-gray900"><?php echo e($employees->where('employment_type', 'contract')->count() ?? 0); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Search and Action Bar -->
            <div class="bg-white rounded-lg border border-gray200 p-4 mb-6">
                <div class="flex flex-col md:flex-row md:items-center justify-between space-y-4 md:space-y-0">
                    <div class="flex items-center space-x-4">
                        <!-- New Employee Button -->
                        <a href="<?php echo e(route('admin.accounting.payroll.employees.create')); ?>" 
                           class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center">
                            <i class="fas fa-plus mr-2"></i>New Employee
                        </a>
                        
                        <!-- Import Button -->
                        <button onclick="openImportModal()" 
                                class="border border-gray300 text-gray700 px-4 py-2 rounded text-sm font-medium hover:bg-gray50 flex items-center">
                            <i class="fas fa-file-import mr-2"></i>Import
                        </button>
                        
                        <!-- Download Template -->
                        <a href="<?php echo e(route('admin.accounting.payroll.employees.template.download')); ?>" 
                           class="border border-gray300 text-gray700 px-4 py-2 rounded text-sm font-medium hover:bg-gray50 flex items-center">
                            <i class="fas fa-download mr-2"></i>Template
                        </a>
                        
                        <!-- Search -->
                        <div class="relative">
                            <input type="text" 
                                   name="search"
                                   id="searchInput"
                                   class="quickbooks-search w-64"
                                   placeholder="Search employees"
                                   value="<?php echo e(request('search')); ?>"
                                   onkeypress="handleSearchKeyPress(event)">
                        </div>
                    </div>
                    
                    <!-- Filter Buttons -->
                    <div class="flex items-center space-x-4">
                        <!-- Filters -->
                        <div class="flex items-center space-x-2">
                            <!-- Status Filter -->
                            <select id="statusFilter" class="quickbooks-dropdown">
                                <option value="">All Status</option>
                                <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                                <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                            </select>
                            
                            <!-- Employment Type Filter -->
                            <select id="typeFilter" class="quickbooks-dropdown">
                                <option value="">All Types</option>
                                <option value="permanent" <?php echo e(request('type') == 'permanent' ? 'selected' : ''); ?>>Permanent</option>
                                <option value="contract" <?php echo e(request('type') == 'contract' ? 'selected' : ''); ?>>Contract</option>
                                <option value="temporary" <?php echo e(request('type') == 'temporary' ? 'selected' : ''); ?>>Temporary</option>
                                <option value="casual" <?php echo e(request('type') == 'casual' ? 'selected' : ''); ?>>Casual</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Employees Table -->
            <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="quickbooks-table">
                        <thead>
                            <tr>
                                <th>Employee #</th>
                                <th>Name</th>
                                <th>Employment Type</th>
                                <th>Department</th>
                                <th>Basic Salary</th>
                                <th>Gross Salary</th>
                                <th>Payment Method</th>
                                <th>Status</th>
                                <th class="w-48">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-gray100 transition-colors">
                                    <td class="font-medium text-gray900">
                                        <span class="quickbooks-badge bg-blue-100 text-blue-800">
                                            <?php echo e($employee->employee_number); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="flex items-center">
                                            <div class="w-8 h-8 <?php echo e($employee->is_active ? 'bg-primaryLight' : 'bg-gray200'); ?> rounded-full flex items-center justify-center mr-3">
                                                <span class="<?php echo e($employee->is_active ? 'text-primary' : 'text-gray600'); ?> font-semibold text-sm">
                                                    <?php echo e(strtoupper(substr($employee->first_name, 0, 1))); ?>

                                                </span>
                                            </div>
                                            <div>
                                                <div class="font-medium text-gray900"><?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?></div>
                                                <div class="text-xs text-gray500"><?php echo e($employee->email); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php
                                            $typeColors = [
                                                'permanent' => 'bg-green-100 text-green-800',
                                                'contract' => 'bg-blue-100 text-blue-800',
                                                'temporary' => 'bg-yellow-100 text-yellow-800',
                                                'casual' => 'bg-purple-100 text-purple-800'
                                            ];
                                            $typeColor = $typeColors[$employee->employment_type] ?? 'bg-gray-100 text-gray-800';
                                        ?>
                                        <span class="quickbooks-badge <?php echo e($typeColor); ?>">
                                            <?php echo e(ucfirst($employee->employment_type)); ?>

                                        </span>
                                    </td>
                                    <td class="text-gray700">
                                        <?php echo e($employee->department ?? '—'); ?>

                                    </td>
                                    <td class="text-gray700 font-medium">
                                        <?php echo e($company->currency_symbol ?? 'K'); ?><?php echo e(number_format($employee->basic_salary, 2)); ?>

                                    </td>
                                    <td class="text-gray700 font-medium">
                                        <?php echo e($company->currency_symbol ?? 'K'); ?><?php echo e(number_format($employee->gross_salary, 2)); ?>

                                    </td>
                                    <td>
                                        <span class="quickbooks-badge bg-gray-100 text-gray-800">
                                            <?php echo e(ucfirst($employee->payment_method)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($employee->is_active): ?>
                                            <span class="quickbooks-badge bg-green-100 text-green-800">Active</span>
                                        <?php else: ?>
                                            <span class="quickbooks-badge bg-red-100 text-red-800">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="flex items-center">
                                            <a href="<?php echo e(route('admin.accounting.payroll.employees.show', $employee->id)); ?>" 
                                               class="action-btn action-btn-view"
                                               title="View details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.accounting.payroll.employees.edit', $employee->id)); ?>" 
                                               class="action-btn action-btn-edit"
                                               title="Edit employee">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button onclick="openDeleteModal(<?php echo e($employee->id); ?>)" 
                                                    class="action-btn action-btn-delete"
                                                    title="Delete employee">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-8">
                                        <div id="emptyState" class="py-16 text-center">
                                            <div class="w-16 h-16 bg-gray100 rounded-full flex items-center justify-center mx-auto mb-4">
                                                <i class="fas fa-user-tie text-gray500 text-2xl"></i>
                                            </div>
                                            <h3 class="text-lg font-medium text-gray900 mb-2">No employees found</h3>
                                            <p class="text-gray600 mb-6 max-w-md mx-auto">Get started by adding your first employee.</p>
                                            <div class="space-x-3">
                                                <a href="<?php echo e(route('admin.accounting.payroll.employees.create')); ?>" 
                                                   class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90">
                                                    <i class="fas fa-plus mr-2"></i>Add Employee
                                                </a>
                                                <button onclick="openImportModal()" 
                                                        class="border border-gray300 text-gray700 px-4 py-2 rounded text-sm font-medium hover:bg-gray50">
                                                    <i class="fas fa-file-import mr-2"></i>Import
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if($employees->hasPages()): ?>
                    <div class="border-t border-gray200 p-4 flex items-center justify-between">
                        <div class="text-sm text-gray600">
                            Showing <?php echo e($employees->firstItem()); ?> to <?php echo e($employees->lastItem()); ?> of <?php echo e($employees->total()); ?> employees
                        </div>
                        <div class="flex items-center space-x-1">
                            <?php echo e($employees->appends(request()->query())->links('vendor.pagination.tailwind')); ?>

                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>

    <!-- Import Modal -->
    <div id="importModal" class="fixed inset-0 bg-gray900 bg-opacity-50 hidden items-center justify-center z-50 p-4">
        <div class="bg-white rounded-lg shadow-lg max-w-md w-full">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-primaryLight rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-file-import text-primary"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray900">Import Employees</h3>
                        <p class="text-gray600 text-sm">Upload CSV file with employee data</p>
                    </div>
                </div>
                
                <form id="importForm" action="<?php echo e(route('admin.accounting.payroll.employees.import')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="space-y-4">
                        <div>
                            <label class="text-sm font-medium text-gray700 block mb-2">CSV File</label>
                            <div class="border-2 border-dashed border-gray300 rounded-lg p-6 text-center hover:border-primary transition-colors">
                                <input type="file" 
                                       id="csvFile"
                                       name="csv_file"
                                       accept=".csv"
                                       class="hidden"
                                       onchange="handleFileSelect(event)">
                                <div id="fileDropArea" class="cursor-pointer" onclick="document.getElementById('csvFile').click()">
                                    <i class="fas fa-cloud-upload-alt text-gray400 text-3xl mb-2"></i>
                                    <p class="text-sm text-gray600 mb-1">
                                        <span class="text-primary font-medium">Click to upload</span> or drag and drop
                                    </p>
                                    <p class="text-xs text-gray500">CSV files only (max 5MB)</p>
                                </div>
                                <div id="selectedFile" class="hidden mt-4">
                                    <div class="bg-gray100 rounded-lg p-3 flex items-center justify-between">
                                        <div class="flex items-center">
                                            <i class="fas fa-file-csv text-primary mr-2"></i>
                                            <span class="text-sm font-medium" id="fileName"></span>
                                        </div>
                                        <button type="button" onclick="removeFile()" class="text-gray500 hover:text-gray700">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <label class="flex items-center">
                                <input type="checkbox" checked class="quickbooks-checkbox mr-2" name="skip_header" value="1">
                                <span class="text-sm text-gray600">First row contains headers</span>
                            </label>
                        </div>
                        
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                            <div class="flex items-start">
                                <i class="fas fa-exclamation-triangle text-yellow-500 mr-2 mt-0.5"></i>
                                <div>
                                    <p class="text-sm text-yellow-800 font-medium">Important:</p>
                                    <p class="text-xs text-yellow-600 mt-1">
                                        Download the template file first to ensure proper formatting.
                                        Required fields: Employee Number, First Name, Last Name, Email, Basic Salary.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="border-t border-gray200 p-6 flex justify-end space-x-3">
                <button onclick="closeImportModal()" class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                    Cancel
                </button>
                <button onclick="submitImport()" class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90">
                    Import
                </button>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div id="deleteModal" class="fixed inset-0 bg-gray900 bg-opacity-50 hidden items-center justify-center z-50 p-4">
        <div class="bg-white rounded-lg shadow-lg max-w-md w-full">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-exclamation-triangle text-danger"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray900" id="deleteModalTitle">Delete Employee</h3>
                        <p class="text-gray600 text-sm" id="deleteModalMessage">Are you sure you want to delete this employee?</p>
                    </div>
                </div>
            </div>
            
            <div class="border-t border-gray200 p-6 flex justify-end space-x-3">
                <button onclick="closeDeleteModal()" class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                    Cancel
                </button>
                <form id="deleteForm" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                </form>
                <button onclick="confirmDelete()" class="bg-danger text-white px-4 py-2 rounded text-sm font-medium hover:bg-danger/90">
                    Delete
                </button>
            </div>
        </div>
    </div>

    <script>
        let currentDeleteId = null;

        // Search functionality
        function handleSearchKeyPress(event) {
            if (event.key === 'Enter') {
                applyFilters();
            }
        }

        function applyFilters() {
            const search = document.getElementById('searchInput').value;
            const status = document.getElementById('statusFilter').value;
            const type = document.getElementById('typeFilter').value;
            
            let url = '<?php echo e(route("admin.accounting.payroll.employees.index")); ?>?';
            const params = new URLSearchParams();
            
            if (search) params.append('search', search);
            if (status) params.append('status', status);
            if (type) params.append('type', type);
            
            window.location.href = url + params.toString();
        }

        // Setup filter events
        document.addEventListener('DOMContentLoaded', function() {
            const filters = ['statusFilter', 'typeFilter'];
            
            filters.forEach(filterId => {
                const filter = document.getElementById(filterId);
                if (filter) {
                    filter.addEventListener('change', applyFilters);
                }
            });
        });

        // Import Modal Functions
        function openImportModal() {
            document.getElementById('importModal').classList.remove('hidden');
        }

        function closeImportModal() {
            document.getElementById('importModal').classList.add('hidden');
            resetImportForm();
        }

        function resetImportForm() {
            document.getElementById('importForm').reset();
            document.getElementById('selectedFile').classList.add('hidden');
            document.getElementById('fileName').textContent = '';
        }

        function handleFileSelect(event) {
            const file = event.target.files[0];
            if (file) {
                if (file.type !== 'text/csv' && !file.name.endsWith('.csv')) {
                    showNotification('Please select a CSV file', 'error');
                    resetImportForm();
                    return;
                }
                
                if (file.size > 5 * 1024 * 1024) { // 5MB
                    showNotification('File size must be less than 5MB', 'error');
                    resetImportForm();
                    return;
                }
                
                document.getElementById('fileName').textContent = file.name;
                document.getElementById('selectedFile').classList.remove('hidden');
            }
        }

        function removeFile() {
            resetImportForm();
            document.getElementById('csvFile').value = '';
        }

        function submitImport() {
            const fileInput = document.getElementById('csvFile');
            if (!fileInput.files[0]) {
                showNotification('Please select a CSV file to import', 'error');
                return;
            }
            
            document.getElementById('importForm').submit();
        }

        // Delete Modal Functions
        function openDeleteModal(employeeId) {
            currentDeleteId = employeeId;
            
            const employeeRow = document.querySelector(`tr:has(button[onclick="openDeleteModal(${employeeId})"])`);
            const employeeName = employeeRow?.querySelector('td:nth-child(2) .font-medium')?.textContent || 'this employee';
            
            document.getElementById('deleteModalTitle').textContent = 'Delete Employee';
            document.getElementById('deleteModalMessage').textContent = 
                `Are you sure you want to delete "${employeeName}"? This action cannot be undone.`;
            
            document.getElementById('deleteModal').classList.remove('hidden');
        }

        function closeDeleteModal() {
            document.getElementById('deleteModal').classList.add('hidden');
            currentDeleteId = null;
        }

        function confirmDelete() {
            const form = document.getElementById('deleteForm');
            form.action = '<?php echo e(route("admin.accounting.payroll.employees.destroy", ":id")); ?>'.replace(':id', currentDeleteId);
            form.submit();
        }

        // Utility functions
        function showNotification(message, type = 'info') {
            const existing = document.querySelector('.quickbooks-notification');
            if (existing) existing.remove();

            const colors = {
                success: 'bg-success',
                error: 'bg-danger',
                info: 'bg-primary',
                warning: 'bg-warning'
            };

            const icons = {
                success: 'fa-check-circle',
                error: 'fa-exclamation-circle',
                info: 'fa-info-circle',
                warning: 'fa-exclamation-triangle'
            };

            const notification = document.createElement('div');
            notification.className = `quickbooks-notification fixed top-4 right-4 ${colors[type]} text-white px-4 py-3 rounded shadow-lg z-50 flex items-center animate-fade-in`;
            notification.innerHTML = `
                <i class="fas ${icons[type]} mr-2"></i>
                <span>${message}</span>
            `;

            document.body.appendChild(notification);

            setTimeout(() => {
                notification.classList.add('animate-fade-out');
                setTimeout(() => {
                    notification.remove();
                }, 300);
            }, 3000);
        }

        // Add animation styles
        const style = document.createElement('style');
        style.textContent = `
            @keyframes fadeIn {
                from { opacity: 0; transform: translateY(-10px); }
                to { opacity: 1; transform: translateY(0); }
            }
            @keyframes fadeOut {
                from { opacity: 1; transform: translateY(0); }
                to { opacity: 0; transform: translateY(-10px); }
            }
            .animate-fade-in {
                animation: fadeIn 0.3s ease-out;
            }
            .animate-fade-out {
                animation: fadeOut 0.3s ease-in;
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/accounting/payroll/employees/index.blade.php ENDPATH**/ ?>