<div id="chatModal" class="fixed inset-0 z-[60] hidden bg-black bg-opacity-50 flex items-center justify-center p-4">
    <div class="bg-white w-full max-w-md rounded-2xl shadow-2xl flex flex-col h-[600px] overflow-hidden">
        <div class="bg-zedbank-blue p-4 flex items-center justify-between text-white shadow-md">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center border border-white/30">
                    <i class="fas fa-user"></i>
                </div>
                <div>
                    <h3 id="chatCustomerName" class="font-bold tracking-tight">Name</h3>
                    <p class="text-[10px] text-blue-100 flex items-center gap-1">
                        <span class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></span>Active Session
                    </p>
                </div>
            </div>
            <button onclick="closeChatModal()" class="text-white/80 hover:text-white transition-transform hover:scale-110">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>

        <div class="bg-gray-50 p-3 border-b border-gray-200">
            <label class="text-[10px] uppercase font-bold text-gray-400 mb-2 block tracking-widest">Select Category</label>
            <div class="flex flex-wrap gap-2">
                <?php $__currentLoopData = ['Follow Up', 'Payment Reminder', 'Document Requests', 'Promotions', 'Others']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button onclick="setCategory(this, '<?php echo e($cat); ?>')" 
                        class="category-btn px-3 py-1.5 text-xs rounded-lg border border-gray-300 bg-white hover:border-zedbank-blue hover:text-zedbank-blue transition-all duration-200 font-medium">
                        <?php echo e($cat); ?>

                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <div id="chatBody" class="flex-1 bg-slate-50 p-4 overflow-y-auto space-y-4"></div>

        <form id="chatForm" onsubmit="sendMessage(event)" class="bg-white p-4 border-t border-gray-100 flex items-center gap-3">
            <?php echo csrf_field(); ?>
            <input type="hidden" id="chatCustomerId">
            <input type="hidden" id="chatCategory" value="Others">
            <div class="flex-1">
                <input type="text" id="messageInput" placeholder="Type your message..." 
                    class="w-full border-gray-200 rounded-xl py-2.5 px-4 focus:ring-zedbank-blue focus:border-zedbank-blue text-sm bg-gray-50" required>
            </div>
            <button type="submit" id="chatSubmitBtn" class="bg-zedbank-blue text-white w-11 h-11 rounded-xl flex items-center justify-center hover:bg-zedbank-blue-dark transition-all shadow-lg">
                <i class="fas fa-paper-plane"></i>
            </button>
        </form>
    </div>
</div>

<script>
    let selectedCategory = 'Others';

    async function openChatModal(id, name) {
        document.getElementById('chatCustomerId').value = id;
        document.getElementById('chatCustomerName').innerText = name;
        document.getElementById('chatModal').classList.remove('hidden');
        
        const chatBody = document.getElementById('chatBody');
        chatBody.innerHTML = '<div class="text-center py-10 text-gray-400"><i class="fas fa-spinner fa-spin"></i> Loading history...</div>';

        try {
            const response = await fetch("<?php echo e(url('admin/customers')); ?>/" + id + "/message-history");
            const messages = await response.json();
            chatBody.innerHTML = ''; 

            if (messages.length === 0) {
                chatBody.innerHTML = '<div class="text-center py-10 text-gray-400 text-xs">No previous messages.</div>';
            } else {
                messages.forEach(msg => {
                    const statusIcon = msg.status === 'sent' ? '✓' : '⚠';
                    chatBody.innerHTML += `
                        <div class="flex flex-col items-end mb-4">
                            <div class="bg-zedbank-blue text-white p-3 rounded-2xl rounded-tr-none shadow-sm max-w-[85%] text-sm">
                                <span class="text-[9px] font-bold block mb-1 uppercase opacity-70">${msg.category}</span>
                                ${msg.message}
                                <div class="flex justify-between items-center mt-1 gap-4">
                                    <span class="text-[9px] opacity-70">${statusIcon} ${msg.status.toUpperCase()}</span>
                                    <span class="text-[9px] opacity-70">${msg.time}</span>
                                </div>
                            </div>
                        </div>`;
                });
                chatBody.scrollTop = chatBody.scrollHeight;
            }
        } catch (error) {
            chatBody.innerHTML = '<div class="text-center py-10 text-red-400 text-xs">Failed to load history.</div>';
        }
        document.getElementById('messageInput').focus();
    }

    function closeChatModal() { document.getElementById('chatModal').classList.add('hidden'); }

    function setCategory(btn, cat) {
        document.querySelectorAll('.category-btn').forEach(b => b.classList.remove('active', 'bg-zedbank-blue', 'text-white'));
        btn.classList.add('active', 'bg-zedbank-blue', 'text-white');
        selectedCategory = cat; 
        document.getElementById('chatCategory').value = cat;
    }

    async function sendMessage(e) {
        e.preventDefault();
        const messageInput = document.getElementById('messageInput');
        const submitBtn = document.getElementById('chatSubmitBtn');
        const msg = messageInput.value;
        const customerId = document.getElementById('chatCustomerId').value;
        const category = document.getElementById('chatCategory').value;

        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

        try {
            const response = await fetch("<?php echo e(route('admin.customers.send-message')); ?>", {
                method: 'POST',
                headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                body: JSON.stringify({ customer_id: customerId, category: category, message: msg })
            });

            const result = await response.json();
            if (result.success) {
                const chatBody = document.getElementById('chatBody');
                chatBody.innerHTML += `
                    <div class="flex flex-col items-end mb-4">
                        <div class="bg-zedbank-blue text-white p-3 rounded-2xl rounded-tr-none shadow-sm max-w-[85%] text-sm">
                            <span class="text-[9px] font-bold block mb-1 uppercase opacity-70">${category}</span>
                            ${msg}
                            <span class="text-[9px] text-blue-100 block text-right mt-1 opacity-70">Just now</span>
                        </div>
                    </div>`;
                messageInput.value = '';
                chatBody.scrollTop = chatBody.scrollHeight;
                
                // If on show.blade, refresh the tab content
                if(typeof switchCommTab === 'function') {
                    // This is a simple way to update the background tabs if the user sends from the profile
                    location.reload(); 
                }
            } else {
                alert('Error: ' + result.message);
            }
        } catch (error) {
            alert('Network error.');
        } finally {
            submitBtn.disabled = false;
            submitBtn.innerHTML = '<i class="fas fa-paper-plane"></i>';
        }
    }
</script><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/customers/partials/chat_modal.blade.php ENDPATH**/ ?>