<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Requirement | <?php echo e(config('app.name', 'IMMIA FINANCE')); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        .form-section {
            margin-bottom: 24px;
        }
        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            color: #323130;
            margin-bottom: 8px;
        }
        .form-helper {
            font-size: 12px;
            color: #605E5C;
            margin-top: 4px;
        }
        .error-message {
            color: #D83B01;
            font-size: 12px;
            margin-top: 4px;
        }
        .example-card {
            background: #F3F2F1;
            border-radius: 6px;
            padding: 12px;
            margin-bottom: 8px;
            cursor: pointer;
            transition: background-color 0.2s;
        }
        .example-card:hover {
            background: #E1DFDD;
        }
    </style>
</head>
<body class="bg-gray50">
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64">
        <?php echo $__env->make('accounting.partials.header', ['title' => 'Add Application Requirement', 'subtitle' => 'Add a new document requirement for loan applications'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="max-w-3xl mx-auto">
                <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray200">
                        <h2 class="text-lg font-semibold text-gray900">Requirement Information</h2>
                        <p class="text-gray600 text-sm mt-1">Add a new document requirement for loan applications</p>
                    </div>
                    <div class="p-6">
                        <form id="requirementForm" method="POST" action="<?php echo e(route('admin.accounting.application-requirements.store')); ?>">
                            <?php echo csrf_field(); ?>
                            
                            <!-- Document Name -->
                            <div class="form-section">
                                <label for="documentname" class="form-label">
                                    Document Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" 
                                       name="documentname" 
                                       id="documentname"
                                       class="quickbooks-input"
                                       value="<?php echo e(old('documentname')); ?>"
                                       required
                                       placeholder="e.g., National ID Card">
                                <?php $__errorArgs = ['documentname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="error-message"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <p class="form-helper">Enter the name of the document required for loan applications</p>
                            </div>

                            <!-- Common Examples -->
                            <div class="form-section">
                                <h3 class="text-md font-semibold text-gray900 mb-4">Common Requirements</h3>
                                <p class="text-sm text-gray600 mb-3">Click any example to use it:</p>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                                    <div class="example-card" onclick="useExample('National ID Card')">
                                        <div class="flex items-center">
                                            <i class="fas fa-id-card text-blue-600 mr-3"></i>
                                            <div>
                                                <div class="font-medium text-gray900">National ID Card</div>
                                                <div class="text-xs text-gray500">Identification</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="example-card" onclick="useExample('Passport')">
                                        <div class="flex items-center">
                                            <i class="fas fa-passport text-blue-600 mr-3"></i>
                                            <div>
                                                <div class="font-medium text-gray900">Passport</div>
                                                <div class="text-xs text-gray500">Identification</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="example-card" onclick="useExample('Driver\'s License')">
                                        <div class="flex items-center">
                                            <i class="fas fa-id-card text-blue-600 mr-3"></i>
                                            <div>
                                                <div class="font-medium text-gray900">Driver's License</div>
                                                <div class="text-xs text-gray500">Identification</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="example-card" onclick="useExample('Recent Payslip')">
                                        <div class="flex items-center">
                                            <i class="fas fa-file-invoice-dollar text-green-600 mr-3"></i>
                                            <div>
                                                <div class="font-medium text-gray900">Recent Payslip</div>
                                                <div class="text-xs text-gray500">Proof of Income</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="example-card" onclick="useExample('Bank Statement (3 months)')">
                                        <div class="flex items-center">
                                            <i class="fas fa-university text-purple-600 mr-3"></i>
                                            <div>
                                                <div class="font-medium text-gray900">Bank Statement (3 months)</div>
                                                <div class="text-xs text-gray500">Financial Proof</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="example-card" onclick="useExample('Utility Bill')">
                                        <div class="flex items-center">
                                            <i class="fas fa-home text-yellow-600 mr-3"></i>
                                            <div>
                                                <div class="font-medium text-gray900">Utility Bill</div>
                                                <div class="text-xs text-gray500">Proof of Address</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="example-card" onclick="useExample('Employment Letter')">
                                        <div class="flex items-center">
                                            <i class="fas fa-briefcase text-indigo-600 mr-3"></i>
                                            <div>
                                                <div class="font-medium text-gray900">Employment Letter</div>
                                                <div class="text-xs text-gray500">Employment Verification</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="example-card" onclick="useExample('Tax Clearance Certificate')">
                                        <div class="flex items-center">
                                            <i class="fas fa-file-contract text-red-600 mr-3"></i>
                                            <div>
                                                <div class="font-medium text-gray900">Tax Clearance Certificate</div>
                                                <div class="text-xs text-gray500">Tax Compliance</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Form Actions -->
                            <div class="flex justify-end gap-3 pt-6 border-t border-gray200">
                                <a href="<?php echo e(route('admin.accounting.application-requirements.index')); ?>" 
                                   class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                                    Cancel
                                </a>
                                <button type="submit" 
                                        id="submitBtn"
                                        class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                                    <i class="fas fa-save"></i>
                                    Add Requirement
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- Information -->
                <div class="bg-white rounded-lg border border-gray200 mt-6">
                    <div class="p-6">
                        <h3 class="text-md font-semibold text-gray900 mb-4">Best Practices</h3>
                        <div class="space-y-4">
                            <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                                <div class="flex items-center mb-2">
                                    <i class="fas fa-lightbulb text-blue-600 mr-2"></i>
                                    <h4 class="text-sm font-semibold text-blue-900">Clear Documentation</h4>
                                </div>
                                <ul class="text-sm text-blue-700 space-y-1">
                                    <li>• Use specific, descriptive names (e.g., "Passport - Bio Data Page" instead of just "Passport")</li>
                                    <li>• Indicate validity period if applicable (e.g., "Bank Statement - Last 3 Months")</li>
                                    <li>• Specify format requirements (e.g., "Color Copy", "Certified Copy")</li>
                                </ul>
                            </div>
                            
                            <div class="bg-green-50 p-4 rounded-lg border border-green-200">
                                <div class="flex items-center mb-2">
                                    <i class="fas fa-check-circle text-green-600 mr-2"></i>
                                    <h4 class="text-sm font-semibold text-green-900">Compliance Guidelines</h4>
                                </div>
                                <ul class="text-sm text-green-700 space-y-1">
                                    <li>• Ensure requirements comply with regulatory standards</li>
                                    <li>• Consider customer convenience when requesting documents</li>
                                    <li>• Balance thoroughness with practicality</li>
                                    <li>• Review requirements regularly for updates</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Use example text
            window.useExample = function(text) {
                document.getElementById('documentname').value = text;
                document.getElementById('documentname').focus();
            };
            
            // Validate form submission
            const form = document.getElementById('requirementForm');
            const submitBtn = document.getElementById('submitBtn');
            
            form.addEventListener('submit', function(e) {
                const documentname = document.getElementById('documentname').value;
                
                if (!documentname) {
                    e.preventDefault();
                    alert('Please enter a document name.');
                    return false;
                }
                
                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Adding...';
                }
            });
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/accounting/applicationrequirements/create.blade.php ENDPATH**/ ?>