<?php
    // Define page variables
    $pageTitle = 'Approved Loan Applications';
    $pageSubtitle = 'Applications approved and ready for disbursement';

    // Calculate dynamic stats for the header/stat cards
    $totalApproved = $applications->total();
    $totalAmount = $applications->sum('loan_amount');
    $avgAmount = $applications->avg('loan_amount') ?? 0;

    // Dummy stats array for header/sidebar if needed by the partials
    $stats = [
        'pending_applications' => 0, // Placeholder as this is the approved view
    ];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | IMMIA FINANCE</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS (Adapted for Loan Applications) --- */
        :root {
            --zedbank-blue: #0077C5; /* ThemeBlue */
            --zedbank-blue-dark: #005A94; /* Darker shade for hover/active background */
        }

        /* Custom Tailwind-like classes */
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }

        /* Sidebar/Main Content Layout */
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }

        /* Local Overrides */
        .focus\:ring-primary:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-primary:focus { border-color: var(--zedbank-blue); }
        .bg-primary { background-color: var(--zedbank-blue); } /* Map old primary to new blue */
        .text-blue-600 { color: var(--zedbank-blue); }
        .bg-blue-600 { background-color: var(--zedbank-blue); }
        .hover\:bg-blue-700:hover { background-color: var(--zedbank-blue-dark); }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="max-w-7xl mx-auto">

                <?php if(session('success')): ?>
                    <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-lg">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle mr-2"></i>
                            <?php echo e(session('success')); ?>

                        </div>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="mb-6 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle mr-2"></i>
                            <?php echo e(session('error')); ?>

                        </div>
                    </div>
                <?php endif; ?>

                <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Total Approved</p>
                                <p class="text-2xl font-bold text-zedbank-blue"><?php echo e($totalApproved); ?></p>
                            </div>
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-check-circle text-zedbank-blue"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Ready for Disbursement</p>
                                <p class="text-2xl font-bold text-green-600"><?php echo e($totalApproved); ?></p>
                            </div>
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-money-bill-wave text-green-600"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Total Loan Amount</p>
                                <p class="text-lg font-bold text-purple-600">
                                    
                                    ZMW <?php echo e(number_format($totalAmount, 2)); ?>

                                </p>
                            </div>
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-hand-holding-usd text-purple-600"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Avg. Loan Amount</p>
                                <p class="text-lg font-bold text-orange-600">
                                    ZMW <?php echo e(number_format($avgAmount, 2)); ?>

                                </p>
                            </div>
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-chart-line text-orange-600"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 mb-6">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                        <div class="w-full md:w-auto">
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-search text-gray-400"></i>
                                </div>
                                <input 
                                    type="text" 
                                    id="searchInput" 
                                    class="block w-full md:w-80 pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary" 
                                    placeholder="Search by application no, customer, product..."
                                >
                            </div>
                        </div>
                        <div class="flex flex-wrap gap-2 w-full md:w-auto">
                            <button id="filterButton" class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <i class="fas fa-filter"></i>
                                <span>Filter</span>
                            </button>
                            <button id="exportButton" class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <i class="fas fa-download"></i>
                                <span>Export</span>
                            </button>
                            <button id="bulkDisburseButton" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition flex items-center gap-2 hidden">
                                <i class="fas fa-money-bill-wave"></i>
                                <span>Bulk Disburse</span>
                            </button>
                        </div>
                    </div>
                </div>

                <div id="filterOptions" class="mt-4 p-4 bg-gray-50 rounded-lg hidden">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Loan Amount Range</label>
                            <div class="flex space-x-2">
                                <input type="number" placeholder="Min" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                                <input type="number" placeholder="Max" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Product Type</label>
                            <select class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                                <option value="">All Products</option>
                                <option value="personal">Personal Loan</option>
                                <option value="business">Business Loan</option>
                                <option value="emergency">Emergency Loan</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Approval Date</label>
                            <input type="date" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        </div>
                    </div>
                    <div class="mt-4 flex justify-end space-x-2">
                        <button class="px-4 py-2 text-gray-600 hover:text-gray-800">Clear</button>
                        <button class="px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark">Apply Filters</button>
                    </div>
                </div>

                <div class="overflow-x-auto bg-white shadow-sm rounded-lg border border-gray-200">
                    <table class="min-w-full text-sm" id="applicationsTable">
                        <thead class="bg-gray-50 border-b border-gray-200">
                            <tr>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">
                                    <input type="checkbox" id="selectAll" class="rounded border-gray-300">
                                </th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Application No</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Customer</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Product</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Approved Date</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Currency</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Amount</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Interest Rate</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Term</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Status</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-b hover:bg-gray-50 transition application-row" data-application-id="<?php echo e($application->id); ?>">
                                    <td class="px-4 py-3">
                                        <input type="checkbox" class="application-checkbox rounded border-gray-300" value="<?php echo e($application->id); ?>">
                                    </td>
                                    <td class="px-4 py-3 text-gray-700 font-medium">
                                        <div class="flex items-center space-x-2">
                                            <span class="font-mono"><?php echo e($application->application_number); ?></span>
                                            <?php if($application->disbursed_at): ?>
                                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                                    <i class="fas fa-check mr-1"></i>
                                                    Disbursed
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <div>
                                            <p class="font-semibold"><?php echo e($application->customer->first_name); ?> <?php echo e($application->customer->surname); ?></p>
                                            <p class="text-xs text-gray-500"><?php echo e($application->customer->phone ?? 'No phone'); ?></p>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <?php if($application->product): ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-zedbank-blue">
                                                <?php echo e($application->product->product); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-gray-500">—</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <?php if($application->approved_at): ?>
                                            <div>
                                                <p><?php echo e($application->approved_at->format('M d, Y')); ?></p>
                                                <p class="text-xs text-gray-500"><?php echo e($application->approved_at->diffForHumans()); ?></p>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-gray-500">—</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-gray-700 font-medium">
                                        <?php echo e($application->currency->code ?? 'ZMW'); ?>

                                    </td>
                                    <td class="px-4 py-3 text-gray-800 font-bold">
                                        <?php echo e($application->currency->symbol ?? 'ZMW'); ?> <?php echo e(number_format($application->loan_amount, 2)); ?>

                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <?php echo e(number_format($application->interest_rate, 2)); ?>%
                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <div class="flex items-center space-x-2">
                                            <span><?php echo e($application->loan_tenure); ?> months</span>
                                            <span class="text-xs text-gray-500 capitalize">(<?php echo e($application->payment_frequency); ?>)</span>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3">
                                        <?php if($application->disbursed_at): ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                                <i class="fas fa-check mr-1"></i>
                                                Disbursed
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                <i class="fas fa-check-circle mr-1"></i>
                                                Approved
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3">
                                        <div class="flex space-x-2">
                                            <a href="<?php echo e(route('admin.applications.show', $application->id)); ?>" 
                                               class="text-zedbank-blue hover:text-zedbank-blue-dark p-1 rounded transition" 
                                               title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <?php if(!$application->disbursed_at && auth()->user()->hasPermission('applications.approve')): ?>
                                            <a href="<?php echo e(route('admin.applications.disburse', $application->id)); ?>" 
                                               class="text-purple-600 hover:text-purple-800 p-1 rounded transition" 
                                               title="Disburse Loan">
                                                <i class="fas fa-money-bill-wave"></i>
                                            </a>
                                            <?php endif; ?>
                                            
                                            <?php if($application->disbursed_at): ?>
                                            <span class="text-green-600 p-1" title="Already Disbursed">
                                                <i class="fas fa-check-double"></i>
                                            </span>
                                            <?php endif; ?>
                                            
                                            <a href="<?php echo e(route('admin.applications.edit', $application->id)); ?>" 
                                               class="text-green-600 hover:text-green-800 p-1 rounded transition" 
                                               title="Edit Application">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            
                                            <?php if(auth()->user()->hasPermission('applications.approve') && !$application->disbursed_at): ?>
                                            <form method="POST" action="<?php echo e(route('admin.applications.reject', $application->id)); ?>" class="inline" onsubmit="return confirm('Are you sure you want to reject this approved application?')">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" 
                                                        class="text-red-600 hover:text-red-800 p-1 rounded transition" 
                                                        title="Reject Application">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="11" class="px-4 py-8 text-center text-gray-500">
                                        <div class="flex flex-col items-center justify-center">
                                            <i class="fas fa-check-circle text-4xl text-gray-300 mb-4"></i>
                                            <p class="text-lg font-semibold">No approved applications found</p>
                                            <p class="text-sm">Approved applications will appear here ready for disbursement</p>
                                            <a href="<?php echo e(route('admin.applications.index')); ?>" class="mt-4 px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition">
                                                View All Applications
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div id="bulkActionsBar" class="fixed bottom-4 left-1/2 transform -translate-x-1/2 bg-white shadow-lg rounded-lg p-4 border border-gray-200 hidden z-40">
                    <div class="flex items-center space-x-4">
                        <span class="text-sm font-medium text-gray-700">
                            <span id="selectedCount">0</span> applications selected
                        </span>
                        <button id="bulkDisburseAction" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition flex items-center gap-2">
                            <i class="fas fa-money-bill-wave"></i>
                            Disburse Selected
                        </button>
                        <button id="clearSelection" class="px-4 py-2 text-gray-600 hover:text-gray-800 transition">
                            Clear
                        </button>
                    </div>
                </div>

                <div class="mt-6 flex flex-col md:flex-row justify-between items-center gap-4">
                    <div class="text-sm text-gray-600">
                        Showing <span class="font-medium"><?php echo e($applications->firstItem() ?? 0); ?></span> to 
                        <span class="font-medium"><?php echo e($applications->lastItem() ?? 0); ?></span> of 
                        <span class="font-medium"><?php echo e($applications->total()); ?></span> entries
                    </div>
                    <div class="flex space-x-2">
                        <?php if($applications->onFirstPage()): ?>
                            <button class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg text-gray-400 cursor-not-allowed flex items-center gap-2" disabled>
                                <i class="fas fa-chevron-left"></i>
                                <span>Previous</span>
                            </button>
                        <?php else: ?>
                            <a href="<?php echo e($applications->previousPageUrl()); ?>" class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <i class="fas fa-chevron-left"></i>
                                <span>Previous</span>
                            </a>
                        <?php endif; ?>

                        <?php $__currentLoopData = $applications->getUrlRange(1, $applications->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($page == $applications->currentPage()): ?>
                                <span class="px-4 py-2 text-sm bg-zedbank-blue text-white rounded-lg"><?php echo e($page); ?></span>
                            <?php else: ?>
                                <a href="<?php echo e($url); ?>" class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition"><?php echo e($page); ?></a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($applications->hasMorePages()): ?>
                            <a href="<?php echo e($applications->nextPageUrl()); ?>" class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <span>Next</span>
                                <i class="fas fa-chevron-right"></i>
                            </a>
                        <?php else: ?>
                            <button class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg text-gray-400 cursor-not-allowed flex items-center gap-2" disabled>
                                <span>Next</span>
                                <i class="fas fa-chevron-right"></i>
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Search functionality
            const searchInput = document.getElementById('searchInput');
            const applicationsTable = document.getElementById('applicationsTable');
            const applicationRows = applicationsTable.querySelectorAll('.application-row');

            searchInput?.addEventListener('input', function() {
                const searchTerm = this.value.toLowerCase();
                let visibleCount = 0;
                
                applicationRows.forEach(row => {
                    const rowText = row.textContent.toLowerCase();
                    if (rowText.includes(searchTerm)) {
                        row.style.display = '';
                        visibleCount++;
                    } else {
                        row.style.display = 'none';
                    }
                });
            });

            // Filter toggle
            const filterButton = document.getElementById('filterButton');
            const filterOptions = document.getElementById('filterOptions');

            filterButton?.addEventListener('click', function() {
                filterOptions.classList.toggle('hidden');
            });

            // Export functionality
            const exportButton = document.getElementById('exportButton');
            exportButton?.addEventListener('click', function() {
                // Simple export implementation - in real app, this would call an API
                alert('Export functionality would be implemented here. This would generate a CSV/Excel file of approved applications.');
            });

            // Bulk selection functionality
            const selectAll = document.getElementById('selectAll');
            const applicationCheckboxes = document.querySelectorAll('.application-checkbox');
            const bulkActionsBar = document.getElementById('bulkActionsBar');
            const bulkDisburseButton = document.getElementById('bulkDisburseButton');
            const selectedCount = document.getElementById('selectedCount');
            const bulkDisburseAction = document.getElementById('bulkDisburseAction');
            const clearSelection = document.getElementById('clearSelection');

            // Select all functionality
            selectAll?.addEventListener('change', function() {
                const isChecked = this.checked;
                applicationCheckboxes.forEach(checkbox => {
                    if (!checkbox.closest('tr').style.display || checkbox.closest('tr').style.display === '') {
                        checkbox.checked = isChecked;
                    }
                });
                updateBulkActions();
            });

            // Individual checkbox functionality
            applicationCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', updateBulkActions);
            });

            // Update bulk actions based on selection
            function updateBulkActions() {
                const selectedCheckboxes = Array.from(applicationCheckboxes).filter(cb => cb.checked);
                const selectedCountValue = selectedCheckboxes.length;
                
                selectedCount.textContent = selectedCountValue;
                
                if (selectedCountValue > 0) {
                    bulkActionsBar.classList.remove('hidden');
                    bulkDisburseButton.classList.remove('hidden');
                } else {
                    bulkActionsBar.classList.add('hidden');
                    bulkDisburseButton.classList.add('hidden');
                }

                // Update select all checkbox state
                const visibleCheckboxes = Array.from(applicationCheckboxes).filter(cb => 
                    !cb.closest('tr').style.display || cb.closest('tr').style.display === ''
                );
                const allVisibleChecked = visibleCheckboxes.length > 0 && 
                    visibleCheckboxes.every(cb => cb.checked);
                const someVisibleChecked = visibleCheckboxes.some(cb => cb.checked);
                
                selectAll.checked = allVisibleChecked;
                selectAll.indeterminate = someVisibleChecked && !allVisibleChecked;
            }

            // Clear selection
            clearSelection?.addEventListener('click', function() {
                applicationCheckboxes.forEach(checkbox => {
                    checkbox.checked = false;
                });
                updateBulkActions();
            });

            // Bulk disburse action
            bulkDisburseAction?.addEventListener('click', function() {
                const selectedIds = Array.from(applicationCheckboxes)
                    .filter(cb => cb.checked)
                    .map(cb => cb.value);
                
                if (selectedIds.length === 0) {
                    alert('Please select at least one application to disburse.');
                    return;
                }

                if (confirm(`Are you sure you want to disburse ${selectedIds.length} selected applications? This action will create loan accounts and generate payment schedules.`)) {
                    // In a real implementation, this would make an API call
                    alert(`Bulk disbursement would process ${selectedIds.length} applications. This feature would require additional implementation for handling multiple disbursements.`);
                    
                    // For now, redirect to the first selected application's disbursement page
                    if (selectedIds.length === 1) {
                        window.location.href = `/admin/applications/${selectedIds[0]}/disburse`;
                    }
                }
            });

            // Quick disburse from table button
            bulkDisburseButton?.addEventListener('click', function() {
                const selectedIds = Array.from(applicationCheckboxes)
                    .filter(cb => cb.checked)
                    .map(cb => cb.value);
                
                if (selectedIds.length === 0) {
                    alert('Please select at least one application to disburse.');
                    return;
                }

                bulkDisburseAction.click();
            });

            // Initialize bulk actions
            updateBulkActions();

            // Add some interactive enhancements
            applicationRows.forEach(row => {
                row.addEventListener('mouseenter', function() {
                    this.style.backgroundColor = '#f9fafb';
                });
                
                row.addEventListener('mouseleave', function() {
                    if (!this.querySelector('.application-checkbox').checked) {
                        this.style.backgroundColor = '';
                    }
                });
            });

            // Keyboard shortcuts
            document.addEventListener('keydown', function(e) {
                // Ctrl/Cmd + A to select all visible applications
                if ((e.ctrlKey || e.metaKey) && e.key === 'a') {
                    e.preventDefault();
                    selectAll.checked = true;
                    applicationCheckboxes.forEach(checkbox => {
                        if (!checkbox.closest('tr').style.display || checkbox.closest('tr').style.display === '') {
                            checkbox.checked = true;
                        }
                    });
                    updateBulkActions();
                }
                
                // Escape to clear selection
                if (e.key === 'Escape') {
                    applicationCheckboxes.forEach(checkbox => {
                        checkbox.checked = false;
                    });
                    updateBulkActions();
                }
            });
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/applications/approved.blade.php ENDPATH**/ ?>