<?php
    // Define page variables
    $pageTitle = 'Repayment Collections';
    $pageSubtitle = 'Monitor and manage all received loan repayments';

    // Summary stats for the sidebar
    $stats_sidebar = [
        'total_collected' => $collections->sum('rtotal'), 
    ];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5; 
            --zedbank-blue-dark: #005A94; 
        }

        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }

        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }

        .action-btn { width: 30px; height: 30px; border-radius: 4px; display: inline-flex; align-items: center; justify-content: center; margin: 0 1px; transition: all 0.2s; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <?php echo $__env->make('accounting.partials.sidebar', ['stats' => $stats_sidebar], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-lg">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            
            
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 mb-6">
                
                
                <div class="flex flex-wrap gap-2 mb-4 items-center">
                    <span class="text-xs font-bold text-gray-400 uppercase mr-2">Quick View:</span>
                    <a href="<?php echo e(route('admin.collections.index', ['period' => 'today'])); ?>" 
                       class="px-3 py-1 text-xs rounded-full border <?php echo e(request('period') == 'today' ? 'bg-zedbank-blue text-white border-zedbank-blue' : 'bg-white text-gray-600 border-gray-300 hover:bg-gray-50'); ?> transition">
                        Today
                    </a>
                    <a href="<?php echo e(route('admin.collections.index', ['period' => 'month'])); ?>" 
                       class="px-3 py-1 text-xs rounded-full border <?php echo e(request('period') == 'month' ? 'bg-zedbank-blue text-white border-zedbank-blue' : 'bg-white text-gray-600 border-gray-300 hover:bg-gray-50'); ?> transition">
                        This Month
                    </a>
                    <a href="<?php echo e(route('admin.collections.index', ['period' => 'quarter'])); ?>" 
                       class="px-3 py-1 text-xs rounded-full border <?php echo e(request('period') == 'quarter' ? 'bg-zedbank-blue text-white border-zedbank-blue' : 'bg-white text-gray-600 border-gray-300 hover:bg-gray-50'); ?> transition">
                        This Quarter
                    </a>
                    <a href="<?php echo e(route('admin.collections.index')); ?>" 
                       class="px-3 py-1 text-xs rounded-full border <?php echo e(!request('period') ? 'bg-zedbank-blue text-white border-zedbank-blue' : 'bg-white text-gray-600 border-gray-300 hover:bg-gray-50'); ?> transition">
                        Custom
                    </a>
                </div>

                <form action="<?php echo e(route('admin.collections.index')); ?>" method="GET" class="flex flex-col lg:flex-row items-end gap-4">
                    
                    <div class="grid grid-cols-2 gap-2 w-full lg:w-auto">
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-1">From Date</label>
                            <input type="date" name="start_date" value="<?php echo e($startDate); ?>" 
                                class="block w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-zedbank-blue focus:border-zedbank-blue">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-1">To Date</label>
                            <input type="date" name="end_date" value="<?php echo e($endDate); ?>" 
                                class="block w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-zedbank-blue focus:border-zedbank-blue">
                        </div>
                    </div>

                    
                    <div class="flex-1 w-full">
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-1">Search Records</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-search text-gray-400"></i>
                            </span>
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>"
                                class="block w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-zedbank-blue focus:border-zedbank-blue text-sm" 
                                placeholder="Ref #, Customer, or Loan #...">
                        </div>
                    </div>

                    
                    <div class="flex gap-2 w-full lg:w-auto">
                        <button type="submit" class="px-6 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition text-sm font-semibold">
                            Filter
                        </button>
                        <a href="<?php echo e(route('admin.collections.index')); ?>" class="px-4 py-2 bg-gray-100 text-gray-600 rounded-lg hover:bg-gray-200 transition text-sm flex items-center justify-center">
                            <i class="fas fa-redo"></i>
                        </a>
                        <button type="button" 
                            onclick="window.location.href='<?php echo e(route('admin.collections.index', array_merge(request()->all(), ['export' => 'xls']))); ?>'" 
                            class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2 text-sm font-medium">
                            <i class="fas fa-file-excel text-green-700"></i>
                            <span>Excel</span>
                        </button>
                        <button type="button" 
                            onclick="window.open('<?php echo e(route('admin.collections.index', array_merge(request()->all(), ['pdf' => 1]))); ?>', '_blank')" 
                            class="px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition flex items-center gap-2 text-sm font-semibold">
                            <i class="fas fa-print"></i>
                            <span>PDF</span>
                        </button>
                    </div>
                </form>
            </div>

            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5 border-l-4 border-blue-500">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-blue-50 text-blue-500 mr-4">
                            <i class="fas fa-money-bill-wave text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 font-medium">Principal Collected</p>
                            <h3 class="text-xl font-bold text-gray-800">ZMW <?php echo e(number_format($stats['principal'], 2)); ?></h3>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5 border-l-4 border-green-500">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-green-50 text-green-500 mr-4">
                            <i class="fas fa-chart-line text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 font-medium">Interest Earned</p>
                            <h3 class="text-xl font-bold text-gray-800">ZMW <?php echo e(number_format($stats['interest'], 2)); ?></h3>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5 border-l-4 border-purple-500">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-purple-50 text-purple-500 mr-4">
                            <i class="fas fa-file-invoice-dollar text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 font-medium">Processing Fees</p>
                            <h3 class="text-xl font-bold text-gray-800">ZMW <?php echo e(number_format($stats['fees'], 2)); ?></h3>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5 border-l-4 border-red-500">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-red-50 text-red-500 mr-4">
                            <i class="fas fa-gavel text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 font-medium">Penalties Collected</p>
                            <h3 class="text-xl font-bold text-gray-800">ZMW <?php echo e(number_format($stats['penalties'], 2)); ?></h3>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="overflow-x-auto bg-white shadow-sm rounded-lg border border-gray-200">
                <table class="min-w-full text-sm" id="dataTable">
                    <thead class="bg-gray-50 border-b border-gray-200">
                        <tr>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium">Date</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium">Customer</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium">Loan No.</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium">Method</th>
                            <th class="px-4 py-3 text-left text-gray-600 font-medium">Reference</th>
                            <th class="px-4 py-3 text-right text-gray-600 font-medium">Amount (ZMW)</th>
                            <th class="px-4 py-3 text-center text-gray-600 font-medium">Status</th>
                            <th class="px-4 py-3 text-center text-gray-600 font-medium">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $collections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="border-b hover:bg-gray-50 transition">
                                <td class="px-4 py-3 text-gray-700">
                                    <?php echo e($repayment->rdate ? $repayment->rdate->format('M d, Y') : '—'); ?>

                                </td>
                                <td class="px-4 py-3">
                                    <div class="text-gray-900 font-medium">
                                        <?php echo e($repayment->customer->first_name ?? ''); ?> <?php echo e($repayment->customer->surname ?? ''); ?>

                                    </div>
                                    <div class="text-xs text-gray-500">ID: <?php echo e($repayment->customerid); ?></div>
                                </td>
                                <td class="px-4 py-3 text-gray-700"><?php echo e($repayment->loan->loannumber ?? 'N/A'); ?></td>
                                <td class="px-4 py-3 text-gray-700">
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800">
                                        <i class="fas fa-wallet mr-1 text-[10px]"></i> <?php echo e($repayment->pmethod); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-3 text-gray-600 italic">
                                    <?php echo e($repayment->paymentreference ?? 'No Ref'); ?>

                                </td>
                                <td class="px-4 py-3 text-right text-gray-900 font-bold">
                                    <?php echo e(number_format($repayment->rtotal, 2)); ?>

                                </td>
                                <td class="px-4 py-3 text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($repayment->status === 'Verified' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'); ?>">
                                        <?php echo e($repayment->status ?? 'Unverified'); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <div class="flex justify-center space-x-1">
                                        <a href="<?php echo e(route('admin.loans.show', $repayment->rloanid)); ?>" 
                                           class="action-btn bg-gray-100 text-zedbank-blue hover:bg-zedbank-blue hover:text-white" 
                                           title="View Loan">
                                            <i class="fas fa-file-invoice text-xs"></i>
                                        </a>
                                        <button class="action-btn bg-blue-50 text-blue-600 hover:bg-blue-600 hover:text-white" title="Print Receipt">
                                            <i class="fas fa-print text-xs"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="px-4 py-12 text-center text-gray-500">
                                    No collections found for the selected criteria.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-6">
                <?php echo e($collections->appends(request()->all())->links()); ?>

            </div>
        </main>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/collections/index.blade.php ENDPATH**/ ?>