<?php
    // NOTE: $customer variable must be passed from the controller
    $pageTitle = 'Edit Customer: ' . $customer->full_name;
    $pageSubtitle = 'Update customer information';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Customer | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5; 
            --zedbank-blue-dark: #005A94; 
        }
        /* Local overrides for form elements */
        .bg-primary { background-color: var(--zedbank-blue); }
        .hover\:bg-secondary:hover { background-color: var(--zedbank-blue-dark); }
        .focus\:ring-primary:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-primary:focus { border-color: var(--zedbank-blue); }
        
        /* Layout Positioning */
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                    <form action="<?php echo e(route('admin.customers.update', $customer->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <div class="p-6 space-y-6">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4">Personal Information</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label for="title" class="block text-sm font-medium text-gray-700 mb-2">Title</label>
                                        <select id="title" name="title" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="">Select Title</option>
                                            <option value="Mr" <?php echo e(old('title', $customer->title) == 'Mr' ? 'selected' : ''); ?>>Mr</option>
                                            <option value="Mrs" <?php echo e(old('title', $customer->title) == 'Mrs' ? 'selected' : ''); ?>>Mrs</option>
                                            <option value="Miss" <?php echo e(old('title', $customer->title) == 'Miss' ? 'selected' : ''); ?>>Miss</option>
                                            <option value="Dr" <?php echo e(old('title', $customer->title) == 'Dr' ? 'selected' : ''); ?>>Dr</option>
                                            <option value="Prof" <?php echo e(old('title', $customer->title) == 'Prof' ? 'selected' : ''); ?>>Prof</option>
                                        </select>
                                    </div>
                                    
                                    <div>
                                        <label for="first_name" class="block text-sm font-medium text-gray-700 mb-2">First Name *</label>
                                        <input type="text" id="first_name" name="first_name" required
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('first_name', $customer->first_name)); ?>">
                                        <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div>
                                        <label for="middle_name" class="block text-sm font-medium text-gray-700 mb-2">Middle Name</label>
                                        <input type="text" id="middle_name" name="middle_name"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('middle_name', $customer->middle_name)); ?>">
                                    </div>
                                    
                                    <div>
                                        <label for="surname" class="block text-sm font-medium text-gray-700 mb-2">Surname *</label>
                                        <input type="text" id="surname" name="surname" required
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('surname', $customer->surname)); ?>">
                                        <?php $__errorArgs = ['surname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div>
                                        <label for="dob" class="block text-sm font-medium text-gray-700 mb-2">Date of Birth</label>
                                        <input type="date" id="dob" name="dob"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('dob', $customer->dob ? $customer->dob->format('Y-m-d') : '')); ?>">
                                    </div>
                                </div>
                            </div>

                            <div>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4">Contact Information</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email Address *</label>
                                        <input type="email" id="email" name="email" required
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('email', $customer->email)); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div>
                                        <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">Phone Number *</label>
                                        <input type="text" id="phone" name="phone" required
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('phone', $customer->phone)); ?>">
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div>
                                        <label for="office_phone" class="block text-sm font-medium text-gray-700 mb-2">Office Phone</label>
                                        <input type="text" id="office_phone" name="office_phone"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('office_phone', $customer->office_phone)); ?>">
                                    </div>
                                </div>
                            </div>

                            <div>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4">Address Information</h3>
                                <div class="space-y-4">
                                    <div>
                                        <label for="address" class="block text-sm font-medium text-gray-700 mb-2">Address *</label>
                                        <textarea id="address" name="address" required rows="3"
                                                  class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"><?php echo e(old('address', $customer->address)); ?></textarea>
                                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <label for="town" class="block text-sm font-medium text-gray-700 mb-2">Town/City *</label>
                                            <input type="text" id="town" name="town" required
                                                   class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                                   value="<?php echo e(old('town', $customer->town)); ?>">
                                            <?php $__errorArgs = ['town'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        
                                        <div>
                                            <label for="province" class="block text-sm font-medium text-gray-700 mb-2">Province</label>
                                            <input type="text" id="province" name="province"
                                                   class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                                   value="<?php echo e(old('province', $customer->province)); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4">Professional Information</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label for="occupation" class="block text-sm font-medium text-gray-700 mb-2">Occupation</label>
                                        <input type="text" id="occupation" name="occupation"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('occupation', $customer->occupation)); ?>">
                                    </div>
                                    
                                    <div>
                                        <label for="company" class="block text-sm font-medium text-gray-700 mb-2">Company</label>
                                        <input type="text" id="company" name="company"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('company', $customer->company)); ?>">
                                    </div>
                                    
                                    <div>
                                        <label for="income" class="block text-sm font-medium text-gray-700 mb-2">Monthly Income (ZMW)</label>
                                        <input type="number" id="income" name="income" step="0.01" min="0"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('income', $customer->income)); ?>">
                                    </div>
                                </div>
                            </div>

                            <div>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4">Identification</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label for="idtype" class="block text-sm font-medium text-gray-700 mb-2">ID Type</label>
                                        <select id="idtype" name="idtype" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="">Select ID Type</option>
                                            <option value="NRC" <?php echo e(old('idtype', $customer->idtype) == 'NRC' ? 'selected' : ''); ?>>NRC</option>
                                            <option value="Passport" <?php echo e(old('idtype', $customer->idtype) == 'Passport' ? 'selected' : ''); ?>>Passport</option>
                                            <option value="Drivers License" <?php echo e(old('idtype', $customer->idtype) == 'Drivers License' ? 'selected' : ''); ?>>Driver's License</option>
                                            <option value="Voters Card" <?php echo e(old('idtype', $customer->idtype) == 'Voters Card' ? 'selected' : ''); ?>>Voter's Card</option>
                                        </select>
                                    </div>
                                    
                                    <div>
                                        <label for="number" class="block text-sm font-medium text-gray-700 mb-2">ID Number</label>
                                        <input type="text" id="number" name="number"
                                               class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary"
                                               value="<?php echo e(old('number', $customer->number)); ?>">
                                    </div>
                                </div>
                            </div>

                            <div>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4">Status</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Customer Status *</label>
                                        <select id="status" name="status" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="Active" <?php echo e(old('status', $customer->status) == 'Active' ? 'selected' : ''); ?>>Active</option>
                                            <option value="Inactive" <?php echo e(old('status', $customer->status) == 'Inactive' ? 'selected' : ''); ?>>Inactive</option>
                                            <option value="Suspended" <?php echo e(old('status', $customer->status) == 'Suspended' ? 'selected' : ''); ?>>Suspended</option>
                                            <option value="Pending" <?php echo e(old('status', $customer->status) == 'Pending' ? 'selected' : ''); ?>>Pending</option>
                                        </select>
                                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div>
                                        <label for="verification_status" class="block text-sm font-medium text-gray-700 mb-2">Verification Status</label>
                                        <select id="verification_status" name="verification_status" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="">Select Status</option>
                                            <option value="verified" <?php echo e(old('verification_status', $customer->verification_status) == 'verified' ? 'selected' : ''); ?>>Verified</option>
                                            <option value="failed" <?php echo e(old('verification_status', $customer->verification_status) == 'failed' ? 'selected' : ''); ?>>Failed</option>
                                            <option value="skipped" <?php echo e(old('verification_status', $customer->verification_status) == 'skipped' ? 'selected' : ''); ?>>Skipped</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="bg-gray-50 px-6 py-4 border-t border-gray-200 rounded-b-lg">
                            <div class="flex justify-end space-x-3">
                                <a href="<?php echo e(route('admin.customers.show', $customer->id)); ?>" 
                                   class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">
                                    Cancel
                                </a>
                                <button type="submit" 
                                        class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-secondary transition">
                                    Update Customer
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/customers/edit.blade.php ENDPATH**/ ?>