
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Overdue Payment Notice</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-left: 4px solid #dc3545;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 1px solid #eee;
            padding-bottom: 20px;
        }
        .logo {
            max-width: 150px;
            margin-bottom: 15px;
        }
        .title {
            color: #dc3545;
            font-size: 24px;
            font-weight: bold;
            margin: 0 0 10px 0;
        }
        .subtitle {
            color: #666;
            font-size: 16px;
            margin: 0;
        }
        .alert-box {
            background-color: #fff5f5;
            border: 1px solid #feb2b2;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
            text-align: center;
        }
        .alert-icon {
            font-size: 48px;
            color: #dc3545;
            margin-bottom: 15px;
        }
        .alert-text {
            font-size: 18px;
            color: #c53030;
            font-weight: bold;
            margin: 0;
        }
        .details-box {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e9ecef;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .detail-label {
            font-weight: 600;
            color: #495057;
        }
        .detail-value {
            color: #212529;
            font-weight: 500;
        }
        .amount-highlight {
            color: #dc3545;
            font-size: 20px;
            font-weight: bold;
        }
        .days-highlight {
            background-color: #dc3545;
            color: white;
            padding: 4px 12px;
            border-radius: 20px;
            font-weight: bold;
            font-size: 14px;
        }
        .action-box {
            background-color: #e8f4fd;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
            text-align: center;
        }
        .action-title {
            color: #0066cc;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 15px;
        }
        .payment-methods {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin: 20px 0;
            flex-wrap: wrap;
        }
        .method {
            background-color: white;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 15px;
            width: 180px;
            text-align: center;
        }
        .method-icon {
            font-size: 24px;
            color: #0066cc;
            margin-bottom: 10px;
        }
        .method-title {
            font-weight: bold;
            margin-bottom: 5px;
        }
        .method-details {
            font-size: 14px;
            color: #666;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #666;
            font-size: 14px;
        }
        .warning-note {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            color: #856404;
            font-size: 14px;
        }
        .contact-info {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            font-size: 14px;
        }
        .cta-button {
            display: inline-block;
            background-color: #dc3545;
            color: white;
            text-decoration: none;
            padding: 12px 30px;
            border-radius: 6px;
            font-weight: bold;
            font-size: 16px;
            margin: 10px 0;
            transition: background-color 0.3s;
        }
        .cta-button:hover {
            background-color: #c82333;
        }
        .priority-badge {
            display: inline-block;
            background-color: #dc3545;
            color: white;
            padding: 4px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
            margin-left: 10px;
        }
        @media (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .detail-row {
                flex-direction: column;
            }
            .payment-methods {
                flex-direction: column;
                align-items: center;
            }
            .method {
                width: 100%;
                max-width: 250px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="title">URGENT: OVERDUE PAYMENT NOTICE <span class="priority-badge">HIGH PRIORITY</span></div>
            <div class="subtitle">IMMIA FINANCE - Loan Account Notification</div>
        </div>

        <div class="alert-box">
            <div class="alert-icon">⚠️</div>
            <div class="alert-text">PAYMENT OVERDUE: <?php echo e($overdueDays); ?> DAYS LATE</div>
        </div>

        <p>Dear <strong><?php echo e($customer->first_name); ?> <?php echo e($customer->surname); ?></strong>,</p>
        
        <p>This is an urgent notification regarding your loan account. Your payment for loan <strong>#<?php echo e($schedule->loannumber); ?></strong> is now <span class="days-highlight"><?php echo e($overdueDays); ?> DAYS OVERDUE</span>.</p>

        <div class="details-box">
            <h3 style="color: #dc3545; margin-top: 0;">Overdue Payment Details</h3>
            
            <div class="detail-row">
                <span class="detail-label">Loan Account Number:</span>
                <span class="detail-value"><?php echo e($schedule->loannumber); ?></span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Customer Reference:</span>
                <span class="detail-value"><?php echo e($customer->customer_number); ?></span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Installment Number:</span>
                <span class="detail-value">#<?php echo e($schedule->installment_number); ?></span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Original Due Date:</span>
                <span class="detail-value"><?php echo e(\Carbon\Carbon::parse($schedule->paymentdate)->format('F d, Y')); ?></span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Days Overdue:</span>
                <span class="detail-value">
                    <span class="days-highlight"><?php echo e($overdueDays); ?> days</span>
                </span>
            </div>
            
            <div class="detail-row">
                <span class="detail-label">Overdue Amount:</span>
                <span class="detail-value amount-highlight">ZMW <?php echo e(number_format($overdueAmount, 2)); ?></span>
            </div>
            
            <?php if($loan): ?>
            <div class="detail-row">
                <span class="detail-label">Total Loan Balance:</span>
                <span class="detail-value">ZMW <?php echo e(number_format($loan->totalbalance, 2)); ?></span>
            </div>
            <?php endif; ?>
        </div>

        <div class="warning-note">
            <strong>⚠️ IMPORTANT NOTICE:</strong> Failure to make this payment immediately may result in:
            <ul style="margin: 10px 0 0 20px; padding: 0;">
                <li>Additional late payment penalties and fees</li>
                <li>Negative impact on your credit score</li>
                <li>Legal action for debt recovery</li>
                <li>Restriction from future loan facilities</li>
            </ul>
        </div>

        <div class="action-box">
            <div class="action-title">IMMEDIATE PAYMENT REQUIRED</div>
            <p>Please make payment of the overdue amount immediately to avoid further consequences.</p>
            
            <a href="#" class="cta-button">MAKE PAYMENT NOW</a>
            
            <div class="payment-methods">
                <div class="method">
                    <div class="method-icon">🏦</div>
                    <div class="method-title">Bank Transfer</div>
                    <div class="method-details">
                        <div>Account: IMMIA FINANCE LTD</div>
                        <div>Bank: Standard Chartered</div>
                        <div>Acc No: 0100 1234 5678</div>
                        <div>Reference: <?php echo e($schedule->loannumber); ?></div>
                    </div>
                </div>
                
                <div class="method">
                    <div class="method-icon">📱</div>
                    <div class="method-title">Mobile Money</div>
                    <div class="method-details">
                        <div>Airtel Money: *123*<?php echo e($schedule->loannumber); ?>#</div>
                        <div>MTN Mobile Money: *126*<?php echo e($schedule->loannumber); ?>#</div>
                        <div>Reference: <?php echo e($schedule->loannumber); ?></div>
                    </div>
                </div>
                
                <div class="method">
                    <div class="method-icon">🏢</div>
                    <div class="method-title">Branch Payment</div>
                    <div class="method-details">
                        <div>Visit any IMMIA branch</div>
                        <div>Bring this notification</div>
                        <div>Business Hours: 8AM-5PM</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="footer">
            <p>This is an automated notification from IMMIA FINANCE LTD. Please do not reply to this email.</p>
            <p>If you have already made this payment, please disregard this notice and accept our thanks.</p>
            <p style="font-size: 12px; color: #999; margin-top: 20px;">
                CONFIDENTIALITY NOTICE: This email and any attachments are confidential and intended solely for the addressee. 
                If you are not the intended recipient, please notify us immediately and delete this email.
            </p>
            <p style="font-size: 12px; color: #999;">
                © <?php echo e(date('Y')); ?> IMMIA FINANCE LTD. All rights reserved. Registered under the Banking and Financial Services Act.
            </p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/emails/payment_overdue_reminder.blade.php ENDPATH**/ ?>