<?php
    // Define page variables
    $pageTitle = 'Active Loans';
    $pageSubtitle = 'View and manage all currently active loans';

    // Calculate dynamic stats for the top cards
    $totalPrincipal = $loans->sum('amount');
    $totalBalance = $loans->sum('principalbalance');
    $totalInterest = $loans->sum('interestbalance');
    $totalProcessing = $loans->sum('processing_fee_balance');
    $totalRepaid = $totalPrincipal - $totalBalance;
    $totalOutstanding = $totalBalance + $totalInterest + $totalProcessing;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | IMMIA FINANCE</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5; /* ThemeBlue */
            --zedbank-blue-dark: #005A94; /* Darker shade for hover/active background */
        }

        /* Custom Tailwind-like classes */
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .hover\:bg-zedbank-blue-dark:hover { background-color: var(--zedbank-blue-dark); }

        /* Sidebar/Main Content Layout */
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }

        /* Local Overrides */
        .focus\:ring-primary:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-primary:focus { border-color: var(--zedbank-blue); }
        .bg-primary { background-color: var(--zedbank-blue); }
        
        /* Custom color for interest */
        .text-interest { color: #8B4513; }
        .bg-interest-light { background-color: #FFF8DC; }
        .text-processing { color: #9932CC; }
        .bg-processing-light { background-color: #E6E6FA; }
        .text-total { color: #000080; }
        .bg-total-light { background-color: #F0F8FF; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
             <div class="mb-8">
                    <h1 class="text-3xl font-bold text-gray-800 mb-2">Active Loans</h1>
                    <p class="text-gray-600">Overview of all loans currently outstanding.</p>
                </div>
                <?php if(session('success')): ?>
                    <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-lg">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session('error')): ?>
                    <div class="mb-6 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                
                <div class="grid grid-cols-1 md:grid-cols-6 gap-4 mb-6">
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Active Loans</p>
                                <p class="text-2xl font-bold text-zedbank-blue"><?php echo e($loans->total()); ?></p>
                            </div>
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-money-check-alt text-zedbank-blue"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Principal Balance</p>
                                <p class="text-lg font-bold text-red-600"><?php echo e(number_format($totalBalance, 2)); ?></p>
                            </div>
                            <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-home text-red-600"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Interest Balance</p>
                                <p class="text-lg font-bold text-interest"><?php echo e(number_format($totalInterest, 2)); ?></p>
                            </div>
                            <div class="w-10 h-10 bg-interest-light rounded-lg flex items-center justify-center">
                                <i class="fas fa-chart-line text-interest"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Processing Fees</p>
                                <p class="text-lg font-bold text-processing"><?php echo e(number_format($totalProcessing, 2)); ?></p>
                            </div>
                            <div class="w-10 h-10 bg-processing-light rounded-lg flex items-center justify-center">
                                <i class="fas fa-file-invoice-dollar text-processing"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Total Outstanding</p>
                                <p class="text-lg font-bold text-total"><?php echo e(number_format($totalOutstanding, 2)); ?></p>
                            </div>
                            <div class="w-10 h-10 bg-total-light rounded-lg flex items-center justify-center">
                                <i class="fas fa-balance-scale text-total"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg p-4 shadow-sm border">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600">Amount Repaid</p>
                                <p class="text-lg font-bold text-purple-600"><?php echo e(number_format($totalRepaid, 2)); ?></p>
                            </div>
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-calculator text-purple-600"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 mb-6">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                        <div class="w-full md:w-auto">
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-search text-gray-400"></i>
                                </div>
                                <input 
                                    type="text" 
                                    id="searchInput" 
                                    class="block w-full md:w-80 pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary" 
                                    placeholder="Search by loan number, customer..."
                                >
                            </div>
                        </div>
                        <div class="flex flex-wrap gap-2 w-full md:w-auto">
                            <a href="<?php echo e(route('admin.loans.non-performing')); ?>" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition flex items-center gap-2">
                                <i class="fas fa-exclamation-triangle"></i>
                                <span>View NPLs</span>
                            </a>
                            <button class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <i class="fas fa-filter"></i>
                                <span>Filter</span>
                            </button>
                            <button class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <i class="fas fa-download"></i>
                                <span>Export</span>
                            </button>
                        </div>
                    </div>
                </div>

                
                <div class="overflow-x-auto bg-white shadow-sm rounded-lg border border-gray-200">
                    <table class="min-w-full text-sm" id="loansTable">
                        <thead class="bg-gray-50 border-b border-gray-200">
                            <tr>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Loan No</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Customer</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Product</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Disbursed</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Principal</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Principal Balance</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Interest Balance</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Processing Fees</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Total Balance</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Interest Rate</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Term</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Status</th>
                                <th class="px-4 py-3 text-left text-gray-600 font-medium">Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $isOverdue = $loan->isOverdue();
                                    $statusText = $isOverdue ? 'Overdue' : 'Active';
                                    $badgeClass = $isOverdue ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800';
                                    $daysOverdue = $isOverdue && method_exists($loan, 'getDaysOverdueAttribute') ? $loan->days_overdue : 0;
                                    
                                    // Calculate days until first payment
                                    $daysUntilFirst = 0;
                                    if ($loan->firstpaymentdate) {
                                        $firstPaymentDate = \Carbon\Carbon::parse($loan->firstpaymentdate);
                                        $now = \Carbon\Carbon::now();
                                        $daysUntilFirst = $now->diffInDays($firstPaymentDate, false);
                                    }
                                    
                                    // Map frequency to display text
                                    $frequencyMap = [
                                        'weekly' => 'weeks',
                                        'monthly' => 'months',
                                        'daily' => 'days',
                                    ];
                                    $termUnit = $frequencyMap[$loan->paymentfrequency] ?? 'months';
                                    $termDisplay = $loan->loanterm . ' ' . $termUnit;
                                    
                                    // Calculate balances
                                    $principalBalance = $loan->principalbalance ?? 0;
                                    $interestBalance = $loan->interestbalance ?? 0;
                                    $processingBalance = $loan->processing_fee_balance ?? 0;
                                    $totalBalance = $principalBalance + $interestBalance + $processingBalance;
                                    
                                    // Interest method
                                    $interestMethod = $loan->interest_method ?? 'reducing_balance';
                                ?>
                                <tr class="border-b hover:bg-gray-50 transition">
                                    <td class="px-4 py-3 text-gray-700 font-medium">
                                        <?php echo e($loan->loannumber); ?>

                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <?php if($loan->customer): ?>
                                            <p class="font-semibold"><?php echo e($loan->customer->first_name); ?> <?php echo e($loan->customer->surname); ?></p>
                                            <p class="text-xs text-gray-500"><?php echo e($loan->customer->customer_number); ?></p>
                                        <?php else: ?>
                                            <span class="text-gray-500">—</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <?php echo e($loan->loanType->product ?? 'N/A'); ?>

                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <?php echo e($loan->disburseddate ? \Carbon\Carbon::parse($loan->disburseddate)->format('M d') : 'N/A'); ?>

                                    </td>
                                    <td class="px-4 py-3 text-gray-800 font-bold">
                                        <?php echo e(number_format($loan->amount, 2)); ?>

                                    </td>
                                    <td class="px-4 py-3 text-red-600 font-bold">
                                        <?php echo e(number_format($principalBalance, 2)); ?>

                                    </td>
                                    <td class="px-4 py-3 text-interest font-bold">
                                        <?php echo e(number_format($interestBalance, 2)); ?>

                                    </td>
                                    <td class="px-4 py-3 text-processing font-bold">
                                        <?php echo e(number_format($processingBalance, 2)); ?>

                                    </td>
                                    <td class="px-4 py-3 text-total font-bold">
                                        <div class="flex flex-col">
                                            <span class="font-bold"><?php echo e(number_format($totalBalance, 2)); ?></span>
                                            <span class="text-xs text-gray-500">
                                                <?php if($interestMethod === 'simple_interest'): ?>
                                                    Simple Int.
                                                <?php else: ?>
                                                    Reducing Bal.
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <div class="flex flex-col">
                                            <span class="font-medium"><?php echo e(number_format($loan->interestrate, 2)); ?>%</span>
                                            <span class="text-xs text-gray-500">
                                                <?php echo e($loan->paymentfrequency === 'Weekly' ? 'Weekly' : ($loan->paymentfrequency === 'Monthly' ? 'Monthly' : 'Daily')); ?>

                                            </span>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <div class="flex flex-col">
                                            <span class="font-medium"><?php echo e($termDisplay); ?></span>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3">
                                        <div class="flex flex-col gap-1">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($badgeClass); ?>">
                                                <i class="fas fa-<?php echo e($isOverdue ? 'clock' : 'check'); ?> mr-1"></i>
                                                <?php echo e($statusText); ?>

                                            </span>
                                            
                                            <?php if($isOverdue && $daysOverdue > 0): ?>
                                                <span class="text-xs text-red-600 font-medium">
                                                    <i class="fas fa-exclamation-circle mr-1"></i>
                                                    <?php echo e($daysOverdue); ?> day<?php echo e($daysOverdue > 1 ? 's' : ''); ?>

                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3">
                                        <div class="flex space-x-2">
                                            <a href="<?php echo e(route('admin.loans.show', $loan->loanid)); ?>" 
                                               class="text-zedbank-blue hover:text-zedbank-blue-dark p-1 rounded transition" 
                                               title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <a href="<?php echo e(route('admin.loans.payment-form', $loan->loanid)); ?>" 
                                                class="text-green-600 hover:text-green-800 p-1 rounded transition" 
                                                title="Record Payment">
                                                <i class="fas fa-dollar-sign"></i>
                                            </a>
                                            
                                            <?php if(auth()->user()->hasPermission('loans.transfer-npl')): ?>
                                            <form method="POST" action="<?php echo e(route('admin.loans.transferToNPL', $loan->loanid)); ?>" class="inline" onsubmit="return confirm('Are you sure you want to transfer this loan to Non-Performing status?')">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" 
                                                        class="text-red-600 hover:text-red-800 p-1 rounded transition" 
                                                        title="Transfer to NPL">
                                                    <i class="fas fa-exclamation-triangle"></i>
                                                </button>
                                            </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="13" class="px-4 py-8 text-center text-gray-500">
                                        <div class="flex flex-col items-center justify-center">
                                            <i class="fas fa-money-check-alt text-4xl text-gray-300 mb-4"></i>
                                            <p class="text-lg">No active loans found</p>
                                            <p class="text-sm">Loans will appear here after they have been disbursed.</p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                
                <div class="mt-6 flex flex-col md:flex-row justify-between items-center gap-4">
                    <div class="text-sm text-gray-600">
                        Showing <span class="font-medium"><?php echo e($loans->firstItem() ?? 0); ?></span> to 
                        <span class="font-medium"><?php echo e($loans->lastItem() ?? 0); ?></span> of 
                        <span class="font-medium"><?php echo e($loans->total()); ?></span> entries
                    </div>
                    <div class="flex space-x-2">
                        <?php if($loans->onFirstPage()): ?>
                            <button class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg text-gray-400 cursor-not-allowed flex items-center gap-2" disabled>
                                <i class="fas fa-chevron-left"></i>
                                <span>Previous</span>
                            </button>
                        <?php else: ?>
                            <a href="<?php echo e($loans->previousPageUrl()); ?>" class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <i class="fas fa-chevron-left"></i>
                                <span>Previous</span>
                            </a>
                        <?php endif; ?>

                        <?php $__currentLoopData = $loans->getUrlRange(1, $loans->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($page == $loans->currentPage()): ?>
                                <span class="px-4 py-2 text-sm bg-zedbank-blue text-white rounded-lg"><?php echo e($page); ?></span>
                            <?php else: ?>
                                <a href="<?php echo e($url); ?>" class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition"><?php echo e($page); ?></a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($loans->hasMorePages()): ?>
                            <a href="<?php echo e($loans->nextPageUrl()); ?>" class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <span>Next</span>
                                <i class="fas fa-chevron-right"></i>
                            </a>
                        <?php else: ?>
                            <button class="px-4 py-2 text-sm bg-white border border-gray-300 rounded-lg text-gray-400 cursor-not-allowed flex items-center gap-2" disabled>
                                <span>Next</span>
                                <i class="fas fa-chevron-right"></i>
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const loansTable = document.getElementById('loansTable');
            const loanRows = loansTable.querySelectorAll('tbody tr');

            searchInput?.addEventListener('input', function() {
                const searchTerm = this.value.toLowerCase();
                
                loanRows.forEach(row => {
                    const rowText = row.textContent.toLowerCase();
                    if (rowText.includes(searchTerm)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            });

            // Filter button stub
            document.querySelector('.flex-wrap button:nth-child(2)').addEventListener('click', function() {
                alert('Opening loan filter options...');
            });
            
            // Export button stub
            document.querySelector('.flex-wrap button:nth-child(3)').addEventListener('click', function() {
                alert('Exporting active loan data...');
            });
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/loans/active.blade.php ENDPATH**/ ?>