<?php
    // Define page variables
    $pageTitle = 'Customers';
    $pageSubtitle = 'Manage and view customer information';

    $stats = [
        'pending_applications' => 5, 
    ];

    // Helper to highlight search terms
    if (!function_exists('highlight')) {
        function highlight($text, $search) {
            if (!$search || !$text) return $text;
            return preg_replace('/(' . preg_quote($search, '/') . ')/i', '<b class="bg-yellow-200 text-black px-0.5 rounded">$1</b>', $text);
        }
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --zedbank-blue: #0077C5; 
            --zedbank-blue-dark: #005A94; 
            --zedbank-blue-medium: #005A94; 
        }

        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-zedbank-blue-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }

        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { 
            .lg\:ml-64 { margin-left: 0 !important; }
        }

        .focus\:ring-zedbank-blue:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-zedbank-blue:focus { border-color: var(--zedbank-blue); }
        
        .category-btn.active {
            background-color: var(--zedbank-blue);
            color: white;
            border-color: var(--zedbank-blue-dark);
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="max-w-7xl mx-auto">
                <?php if(session('success')): ?>
                    <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-lg">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="mb-6 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 mb-6">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                        <div class="w-full md:w-auto relative" id="searchContainer">
                            <form id="searchForm" action="<?php echo e(route('admin.customers.index')); ?>" method="GET" class="flex flex-col md:flex-row items-start md:items-center gap-3">
                                <div class="flex items-center gap-2 text-sm text-gray-600">
                                    <span>Show</span>
                                    <select name="per_page" onchange="this.form.submit()" class="bg-white border border-gray-300 rounded-lg p-1.5 focus:ring-zedbank-blue">
                                        <option value="10" <?php echo e(request('per_page') == 10 ? 'selected' : ''); ?>>10</option>
                                        <option value="20" <?php echo e(request('per_page', 20) == 20 ? 'selected' : ''); ?>>20</option>
                                        <option value="50" <?php echo e(request('per_page') == 50 ? 'selected' : ''); ?>>50</option>
                                        <option value="100" <?php echo e(request('per_page') == 100 ? 'selected' : ''); ?>>100</option>
                                    </select>
                                    <span>entries</span>
                                </div>

                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i id="searchIcon" class="fas fa-search text-gray-400"></i>
                                        <i id="loadingSpinner" class="fas fa-circle-notch fa-spin text-zedbank-blue hidden"></i>
                                    </div>
                                    <input 
                                        type="text" 
                                        name="search" 
                                        id="searchInput"
                                        value="<?php echo e(request('search')); ?>"
                                        class="block w-full md:w-80 pl-10 pr-10 py-2 border border-gray-300 rounded-lg focus:ring-zedbank-blue focus:border-zedbank-blue focus:ring-1" 
                                        placeholder="Search customers..."
                                        autocomplete="off"
                                    >
                                    <?php if(request('search')): ?>
                                        <a href="<?php echo e(route('admin.customers.index')); ?>" class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-red-500">
                                            <i class="fas fa-times-circle"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                                <button type="submit" class="px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition flex items-center gap-2">
                                    <i class="fas fa-search"></i>
                                    <span class="hidden sm:inline">Search</span>
                                </button>
                            </form>

                            <div id="historyDropdown" class="absolute z-50 mt-1 left-0 md:left-[110px] w-80 bg-white border border-gray-200 rounded-lg shadow-lg hidden">
                                <div class="p-2 text-xs font-semibold text-gray-500 border-b border-gray-100 flex justify-between items-center">
                                    <span>Recent Searches</span>
                                    <button id="clearHistory" class="hover:text-red-500">Clear All</button>
                                </div>
                                <ul id="historyList" class="max-h-48 overflow-y-auto"></ul>
                            </div>

                            <?php if(request('search')): ?>
                                <div class="mt-2 text-xs text-gray-500">
                                    Found <span class="font-bold text-zedbank-blue"><?php echo e($customers->total()); ?></span> <?php echo e(Str::plural('customer', $customers->total())); ?> matching "<?php echo e(request('search')); ?>"
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="flex flex-wrap gap-2 w-full md:w-auto">
                            <?php if(auth()->user()->hasPermission('customers.create')): ?>
                            <a href="<?php echo e(route('admin.customers.create')); ?>" class="px-4 py-2 bg-zedbank-blue text-white rounded-lg hover:bg-zedbank-blue-dark transition flex items-center gap-2">
                                <i class="fas fa-user-plus"></i>
                                <span>New Customer</span>
                            </a>
                            <?php endif; ?>
                            <button class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <i class="fas fa-filter"></i>
                                <span>Filter</span>
                            </button>
                            <button class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition flex items-center gap-2">
                                <i class="fas fa-download"></i>
                                <span>Export</span>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="overflow-x-auto bg-white shadow-sm rounded-lg border border-gray-200">
                    <table class="min-w-full text-sm">
                        <thead class="bg-gray-50 border-b border-gray-200">
                            <tr>
                                <th class="px-4 py-3 text-left font-medium text-gray-600">ID</th>
                                <th class="px-4 py-3 text-left font-medium text-gray-600">Customer No</th>
                                <th class="px-4 py-3 text-left font-medium text-gray-600">Customer Name</th>
                                <th class="px-4 py-3 text-left font-medium text-gray-600">Contact Info</th>
                                <th class="px-4 py-3 text-left font-medium text-gray-600">Location</th>
                                <th class="px-4 py-3 text-left font-medium text-gray-600">Active Loans</th>
                                <th class="px-4 py-3 text-left font-medium text-gray-600">Status</th>
                                <th class="px-4 py-3 text-left font-medium text-gray-600">Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-b hover:bg-gray-50 transition">
                                    <td class="px-4 py-3 text-gray-700 font-medium"><?php echo e($customer->id); ?></td>
                                    <td class="px-4 py-3">
                                        <span class="font-mono text-gray-700"><?php echo highlight($customer->customer_number, request('search')); ?></span>
                                    </td>
                                    <td class="px-4 py-3">
                                        <div class="flex items-center gap-3">
                                            <?php if($customer->has_profile_picture): ?>
                                                <img src="<?php echo e($customer->profile_picture_url); ?>" class="w-8 h-8 rounded-full object-cover">
                                            <?php else: ?>
                                                <div class="w-8 h-8 rounded-full bg-gray-100 flex items-center justify-center text-gray-400 border border-gray-200">
                                                    <i class="fas fa-user text-xs"></i>
                                                </div>
                                            <?php endif; ?>
                                            <div>
                                                <div class="font-medium text-gray-900"><?php echo highlight($customer->full_name, request('search')); ?></div>
                                                <div class="text-xs text-gray-500"><?php echo e($customer->occupation ?? 'Not specified'); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3">
                                        <div class="space-y-1 text-gray-700">
                                            <div class="flex items-center gap-2"><i class="fas fa-envelope text-gray-400 text-xs"></i> <?php echo highlight($customer->email, request('search')); ?></div>
                                            <div class="flex items-center gap-2"><i class="fas fa-phone text-gray-400 text-xs"></i> <?php echo highlight($customer->phone, request('search')); ?></div>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-gray-700">
                                        <div class="text-sm"><?php echo e($customer->town); ?></div>
                                        <div class="text-xs text-gray-500"><?php echo e($customer->province); ?></div>
                                    </td>
                                    <td class="px-4 py-3">
                                        <?php $count = $customer->activeDisbursedLoans()->count(); ?>
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium <?php echo e($count > 0 ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-600'); ?>">
                                            <?php echo e($count); ?> active
                                        </span>
                                    </td>
                                    <td class="px-4 py-3">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($customer->status === 'Active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                                            <?php echo e($customer->status ?? 'Active'); ?>

                                        </span>
                                    </td>
                                    <td class="px-4 py-3">
                                        <div class="flex space-x-2">
                                            <a href="<?php echo e(route('admin.customers.show', $customer->id)); ?>" class="text-zedbank-blue hover:text-zedbank-blue-dark"><i class="fas fa-eye"></i></a>
                                            <?php if(auth()->user()->hasPermission('customers.edit')): ?>
                                                <a href="<?php echo e(route('admin.customers.edit', $customer->id)); ?>" class="text-green-600 hover:text-green-800"><i class="fas fa-edit"></i></a>
                                            <?php endif; ?>
                                            <button onclick="openChatModal(<?php echo e($customer->id); ?>, '<?php echo e($customer->full_name); ?>')" class="text-zedbank-blue hover:text-zedbank-blue-dark" title="Message">
                                                <i class="fas fa-comment-dots text-lg"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="px-4 py-8 text-center text-gray-500">No customers found matching your criteria.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-6">
                    <?php echo e($customers->appends(request()->except('page'))->links()); ?>

                </div>
            </div>
        </main>
    </div>

    <div id="chatModal" class="fixed inset-0 z-[60] hidden bg-black bg-opacity-50 flex items-center justify-center p-4">
        <div class="bg-white w-full max-w-md rounded-2xl shadow-2xl flex flex-col h-[600px] overflow-hidden">
            <div class="bg-zedbank-blue p-4 flex items-center justify-between text-white shadow-md">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center border border-white/30"><i class="fas fa-user"></i></div>
                    <div>
                        <h3 id="chatCustomerName" class="font-bold tracking-tight">Name</h3>
                        <p class="text-[10px] text-blue-100 flex items-center gap-1">
                            <span class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></span>Active Session
                        </p>
                    </div>
                </div>
                <button onclick="closeChatModal()" class="text-white/80 hover:text-white transition-transform hover:scale-110"><i class="fas fa-times text-xl"></i></button>
            </div>
            <div class="bg-gray-50 p-3 border-b border-gray-200">
                <label class="text-[10px] uppercase font-bold text-gray-400 mb-2 block tracking-widest">Select Category</label>
                <div class="flex flex-wrap gap-2">
                    <?php $__currentLoopData = ['Promotions', 'Follow Up', 'Payment Reminder', 'Document Requests', 'Others']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button onclick="setCategory(this, '<?php echo e($cat); ?>')" class="category-btn px-3 py-1.5 text-xs rounded-lg border border-gray-300 bg-white hover:border-zedbank-blue hover:text-zedbank-blue transition-all duration-200 font-medium"><?php echo e($cat); ?></button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div id="chatBody" class="flex-1 bg-slate-50 p-4 overflow-y-auto space-y-4"></div>
            <form id="chatForm" onsubmit="sendMessage(event)" class="bg-white p-4 border-t border-gray-100 flex items-center gap-3">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="chatCustomerId">
                <input type="hidden" id="chatCategory" value="Others">
                <div class="flex-1">
                    <input type="text" id="messageInput" placeholder="Type your message..." class="w-full border-gray-200 rounded-xl py-2.5 px-4 focus:ring-zedbank-blue focus:border-zedbank-blue text-sm bg-gray-50" required>
                </div>
                <button type="submit" id="chatSubmitBtn" class="bg-zedbank-blue text-white w-11 h-11 rounded-xl flex items-center justify-center hover:bg-zedbank-blue-dark transition-all shadow-lg">
                    <i class="fas fa-paper-plane"></i>
                </button>
            </form>
        </div>
    </div>

    <script>
        let selectedCategory = 'Others';

        async function openChatModal(id, name) {
            document.getElementById('chatCustomerId').value = id;
            document.getElementById('chatCustomerName').innerText = name;
            document.getElementById('chatModal').classList.remove('hidden');
            
            const chatBody = document.getElementById('chatBody');
            chatBody.innerHTML = '<div class="text-center py-10 text-gray-400"><i class="fas fa-spinner fa-spin"></i> Loading...</div>';

            try {
                // Corrected endpoint using Blade helper
                const response = await fetch("<?php echo e(url('admin/customers')); ?>/" + id + "/message-history");
                const messages = await response.json();
                chatBody.innerHTML = ''; 

                if (messages.length === 0) {
                    chatBody.innerHTML = '<div class="text-center py-10 text-gray-400 text-xs">No history found.</div>';
                } else {
                    messages.forEach(msg => {
                        const statusIcon = msg.status === 'sent' ? '✓' : '⚠';
                        chatBody.innerHTML += `
                            <div class="flex flex-col items-end mb-4">
                                <div class="bg-zedbank-blue text-white p-3 rounded-2xl rounded-tr-none shadow-sm max-w-[85%] text-sm">
                                    <span class="text-[9px] font-bold block mb-1 uppercase opacity-70">${msg.category}</span>
                                    ${msg.message}
                                    <div class="flex justify-between items-center mt-1 gap-4">
                                        <span class="text-[9px] opacity-70">${statusIcon} ${msg.status.toUpperCase()}</span>
                                        <span class="text-[9px] opacity-70">${msg.time}</span>
                                    </div>
                                </div>
                            </div>`;
                    });
                    chatBody.scrollTop = chatBody.scrollHeight;
                }
            } catch (error) {
                chatBody.innerHTML = '<div class="text-center py-10 text-red-400 text-xs">Failed to load history.</div>';
            }
            document.getElementById('messageInput').focus();
        }

        function closeChatModal() { document.getElementById('chatModal').classList.add('hidden'); }

        function setCategory(btn, cat) {
            document.querySelectorAll('.category-btn').forEach(b => b.classList.remove('active', 'bg-zedbank-blue', 'text-white'));
            btn.classList.add('active', 'bg-zedbank-blue', 'text-white');
            selectedCategory = cat; 
            document.getElementById('chatCategory').value = cat;
        }

        async function sendMessage(e) {
            e.preventDefault();
            const messageInput = document.getElementById('messageInput');
            const submitBtn = document.getElementById('chatSubmitBtn');
            const msg = messageInput.value;
            const customerId = document.getElementById('chatCustomerId').value;
            const category = document.getElementById('chatCategory').value;

            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

            try {
                const response = await fetch("<?php echo e(route('admin.customers.send-message')); ?>", {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                    body: JSON.stringify({ customer_id: customerId, category: category, message: msg })
                });

                const result = await response.json();
                if (result.success) {
                    const chatBody = document.getElementById('chatBody');
                    chatBody.innerHTML += `
                        <div class="flex flex-col items-end mb-4">
                            <div class="bg-zedbank-blue text-white p-3 rounded-2xl rounded-tr-none shadow-sm max-w-[85%] text-sm">
                                <span class="text-[9px] font-bold block mb-1 uppercase opacity-70">${category}</span>
                                ${msg}
                                <span class="text-[9px] text-blue-100 block text-right mt-1 opacity-70">Just now</span>
                            </div>
                        </div>`;
                    messageInput.value = '';
                    chatBody.scrollTop = chatBody.scrollHeight;
                } else {
                    alert('Error: ' + result.message);
                }
            } catch (error) {
                alert('Network error.');
            } finally {
                submitBtn.disabled = false;
                submitBtn.innerHTML = '<i class="fas fa-paper-plane"></i>';
            }
        }

        // Search logic remains unchanged
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const searchForm = document.getElementById('searchForm');
            const searchIcon = document.getElementById('searchIcon');
            const loadingSpinner = document.getElementById('loadingSpinner');
            const historyDropdown = document.getElementById('historyDropdown');
            const historyList = document.getElementById('historyList');
            let debounceTimer;

            function showHistory() {
                const history = JSON.parse(localStorage.getItem('customer_search_history') || '[]');
                if (history.length === 0) { historyDropdown.classList.add('hidden'); return; }
                historyList.innerHTML = history.map(term => `<li class="px-4 py-2 hover:bg-gray-50 cursor-pointer text-sm history-item">${term}</li>`).join('');
                historyDropdown.classList.remove('hidden');
            }

            searchForm.addEventListener('submit', () => {
                const term = searchInput.value.trim();
                if (term.length > 1) {
                    let history = JSON.parse(localStorage.getItem('customer_search_history') || '[]');
                    history = [term, ...history.filter(t => t !== term)].slice(0, 5);
                    localStorage.setItem('customer_search_history', JSON.stringify(history));
                }
            });

            searchInput.addEventListener('focus', showHistory);
            document.addEventListener('click', (e) => { if (!document.getElementById('searchContainer').contains(e.target)) historyDropdown.classList.add('hidden'); });
            historyList.addEventListener('click', (e) => { if (e.target.classList.contains('history-item')) { searchInput.value = e.target.innerText; searchForm.submit(); } });
            document.getElementById('clearHistory').addEventListener('click', () => { localStorage.removeItem('customer_search_history'); historyDropdown.classList.add('hidden'); });

            searchInput.addEventListener('input', () => {
                historyDropdown.classList.add('hidden');
                searchIcon.classList.add('hidden');
                loadingSpinner.classList.remove('hidden');
                clearTimeout(debounceTimer);
                debounceTimer = setTimeout(() => { if(searchInput.value.trim() !== "") searchForm.submit(); }, 500);
            });

            if (searchInput.value.length > 0) {
                const val = searchInput.value; searchInput.value = ''; searchInput.value = val; searchInput.focus();
            }
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/customers/index.blade.php ENDPATH**/ ?>