<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Requirements | <?php echo e(config('app.name', 'IMMIA FINANCE')); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-edit {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        .action-btn-edit:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-delete {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .action-btn-delete:hover {
            background-color: #D83B01;
            color: white;
        }
        .document-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
        }
        .badge-identification {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        .badge-income {
            background-color: #E1F7E9;
            color: #107C10;
        }
        .badge-address {
            background-color: #FEF7E0;
            color: #F68C1E;
        }
        .badge-bank {
            background-color: #F3E8FF;
            color: #8B5CF6;
        }
        .badge-other {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        .modal-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
            z-index: 1000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .modal-overlay.active {
            display: flex !important;
        }
        
        .modal-content {
            background: white;
            border-radius: 8px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 500px;
            margin: 1rem;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            z-index: 1001;
            transform: translateZ(0);
            animation: modalSlideIn 0.3s ease-out;
        }
        
        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-20px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }

        body.no-scroll {
            overflow: hidden;
        }

        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        
        .stat-card {
            transition: transform 0.2s;
        }
        
        .stat-card:hover {
            transform: translateY(-2px);
        }
        
        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
    </style>
</head>
<body class="bg-gray50">
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64">
        
        
        <?php
            // Define variables for header partial
            $pageTitle = 'Application Requirements';
            $pageSubtitle = 'Manage application requirements'; 
        ?>
        
        <?php echo $__env->make('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium"><?php echo e(session('success')); ?></span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-medium"><?php echo e(session('error')); ?></span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2">
                    
                    <div class="bg-white rounded-lg shadow-sm border border-gray200 p-4 mb-6">
                        <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                            
                            
                            <div class="w-full md:w-auto">
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i class="fas fa-search text-gray600"></i>
                                    </div>
                                    <input 
                                        type="text" 
                                        id="toolbarSearchInput" 
                                        class="quickbooks-input pl-10 pr-4 w-full md:w-80" 
                                        placeholder="Search by document name..."
                                    >
                                </div>
                            </div>
                            
                            
                            <div class="flex flex-wrap gap-2 w-full md:w-auto">
                                
                                
                                <button onclick="location.href='<?php echo e(route('admin.accounting.application-requirements.create')); ?>'"
                                        class="px-4 py-2 bg-primary text-white rounded-lg text-sm font-medium hover:bg-primary/90 transition flex items-center space-x-2">
                                    <i class="fas fa-plus"></i>
                                    <span>New Requirement</span>
                                </button>
                                
                                
                                <button id="filterButton" 
                                        type="button" 
                                        class="px-4 py-2 bg-white border border-gray300 rounded-lg text-gray700 hover:bg-gray100 transition flex items-center space-x-2">
                                    <i class="fas fa-filter"></i>
                                    <span>Filter</span>
                                </button>

                                
                                <button onclick="showBulkImportModal()" 
                                        class="px-4 py-2 bg-white border border-gray300 rounded-lg text-gray700 hover:bg-gray100 transition flex items-center space-x-2">
                                    <i class="fas fa-file-import"></i>
                                    <span>Bulk Import</span>
                                </button>
                            </div>

                        </div>
                        
                        <div id="filterOptions" class="hidden mt-4 border-t border-gray200 pt-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="statusFilter" class="block text-sm font-medium text-gray700 mb-1">Status</label>
                                    <select id="statusFilter" class="quickbooks-input">
                                        <option value="">All Status</option>
                                        <option value="active">Active</option>
                                        <option value="inactive">Inactive</option>
                                    </select>
                                </div>
                                <div class="flex items-end">
                                    <button id="clearFilters" type="button" class="px-4 py-2 bg-gray100 border border-gray300 rounded-lg text-gray700 hover:bg-gray200 transition">
                                        Clear Filters
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="bg-white rounded-lg border border-gray200">
                        <div class="flex items-center justify-between p-6 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Document Requirements</h2>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="quickbooks-table">
                                <thead>
                                    <tr>
                                        <th>Document Name</th>
                                        <th>Created By</th>
                                        <th>Created Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $requirements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr data-status="<?php echo e($requirement->status); ?>">
                                        <td>
                                            <div class="font-medium text-gray900"><?php echo e($requirement->documentname); ?></div>
                                            <div class="text-xs text-gray500">REQ-<?php echo e(str_pad($requirement->id, 3, '0', STR_PAD_LEFT)); ?></div>
                                        </td>
                                        <td>
                                            <div class="text-sm text-gray900"><?php echo e($requirement->createdby); ?></div>
                                        </td>
                                        <td>
                                            <div class="text-sm text-gray900"><?php echo e($requirement->createdat_formatted); ?></div>
                                            <div class="text-xs text-gray500">Updated: <?php echo e($requirement->updatedat_formatted); ?></div>
                                        </td>
                                        <td>
                                            <div class="flex items-center space-x-1">
                                                <button onclick="location.href='<?php echo e(route('admin.accounting.application-requirements.edit', $requirement->id)); ?>'" 
                                                        class="action-btn action-btn-edit" title="Edit Requirement">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button onclick="confirmDelete(<?php echo e($requirement->id); ?>)" 
                                                        class="action-btn action-btn-delete" title="Delete Requirement">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center py-12">
                                            <div class="text-center text-gray500">
                                                <i class="fas fa-file-alt text-4xl mb-3"></i>
                                                <p>No application requirements found</p>
                                                <p class="text-sm mt-2">Click "New Requirement" to add document requirements</p>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <?php if($requirements->hasPages()): ?>
                        <div class="p-6 border-t border-gray200">
                            <?php echo e($requirements->links()); ?>

                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div>
                    

                    <div class="bg-white rounded-lg border border-gray200">
                        <div class="p-6 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Quick Add</h2>
                        </div>
                        <div class="p-4">
                            <form method="POST" action="<?php echo e(route('admin.accounting.application-requirements.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="mb-4">
                                    <input type="text" 
                                            name="documentname" 
                                            class="quickbooks-input" 
                                            placeholder="e.g., National ID Card" 
                                            required>
                                    <?php $__errorArgs = ['documentname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <button type="submit" 
                                        class="w-full flex items-center justify-center space-x-2 px-4 py-2 bg-primary text-white rounded-lg text-sm font-medium hover:bg-primary/90">
                                    <i class="fas fa-plus"></i>
                                    <span>Add Requirement</span>
                                </button>
                            </form>
                        </div>
                    </div>

                    <div class="bg-white rounded-lg border border-gray200 mt-6">
                        <div class="p-6 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Guidelines</h2>
                        </div>
                        <div class="p-4">
                            <div class="space-y-3">
                                <div class="flex items-start space-x-3">
                                    <i class="fas fa-check-circle text-green-500 mt-1"></i>
                                    <div>
                                        <p class="text-sm font-medium text-gray900">Clear Naming</p>
                                        <p class="text-xs text-gray600">Use descriptive names for easy identification</p>
                                    </div>
                                </div>
                                <div class="flex items-start space-x-3">
                                    <i class="fas fa-check-circle text-green-500 mt-1"></i>
                                    <div>
                                        <p class="text-sm font-medium text-gray900">Standard Categories</p>
                                        <p class="text-xs text-gray600">Group similar documents under common categories</p>
                                    </div>
                                </div>
                                <div class="flex items-start space-x-3">
                                    <i class="fas fa-check-circle text-green-500 mt-1"></i>
                                    <div>
                                        <p class="text-sm font-medium text-gray900">Regular Review</p>
                                        <p class="text-xs text-gray600">Review requirements quarterly for updates</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <div id="deleteModal" class="modal-overlay">
        <div class="modal-content">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mr-4">
                        <i class="fas fa-exclamation-triangle text-red-600 text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray900">Confirm Deactivation</h3>
                        <p class="text-gray600 text-sm">Are you sure you want to delete this requirement?</p>
                    </div>
                </div>
                <p class="text-sm text-gray600 mb-6">This document requirement will be removed from all loan applications.</p>
                <div class="flex justify-end space-x-3">
                    <button onclick="closeDeleteModal()" 
                            class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                        Cancel
                    </button>
                    <form id="deleteForm" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?> 
                    </form>
                    <button onclick="submitDelete()" 
                            class="px-4 py-2 bg-red-600 text-white rounded text-sm font-medium hover:bg-red-700">
                        Delete Requirement
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div id="bulkImportModal" class="modal-overlay">
        <div class="modal-content">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray900">Bulk Import Requirements</h3>
                    <button onclick="closeBulkImportModal()" class="text-gray400 hover:text-gray600">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <form method="POST" action="<?php echo e(route('admin.accounting.application-requirements.bulk-import')); ?>"> 
                    <?php echo csrf_field(); ?>
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray700 mb-2">
                            Enter requirements (one per line)
                        </label>
                        <textarea name="requirements" 
                                    rows="8"
                                    class="quickbooks-input resize-none"
                                    placeholder="Example:
National ID Card
Passport
Driver's License
Recent Payslip
Bank Statement (3 months)
Utility Bill
"></textarea>
                        <p class="text-xs text-gray600 mt-2">
                            Enter each document requirement on a new line. Existing requirements will be skipped.
                        </p>
                    </div>
                    <div class="flex justify-end space-x-3">
                        <button type="button" 
                                onclick="closeBulkImportModal()"
                                class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="px-4 py-2 bg-primary text-white rounded text-sm font-medium hover:bg-primary/90">
                            Import Requirements
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Auto-hide alerts logic
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
            
            // Search functionality
            const toolbarSearchInput = document.getElementById('toolbarSearchInput');
            
            const handleSearch = function(e) {
                const searchTerm = e.target.value.toLowerCase();
                const rows = document.querySelectorAll('.quickbooks-table tbody tr');
                
                rows.forEach(row => {
                    const text = row.textContent.toLowerCase();
                    if (text.includes(searchTerm)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            };

            if (toolbarSearchInput) {
                toolbarSearchInput.addEventListener('keyup', handleSearch);
            }
            
            // FILTER Logic
            const filterButton = document.getElementById('filterButton');
            const filterOptions = document.getElementById('filterOptions');
            const statusFilter = document.getElementById('statusFilter');
            const tableRows = document.querySelectorAll('.quickbooks-table tbody tr');
            
            function filterTable() {
                const selectedStatus = statusFilter?.value || '';
                
                tableRows.forEach(row => {
                    const status = row.getAttribute('data-status'); 
                    
                    let showRow = true;
                    
                    if (selectedStatus && status !== selectedStatus) {
                        showRow = false;
                    }
                    
                    row.style.display = showRow ? '' : 'none';
                });
            }
            
            if (filterButton) {
                filterButton.addEventListener('click', function() {
                    filterOptions.classList.toggle('hidden');
                });
            }

            if (statusFilter) {
                statusFilter.addEventListener('change', filterTable);
            }

            document.getElementById('clearFilters')?.addEventListener('click', function() {
                if (statusFilter) statusFilter.value = '';
                filterTable();
                filterOptions.classList.add('hidden');
            });


            // DELETE/DEACTIVATE Modal Functions
            let requirementToDelete = null;
            
            window.confirmDelete = function(requirementId) {
                requirementToDelete = requirementId;
                const modal = document.getElementById('deleteModal');
                modal.classList.add('active');
                document.body.classList.add('no-scroll');
            }
            
            window.closeDeleteModal = function() {
                const modal = document.getElementById('deleteModal');
                modal.classList.remove('active');
                document.body.classList.remove('no-scroll');
                requirementToDelete = null;
            }
            
            window.submitDelete = function() {
                if (requirementToDelete) {
                    const form = document.getElementById('deleteForm');
                    form.action = '<?php echo e(url('admin/accounting/application-requirements')); ?>/' + requirementToDelete; 
                    form.submit();
                }
            }
            
            // BULK IMPORT Modal Functions
            window.showBulkImportModal = function() {
                const modal = document.getElementById('bulkImportModal');
                modal.classList.add('active');
                document.body.classList.add('no-scroll');
            }
            
            window.closeBulkImportModal = function() {
                const modal = document.getElementById('bulkImportModal');
                modal.classList.remove('active');
                document.body.classList.remove('no-scroll');
            }
            
            // Close modal when clicking outside
            document.addEventListener('click', function(event) {
                const deleteModal = document.getElementById('deleteModal');
                const bulkModal = document.getElementById('bulkImportModal');
                
                if (deleteModal.classList.contains('active')) {
                    const deleteContent = deleteModal.querySelector('.modal-content');
                    if (!deleteContent.contains(event.target) && !event.target.closest('[onclick*="confirmDelete"]')) {
                        closeDeleteModal();
                    }
                }
                
                if (bulkModal.classList.contains('active')) {
                    const bulkContent = bulkModal.querySelector('.modal-content');
                    if (!bulkContent.contains(event.target) && !event.target.closest('[onclick*="showBulkImportModal"]')) {
                        closeBulkImportModal();
                    }
                }
            });
            
            // Close modal with Escape key
            document.addEventListener('keydown', function(event) {
                if (event.key === 'Escape') {
                    closeDeleteModal();
                    closeBulkImportModal();
                }
            });
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/accounting/applicationrequirements/index.blade.php ENDPATH**/ ?>