<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payroll Preparation | <?php echo e(config('app.name', 'IMMIA FINANCE')); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
    </style>
</head>
<body class="bg-gray50">
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64">
        <?php echo $__env->make('accounting.partials.header', ['title' => 'Payroll Preparation', 'subtitle' => 'Prepare payroll for processing'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <!-- Success/Error Messages -->
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold"><?php echo e(session('success')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold"><?php echo e(session('error')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Back Button -->
            <div class="mb-6">
                <a href="<?php echo e(route('admin.accounting.payroll.index')); ?>" 
                   class="text-primary hover:text-primary/90 font-medium text-sm flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Payroll Dashboard
                </a>
            </div>

            <!-- Header Section -->
            <div class="bg-white rounded-lg border border-gray200 p-6 mb-6">
                <div class="flex flex-col md:flex-row md:items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray900">Payroll Preparation</h1>
                        <p class="text-gray600 mt-2">
                            Review and prepare payroll periods before processing. Select a period to view preliminary summary.
                        </p>
                    </div>
                    <div class="mt-4 md:mt-0 flex items-center space-x-4">
                        <?php if($currentFinancialYear): ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                                <i class="fas fa-calendar-alt mr-2"></i>
                                <?php echo e($currentFinancialYear->year); ?>

                            </span>
                        <?php else: ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-yellow-100 text-yellow-800">
                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                No Financial Year Selected
                            </span>
                        <?php endif; ?>
                        <a href="<?php echo e(route('admin.accounting.payroll.periods.index')); ?>" 
                           class="border border-gray300 text-gray700 px-4 py-2 rounded text-sm font-medium hover:bg-gray50 flex items-center">
                            <i class="fas fa-calendar-plus mr-2"></i>Manage Periods
                        </a>
                    </div>
                </div>
            </div>

            <!-- All Payroll Periods -->
            <div class="bg-white rounded-lg border border-gray200 overflow-hidden mb-6">
                <div class="border-b border-gray200 p-6">
                    <h3 class="text-lg font-semibold text-gray900">All Payroll Periods</h3>
                    <p class="text-gray600 text-sm mt-1">Select a period to prepare payroll</p>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="quickbooks-table">
                        <thead>
                            <tr>
                                <th>Period</th>
                                <th>Date Range</th>
                                <th>Payment Date</th>
                                <th>Status</th>
                                <th>Cutoff Date</th>
                                <th>Adjustments</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $payrollPeriods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $period): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-gray100 transition-colors">
                                    <td class="font-medium text-gray900">
                                        <div class="flex items-center">
                                            <div class="w-10 h-10 bg-blue-50 rounded-lg flex items-center justify-center mr-3">
                                                <i class="fas fa-calendar text-blue-600"></i>
                                            </div>
                                            <div>
                                                <div><?php echo e($period->period_name); ?></div>
                                                <div class="text-xs text-gray500"><?php echo e($period->period_type_name); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-gray700">
                                        <?php echo e($period->start_date->format('M d, Y')); ?> - <?php echo e($period->end_date->format('M d, Y')); ?>

                                    </td>
                                    <td class="text-gray700">
                                        <?php echo e($period->payment_date->format('M d, Y')); ?>

                                    </td>
                                    <td>
                                        <?php echo $period->status_badge; ?>

                                    </td>
                                    <td class="text-gray700">
                                        <?php echo e($period->cutoff_date->format('M d, Y')); ?>

                                    </td>
                                    <td>
                                        <div class="flex flex-col space-y-1">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                <?php echo e(($periodAdjustmentsCount[$period->id] ?? 0) > 0 ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                                                <i class="fas fa-file-invoice-dollar mr-1"></i>
                                                <?php echo e($periodAdjustmentsCount[$period->id] ?? 0); ?>

                                            </span>
                                            <?php if(($periodAdjustmentsCount[$period->id] ?? 0) > 0): ?>
                                                <a href="<?php echo e(route('admin.accounting.payroll.preparation.create', $period->id)); ?>" 
                                                   class="text-xs text-primary hover:text-primary/90">
                                                    View Adjustments
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="flex items-center space-x-2">
                                            <?php if($period->status === 'open'): ?>
                                                <!-- "Prepare Payroll" button for open periods -->
                                                <a href="<?php echo e(route('admin.accounting.payroll.preparation.preliminary-summary', $period->id)); ?>" 
                                                   class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center">
                                                    <i class="fas fa-edit mr-2"></i>Prepare Payroll
                                                </a>
                                            <?php else: ?>
                                                <span class="text-gray-500 text-sm">
                                                    <?php if($period->status === 'closed'): ?>
                                                        Period Closed
                                                    <?php elseif($period->status === 'processing'): ?>
                                                        Processing
                                                    <?php endif; ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="py-8 text-center">
                                        <div id="emptyState" class="py-16 text-center">
                                            <div class="w-16 h-16 bg-gray100 rounded-full flex items-center justify-center mx-auto mb-4">
                                                <i class="fas fa-calendar-times text-gray500 text-2xl"></i>
                                            </div>
                                            <h3 class="text-lg font-medium text-gray900 mb-2">No payroll periods found</h3>
                                            <p class="text-gray600 mb-6 max-w-md mx-auto">Create payroll periods to get started with payroll preparation.</p>
                                            <div class="space-x-3">
                                                <a href="<?php echo e(route('admin.accounting.payroll.periods.index')); ?>" 
                                                   class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90">
                                                    <i class="fas fa-calendar-plus mr-2"></i>Create Periods
                                                </a>
                                                <?php if($currentFinancialYear): ?>
                                                    <a href="<?php echo e(route('admin.accounting.payroll.periods.generate')); ?>" 
                                                       class="border border-gray300 text-gray700 px-4 py-2 rounded text-sm font-medium hover:bg-gray50">
                                                        <i class="fas fa-sync-alt mr-2"></i>Generate Monthly Periods
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if($payrollPeriods->hasPages()): ?>
                    <div class="border-t border-gray200 px-6 py-4">
                        <?php echo e($payrollPeriods->links()); ?>

                    </div>
                <?php endif; ?>
            </div>

            <!-- Quick Stats -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-lg border border-gray200 p-4">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-calendar-alt text-blue-600 text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray600">Total Periods</p>
                            <p class="text-xl font-semibold text-gray900"><?php echo e($payrollPeriods->total() ?? 0); ?></p>
                        </div>
                    </div>
                </div>
                <div class="bg-white rounded-lg border border-gray200 p-4">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-unlock text-green-600 text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray600">Open Periods</p>
                            <p class="text-xl font-semibold text-gray900"><?php echo e($payrollPeriods->where('status', 'open')->count() ?? 0); ?></p>
                        </div>
                    </div>
                </div>
                <div class="bg-white rounded-lg border border-gray200 p-4">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-lock text-gray-600 text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray600">Closed Periods</p>
                            <p class="text-xl font-semibold text-gray900"><?php echo e($payrollPeriods->where('status', 'closed')->count() ?? 0); ?></p>
                        </div>
                    </div>
                </div>
                <div class="bg-white rounded-lg border border-gray200 p-4">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-sync-alt text-yellow-600 text-lg"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray600">Processing</p>
                            <p class="text-xl font-semibold text-gray900"><?php echo e($payrollPeriods->where('status', 'processing')->count() ?? 0); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Information Cards -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- How to Prepare Payroll -->
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <i class="fas fa-clipboard-check text-blue-400 text-xl"></i>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-blue-800">How to Prepare Payroll</h3>
                            <div class="mt-2 text-sm text-blue-700">
                                <ol class="list-decimal pl-5 space-y-2">
                                    <li>Select an <strong>open period</strong> and click "Prepare Payroll"</li>
                                    <li>Review the preliminary summary of all employees</li>
                                    <li>Click "Adjustments" to add one-time earnings/deductions</li>
                                    <li>Approve adjustments for payroll processing</li>
                                    <li>Once all adjustments are ready, proceed to "Process Payroll"</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- About Adjustments -->
                <div class="bg-green-50 border border-green-200 rounded-lg p-6">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <i class="fas fa-file-invoice-dollar text-green-400 text-xl"></i>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-green-800">About Payroll Adjustments</h3>
                            <div class="mt-2 text-sm text-green-700">
                                <ul class="list-disc pl-5 space-y-1">
                                    <li>Add one-time items like overtime, bonuses, or special allowances</li>
                                    <li>Make corrections or additional payments for specific employees</li>
                                    <li>Adjustments are only applied to the selected period</li>
                                    <li>Must be approved before payroll processing</li>
                                    <li>Regular employee earnings are automatically included</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Fullscreen Modal Container -->
    <div id="fullscreenModalContainer"></div>

    <script>
        // Function to open fullscreen modal
        function openFullscreenModal(url) {
            // Show loading
            document.getElementById('fullscreenModalContainer').innerHTML = `
                <div class="fixed inset-0 bg-white z-9999">
                    <div class="p-6">
                        <div class="text-center py-8">
                            <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-primary"></div>
                            <p class="mt-2 text-sm text-gray600">Loading...</p>
                        </div>
                    </div>
                </div>
            `;
            
            // Load modal content
            fetch(url, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.text())
            .then(html => {
                document.getElementById('fullscreenModalContainer').innerHTML = html;
                // Add styles for fullscreen modal
                const modal = document.querySelector('#fullscreenModalContainer > div');
                if (modal) {
                    modal.classList.add('fixed', 'inset-0', 'bg-white', 'z-9999', 'overflow-y-auto');
                }
            })
            .catch(error => {
                console.error('Error loading modal:', error);
                document.getElementById('fullscreenModalContainer').innerHTML = `
                    <div class="fixed inset-0 bg-white z-9999">
                        <div class="p-6">
                            <div class="text-center py-8 text-red-500">
                                <i class="fas fa-exclamation-triangle text-2xl mb-2"></i>
                                <p>Failed to load content</p>
                                <button onclick="closeFullscreenModal()" class="mt-4 bg-primary text-white px-4 py-2 rounded">
                                    Close
                                </button>
                            </div>
                        </div>
                    </div>
                `;
            });
        }
        
        // Function to close fullscreen modal
        function closeFullscreenModal() {
            document.getElementById('fullscreenModalContainer').innerHTML = '';
        }
        
        // Close modal on escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeFullscreenModal();
            }
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/accounting/payroll/preparation/index.blade.php ENDPATH**/ ?>